"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
const language_core_1 = require("@vue/language-core");
const utils_1 = require("../utils");
function create() {
    return {
        name: 'vue-suggest-define-assignment',
        capabilities: {
            completionProvider: {},
        },
        create(context) {
            return {
                isAdditionalCompletion: true,
                async provideCompletionItems(document) {
                    const info = (0, utils_1.getEmbeddedInfo)(context, document, id => id.startsWith('script_'));
                    if (!info) {
                        return;
                    }
                    const { virtualCode, root } = info;
                    const enabled = await context.env.getConfiguration?.('vue.suggest.defineAssignment') ?? true;
                    if (!enabled) {
                        return;
                    }
                    const { sfc } = root;
                    const codegen = language_core_1.tsCodegen.get(sfc);
                    const scriptSetup = sfc.scriptSetup;
                    const scriptSetupRanges = codegen?.getScriptSetupRanges();
                    if (!scriptSetup || !scriptSetupRanges) {
                        return;
                    }
                    const result = [];
                    const mappings = [...context.language.maps.forEach(virtualCode)];
                    addDefineCompletionItem(scriptSetupRanges.defineProps?.statement, scriptSetupRanges.withDefaults?.exp ?? scriptSetupRanges.defineProps?.exp, 'props');
                    addDefineCompletionItem(scriptSetupRanges.defineEmits?.statement, scriptSetupRanges.defineEmits?.exp, 'emit');
                    addDefineCompletionItem(scriptSetupRanges.defineSlots?.statement, scriptSetupRanges.defineSlots?.exp, 'slots');
                    return {
                        isIncomplete: false,
                        items: result,
                    };
                    function addDefineCompletionItem(statement, exp, name) {
                        if (!exp || exp.start !== statement?.start) {
                            return;
                        }
                        let offset;
                        for (const [, map] of mappings) {
                            for (const [generatedOffset] of map.toGeneratedLocation(scriptSetup.startTagEnd + exp.start)) {
                                offset = generatedOffset;
                                break;
                            }
                        }
                        if (offset === undefined) {
                            return;
                        }
                        const pos = document.positionAt(offset);
                        result.push({
                            label: name,
                            kind: 6,
                            commitCharacters: ['.', ',', ';'],
                            additionalTextEdits: [{
                                    newText: `const ${name} = `,
                                    range: {
                                        start: pos,
                                        end: pos,
                                    },
                                }],
                        });
                    }
                },
            };
        },
    };
}
//# sourceMappingURL=vue-suggest-define-assignment.js.map