"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
const language_core_1 = require("@vue/language-core");
const vscode_uri_1 = require("vscode-uri");
function create(getDocumentHighlights) {
    return {
        name: 'vue-document-highlights',
        capabilities: {
            documentHighlightProvider: true,
        },
        create(context) {
            return {
                async provideDocumentHighlights(document, position) {
                    const uri = vscode_uri_1.URI.parse(document.uri);
                    const decoded = context.decodeEmbeddedDocumentUri(uri);
                    const sourceScript = decoded && context.language.scripts.get(decoded[0]);
                    const virtualCode = decoded && sourceScript?.generated?.embeddedCodes.get(decoded[1]);
                    if (!sourceScript?.generated || virtualCode?.id !== 'main') {
                        return;
                    }
                    const root = sourceScript.generated.root;
                    if (!(root instanceof language_core_1.VueVirtualCode)) {
                        return;
                    }
                    const result = await getDocumentHighlights(root.fileName, document.offsetAt(position));
                    return result
                        ?.filter(({ fileName }) => fileName === root.fileName)
                        .flatMap(({ highlightSpans }) => highlightSpans)
                        .map(({ textSpan, kind }) => ({
                        range: {
                            start: document.positionAt(textSpan.start),
                            end: document.positionAt(textSpan.start + textSpan.length),
                        },
                        kind: kind === 'reference'
                            ? 2
                            : kind === 'writtenReference'
                                ? 3
                                : 1,
                    }));
                },
            };
        },
    };
}
//# sourceMappingURL=vue-document-highlights.js.map