/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.catalina.manager.Constants;
import org.apache.tomcat.util.json.JSONFilter;
import org.apache.tomcat.util.security.Escape;

public class StatusTransformer {
    public static void setContentType(HttpServletResponse httpServletResponse, int n) {
        if (n == 0) {
            httpServletResponse.setContentType("text/html;charset=utf-8");
        } else if (n == 1) {
            httpServletResponse.setContentType("text/xml;charset=utf-8");
        } else if (n == 2) {
            httpServletResponse.setContentType("application/json;charset=utf-8");
        }
    }

    public static void writeHeader(PrintWriter printWriter, Object[] objectArray, int n) {
        if (n == 0) {
            printWriter.print(MessageFormat.format(Constants.HTML_HEADER_SECTION, objectArray));
        } else if (n == 1) {
            printWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            printWriter.print(MessageFormat.format("<?xml-stylesheet type=\"text/xsl\" href=\"{0}/xform.xsl\" ?>\n", objectArray));
            printWriter.write("<status>");
        } else if (n == 2) {
            printWriter.append('{').append('\"').append("tomcat").append('\"').append(':').append('{').println();
        }
    }

    public static void writeBody(PrintWriter printWriter, Object[] objectArray, int n) {
        if (n == 0) {
            printWriter.print(MessageFormat.format(Constants.BODY_HEADER_SECTION, objectArray));
        }
    }

    public static void writeManager(PrintWriter printWriter, Object[] objectArray, int n) {
        if (n == 0) {
            printWriter.print(MessageFormat.format(Constants.MANAGER_SECTION, objectArray));
        }
    }

    public static void writePageHeading(PrintWriter printWriter, Object[] objectArray, int n) {
        if (n == 0) {
            printWriter.print(MessageFormat.format(Constants.SERVER_HEADER_SECTION, objectArray));
        }
    }

    public static void writeServerInfo(PrintWriter printWriter, Object[] objectArray, int n) {
        if (n == 0) {
            printWriter.print(MessageFormat.format(Constants.SERVER_ROW_SECTION, objectArray));
        }
    }

    public static void writeFooter(PrintWriter printWriter, int n) {
        if (n == 0) {
            printWriter.print(Constants.HTML_TAIL_SECTION);
        } else if (n == 1) {
            printWriter.write("</status>");
        } else if (n == 2) {
            printWriter.append('}').append('}');
        }
    }

    public static void writeVMState(PrintWriter printWriter, int n, Object[] objectArray) throws Exception {
        Object object2;
        TreeMap<CallSite, MemoryPoolMXBean> treeMap = new TreeMap<CallSite, MemoryPoolMXBean>();
        for (MemoryPoolMXBean object2 : ManagementFactory.getMemoryPoolMXBeans()) {
            object2 = String.valueOf((Object)object2.getType()) + ":" + object2.getName();
            treeMap.put((CallSite)object2, object2);
        }
        if (n == 0) {
            printWriter.print("<h1>JVM</h1>");
            printWriter.print("<p>");
            printWriter.print(objectArray[0]);
            printWriter.print(' ');
            printWriter.print(StatusTransformer.formatSize(Runtime.getRuntime().freeMemory(), true));
            printWriter.print(' ');
            printWriter.print(objectArray[1]);
            printWriter.print(' ');
            printWriter.print(StatusTransformer.formatSize(Runtime.getRuntime().totalMemory(), true));
            printWriter.print(' ');
            printWriter.print(objectArray[2]);
            printWriter.print(' ');
            printWriter.print(StatusTransformer.formatSize(Runtime.getRuntime().maxMemory(), true));
            printWriter.print("</p>");
            printWriter.write("<table border=\"0\"><thead><tr><th>" + String.valueOf(objectArray[3]) + "</th><th>" + String.valueOf(objectArray[4]) + "</th><th>" + String.valueOf(objectArray[5]) + "</th><th>" + String.valueOf(objectArray[6]) + "</th><th>" + String.valueOf(objectArray[7]) + "</th><th>" + String.valueOf(objectArray[8]) + "</th></tr></thead><tbody>");
            for (MemoryPoolMXBean memoryPoolMXBean : treeMap.values()) {
                object2 = memoryPoolMXBean.getUsage();
                printWriter.write("<tr><td>");
                printWriter.print(memoryPoolMXBean.getName());
                printWriter.write("</td><td>");
                printWriter.print((Object)memoryPoolMXBean.getType());
                printWriter.write("</td><td>");
                printWriter.print(StatusTransformer.formatSize(((MemoryUsage)object2).getInit(), true));
                printWriter.write("</td><td>");
                printWriter.print(StatusTransformer.formatSize(((MemoryUsage)object2).getCommitted(), true));
                printWriter.write("</td><td>");
                printWriter.print(StatusTransformer.formatSize(((MemoryUsage)object2).getMax(), true));
                printWriter.write("</td><td>");
                printWriter.print(StatusTransformer.formatSize(((MemoryUsage)object2).getUsed(), true));
                if (((MemoryUsage)object2).getMax() > 0L) {
                    printWriter.write(" (" + ((MemoryUsage)object2).getUsed() * 100L / ((MemoryUsage)object2).getMax() + "%)");
                }
                printWriter.write("</td></tr>");
            }
            printWriter.write("</tbody></table>");
        } else if (n == 1) {
            printWriter.write("<jvm>");
            printWriter.write("<memory");
            printWriter.write(" free='" + Runtime.getRuntime().freeMemory() + "'");
            printWriter.write(" total='" + Runtime.getRuntime().totalMemory() + "'");
            printWriter.write(" max='" + Runtime.getRuntime().maxMemory() + "'/>");
            for (MemoryPoolMXBean memoryPoolMXBean : treeMap.values()) {
                object2 = memoryPoolMXBean.getUsage();
                printWriter.write("<memorypool");
                printWriter.write(" name='" + Escape.xml((String)"", (String)memoryPoolMXBean.getName()) + "'");
                printWriter.write(" type='" + String.valueOf((Object)memoryPoolMXBean.getType()) + "'");
                printWriter.write(" usageInit='" + ((MemoryUsage)object2).getInit() + "'");
                printWriter.write(" usageCommitted='" + ((MemoryUsage)object2).getCommitted() + "'");
                printWriter.write(" usageMax='" + ((MemoryUsage)object2).getMax() + "'");
                printWriter.write(" usageUsed='" + ((MemoryUsage)object2).getUsed() + "'/>");
            }
            printWriter.write("</jvm>");
        } else if (n == 2) {
            StatusTransformer.indent(printWriter, 1).append('\"').append("jvm").append('\"').append(':').append('{').println();
            StatusTransformer.indent(printWriter, 2).append('\"').append("memory").append('\"').append(':').append('{');
            StatusTransformer.appendJSonValue(printWriter, "free", Runtime.getRuntime().freeMemory()).append(',');
            StatusTransformer.appendJSonValue(printWriter, "total", Runtime.getRuntime().totalMemory()).append(',');
            StatusTransformer.appendJSonValue(printWriter, "max", Runtime.getRuntime().maxMemory());
            printWriter.append('}').append(',').println();
            StatusTransformer.indent(printWriter, 2).append('\"').append("memorypool").append('\"').append(':').append('[');
            boolean bl = true;
            for (Object object2 : treeMap.values()) {
                MemoryUsage memoryUsage = object2.getUsage();
                if (bl) {
                    bl = false;
                    printWriter.println();
                } else {
                    printWriter.append(',').println();
                }
                StatusTransformer.indent(printWriter, 3).append('{');
                StatusTransformer.appendJSonValue(printWriter, "name", JSONFilter.escape((String)object2.getName())).append(',');
                StatusTransformer.appendJSonValue(printWriter, "type", object2.getType().toString()).append(',');
                StatusTransformer.appendJSonValue(printWriter, "usageInit", memoryUsage.getInit()).append(',');
                StatusTransformer.appendJSonValue(printWriter, "usageCommitted", memoryUsage.getCommitted()).append(',');
                StatusTransformer.appendJSonValue(printWriter, "usageMax", memoryUsage.getMax()).append(',');
                StatusTransformer.appendJSonValue(printWriter, "usageUsed", memoryUsage.getUsed());
                printWriter.append('}');
            }
            printWriter.println();
            StatusTransformer.indent(printWriter, 2).append(']').println();
            StatusTransformer.indent(printWriter, 1).append('}');
        }
    }

    private static PrintWriter appendJSonValue(PrintWriter printWriter, String string, Object object) {
        printWriter.append('\"').append(string).append('\"').append(':');
        if (object instanceof Number) {
            return printWriter.append(object.toString());
        }
        return printWriter.append('\"').append(object.toString()).append('\"');
    }

    private static PrintWriter indent(PrintWriter printWriter, int n) {
        for (int i = 0; i < n; ++i) {
            printWriter.append(' ').append(' ');
        }
        return printWriter;
    }

    public static void writeConnectorsState(PrintWriter printWriter, MBeanServer mBeanServer, List<ObjectName> list, List<ObjectName> list2, List<ObjectName> list3, int n, Object[] objectArray) throws Exception {
        if (n == 2) {
            printWriter.append(',').println();
            StatusTransformer.indent(printWriter, 1).append('\"').append("connector").append('\"').append(':').append('[').println();
        }
        boolean bl = true;
        for (ObjectName objectName : list) {
            if (bl) {
                bl = false;
            } else if (n == 2) {
                printWriter.append(',').println();
            }
            String string = objectName.getKeyProperty("name");
            StatusTransformer.writeConnectorState(printWriter, objectName, string, mBeanServer, list2, list3, n, objectArray);
        }
        if (n == 2) {
            printWriter.append(']');
        }
    }

    public static void writeConnectorState(PrintWriter printWriter, ObjectName objectName, String string, MBeanServer mBeanServer, List<ObjectName> list, List<ObjectName> list2, int n, Object[] objectArray) throws Exception {
        if (n == 0) {
            printWriter.print("<h1>");
            printWriter.print(string);
            printWriter.print("</h1>");
            printWriter.print("<p>");
            printWriter.print(objectArray[0]);
            printWriter.print(' ');
            printWriter.print(mBeanServer.getAttribute(objectName, "maxThreads"));
            printWriter.print(' ');
            printWriter.print(objectArray[1]);
            printWriter.print(' ');
            printWriter.print(mBeanServer.getAttribute(objectName, "currentThreadCount"));
            printWriter.print(' ');
            printWriter.print(objectArray[2]);
            printWriter.print(' ');
            printWriter.print(mBeanServer.getAttribute(objectName, "currentThreadsBusy"));
            printWriter.print(' ');
            printWriter.print(objectArray[3]);
            printWriter.print(' ');
            printWriter.print(mBeanServer.getAttribute(objectName, "keepAliveCount"));
            printWriter.print("<br>");
            ObjectName objectName2 = null;
            for (ObjectName objectName3 : list) {
                if (!string.equals(objectName3.getKeyProperty("name")) || objectName3.getKeyProperty("Upgrade") != null) continue;
                objectName2 = objectName3;
            }
            if (objectName2 == null) {
                return;
            }
            printWriter.print(objectArray[4]);
            printWriter.print(' ');
            printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName2, "maxTime"), false));
            printWriter.print(' ');
            printWriter.print(objectArray[5]);
            printWriter.print(' ');
            printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName2, "processingTime"), true));
            printWriter.print(' ');
            printWriter.print(objectArray[6]);
            printWriter.print(' ');
            printWriter.print(mBeanServer.getAttribute(objectName2, "requestCount"));
            printWriter.print(' ');
            printWriter.print(objectArray[7]);
            printWriter.print(' ');
            printWriter.print(mBeanServer.getAttribute(objectName2, "errorCount"));
            printWriter.print(' ');
            printWriter.print(objectArray[8]);
            printWriter.print(' ');
            printWriter.print(StatusTransformer.formatSize(mBeanServer.getAttribute(objectName2, "bytesReceived"), true));
            printWriter.print(' ');
            printWriter.print(objectArray[9]);
            printWriter.print(' ');
            printWriter.print(StatusTransformer.formatSize(mBeanServer.getAttribute(objectName2, "bytesSent"), true));
            printWriter.print("</p>");
            printWriter.print("<table border=\"0\"><tr><th>" + String.valueOf(objectArray[10]) + "</th><th>" + String.valueOf(objectArray[11]) + "</th><th>" + String.valueOf(objectArray[12]) + "</th><th>" + String.valueOf(objectArray[13]) + "</th><th>" + String.valueOf(objectArray[14]) + "</th><th>" + String.valueOf(objectArray[15]) + "</th><th>" + String.valueOf(objectArray[16]) + "</th><th>" + String.valueOf(objectArray[17]) + "</th></tr>");
            for (ObjectName objectName3 : list2) {
                if (!string.equals(StatusTransformer.getConnectorName(objectName3.getKeyProperty("worker")))) continue;
                printWriter.print("<tr>");
                StatusTransformer.writeProcessorState(printWriter, objectName3, mBeanServer, n);
                printWriter.print("</tr>");
            }
            printWriter.print("</table>");
            printWriter.print("<p>");
            printWriter.print(objectArray[18]);
            printWriter.print("</p>");
        } else if (n == 1) {
            printWriter.write("<connector name='" + string + "'>");
            printWriter.write("<threadInfo ");
            printWriter.write(" maxThreads=\"" + String.valueOf(mBeanServer.getAttribute(objectName, "maxThreads")) + "\"");
            printWriter.write(" currentThreadCount=\"" + String.valueOf(mBeanServer.getAttribute(objectName, "currentThreadCount")) + "\"");
            printWriter.write(" currentThreadsBusy=\"" + String.valueOf(mBeanServer.getAttribute(objectName, "currentThreadsBusy")) + "\"");
            printWriter.write(" />");
            ObjectName objectName4 = null;
            for (ObjectName objectName5 : list) {
                if (!string.equals(objectName5.getKeyProperty("name")) || objectName5.getKeyProperty("Upgrade") != null) continue;
                objectName4 = objectName5;
            }
            if (objectName4 != null) {
                printWriter.write("<requestInfo ");
                printWriter.write(" maxTime=\"" + String.valueOf(mBeanServer.getAttribute(objectName4, "maxTime")) + "\"");
                printWriter.write(" processingTime=\"" + String.valueOf(mBeanServer.getAttribute(objectName4, "processingTime")) + "\"");
                printWriter.write(" requestCount=\"" + String.valueOf(mBeanServer.getAttribute(objectName4, "requestCount")) + "\"");
                printWriter.write(" errorCount=\"" + String.valueOf(mBeanServer.getAttribute(objectName4, "errorCount")) + "\"");
                printWriter.write(" bytesReceived=\"" + String.valueOf(mBeanServer.getAttribute(objectName4, "bytesReceived")) + "\"");
                printWriter.write(" bytesSent=\"" + String.valueOf(mBeanServer.getAttribute(objectName4, "bytesSent")) + "\"");
                printWriter.write(" />");
                printWriter.write("<workers>");
                for (ObjectName objectName5 : list2) {
                    if (!string.equals(StatusTransformer.getConnectorName(objectName5.getKeyProperty("worker")))) continue;
                    StatusTransformer.writeProcessorState(printWriter, objectName5, mBeanServer, n);
                }
                printWriter.write("</workers>");
            }
            printWriter.write("</connector>");
        } else if (n == 2) {
            StatusTransformer.indent(printWriter, 2).append('{').println();
            StatusTransformer.indent(printWriter, 3);
            String string2 = JSONFilter.escape((String)string);
            if (string2.length() > 4 && string2.startsWith("\\\"") && string2.endsWith("\\\"")) {
                string2 = string2.substring(2, string2.length() - 2);
            }
            StatusTransformer.appendJSonValue(printWriter, "name", string2).append(',').println();
            StatusTransformer.indent(printWriter, 3).append('\"').append("threadInfo").append('\"').append(':').append('{');
            StatusTransformer.appendJSonValue(printWriter, "maxThreads", mBeanServer.getAttribute(objectName, "maxThreads")).append(',');
            StatusTransformer.appendJSonValue(printWriter, "currentThreadCount", mBeanServer.getAttribute(objectName, "currentThreadCount")).append(',');
            StatusTransformer.appendJSonValue(printWriter, "currentThreadsBusy", mBeanServer.getAttribute(objectName, "currentThreadsBusy"));
            printWriter.append('}');
            ObjectName objectName6 = null;
            for (ObjectName objectName7 : list) {
                if (!string.equals(objectName7.getKeyProperty("name")) || objectName7.getKeyProperty("Upgrade") != null) continue;
                objectName6 = objectName7;
            }
            if (objectName6 != null) {
                printWriter.append(',').println();
                StatusTransformer.indent(printWriter, 3).append('\"').append("requestInfo").append('\"').append(':').append('{');
                StatusTransformer.appendJSonValue(printWriter, "maxTime", mBeanServer.getAttribute(objectName6, "maxTime")).append(',');
                StatusTransformer.appendJSonValue(printWriter, "processingTime", mBeanServer.getAttribute(objectName6, "processingTime")).append(',');
                StatusTransformer.appendJSonValue(printWriter, "requestCount", mBeanServer.getAttribute(objectName6, "requestCount")).append(',');
                StatusTransformer.appendJSonValue(printWriter, "errorCount", mBeanServer.getAttribute(objectName6, "errorCount")).append(',');
                StatusTransformer.appendJSonValue(printWriter, "bytesReceived", mBeanServer.getAttribute(objectName6, "bytesReceived")).append(',');
                StatusTransformer.appendJSonValue(printWriter, "bytesSent", mBeanServer.getAttribute(objectName6, "bytesSent"));
                printWriter.append('}').println();
            }
            StatusTransformer.indent(printWriter, 2).append('}');
        }
    }

    protected static String getConnectorName(String string) {
        if (string.indexOf("-auto-") > 0) {
            return string.substring(0, string.lastIndexOf("-")) + "\"";
        }
        return string;
    }

    protected static void writeProcessorState(PrintWriter printWriter, ObjectName objectName, MBeanServer mBeanServer, int n) throws Exception {
        String string;
        Integer n2 = (Integer)mBeanServer.getAttribute(objectName, "stage");
        int n3 = n2;
        boolean bl = true;
        boolean bl2 = true;
        switch (n3) {
            case 1: {
                string = "P";
                bl = false;
                break;
            }
            case 2: {
                string = "P";
                bl = false;
                break;
            }
            case 3: {
                string = "S";
                break;
            }
            case 4: {
                string = "F";
                break;
            }
            case 5: {
                string = "F";
                break;
            }
            case 7: {
                string = "R";
                bl = false;
                break;
            }
            case 6: {
                string = "K";
                bl2 = false;
                break;
            }
            case 0: {
                string = "R";
                bl = false;
                break;
            }
            default: {
                string = "?";
                bl = false;
            }
        }
        if (n == 0) {
            printWriter.write("<td><strong>");
            printWriter.write(string);
            printWriter.write("</strong></td>");
            if (bl) {
                printWriter.write("<td>");
                printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "requestProcessingTime"), false));
                printWriter.write("</td>");
                printWriter.write("<td>");
                if (bl2) {
                    printWriter.print(StatusTransformer.formatSize(mBeanServer.getAttribute(objectName, "requestBytesSent"), false));
                } else {
                    printWriter.write("?");
                }
                printWriter.write("</td>");
                printWriter.write("<td>");
                if (bl2) {
                    printWriter.print(StatusTransformer.formatSize(mBeanServer.getAttribute(objectName, "requestBytesReceived"), false));
                } else {
                    printWriter.write("?");
                }
                printWriter.write("</td>");
                printWriter.write("<td>");
                printWriter.print(Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "remoteAddrForwarded")));
                printWriter.write("</td>");
                printWriter.write("<td>");
                printWriter.print(Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "remoteAddr")));
                printWriter.write("</td>");
                printWriter.write("<td nowrap>");
                printWriter.write(Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "virtualHost")));
                printWriter.write("</td>");
                printWriter.write("<td nowrap class=\"row-left\">");
                if (bl2) {
                    printWriter.write(Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "method")));
                    printWriter.write(32);
                    printWriter.write(Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "currentUri")));
                    String string2 = (String)mBeanServer.getAttribute(objectName, "currentQueryString");
                    if (string2 != null && !string2.isEmpty()) {
                        printWriter.write("?");
                        printWriter.print(Escape.htmlElementContent((String)string2));
                    }
                    printWriter.write(32);
                    printWriter.write(Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "protocol")));
                } else {
                    printWriter.write("?");
                }
                printWriter.write("</td>");
            } else {
                printWriter.write("<td>?</td><td>?</td><td>?</td><td>?</td><td>?</td><td>?</td>");
            }
        } else if (n == 1) {
            printWriter.write("<worker ");
            printWriter.write(" stage=\"" + string + "\"");
            if (bl) {
                printWriter.write(" requestProcessingTime=\"" + String.valueOf(mBeanServer.getAttribute(objectName, "requestProcessingTime")) + "\"");
                printWriter.write(" requestBytesSent=\"");
                if (bl2) {
                    printWriter.write(String.valueOf(mBeanServer.getAttribute(objectName, "requestBytesSent")));
                } else {
                    printWriter.write("0");
                }
                printWriter.write("\"");
                printWriter.write(" requestBytesReceived=\"");
                if (bl2) {
                    printWriter.write(String.valueOf(mBeanServer.getAttribute(objectName, "requestBytesReceived")));
                } else {
                    printWriter.write("0");
                }
                printWriter.write("\"");
                printWriter.write(" remoteAddr=\"" + Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "remoteAddr")) + "\"");
                printWriter.write(" virtualHost=\"" + Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "virtualHost")) + "\"");
                if (bl2) {
                    printWriter.write(" method=\"" + Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "method")) + "\"");
                    printWriter.write(" currentUri=\"" + Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "currentUri")) + "\"");
                    String string3 = (String)mBeanServer.getAttribute(objectName, "currentQueryString");
                    if (string3 != null && !string3.isEmpty()) {
                        printWriter.write(" currentQueryString=\"" + Escape.htmlElementContent((String)string3) + "\"");
                    } else {
                        printWriter.write(" currentQueryString=\"&#63;\"");
                    }
                    printWriter.write(" protocol=\"" + Escape.htmlElementContent((Object)mBeanServer.getAttribute(objectName, "protocol")) + "\"");
                } else {
                    printWriter.write(" method=\"&#63;\"");
                    printWriter.write(" currentUri=\"&#63;\"");
                    printWriter.write(" currentQueryString=\"&#63;\"");
                    printWriter.write(" protocol=\"&#63;\"");
                }
            } else {
                printWriter.write(" requestProcessingTime=\"0\"");
                printWriter.write(" requestBytesSent=\"0\"");
                printWriter.write(" requestBytesReceived=\"0\"");
                printWriter.write(" remoteAddr=\"&#63;\"");
                printWriter.write(" virtualHost=\"&#63;\"");
                printWriter.write(" method=\"&#63;\"");
                printWriter.write(" currentUri=\"&#63;\"");
                printWriter.write(" currentQueryString=\"&#63;\"");
                printWriter.write(" protocol=\"&#63;\"");
            }
            printWriter.write(" />");
        }
    }

    public static void writeDetailedState(PrintWriter printWriter, MBeanServer mBeanServer, int n) throws Exception {
        ObjectName objectName = new ObjectName("*:j2eeType=WebModule,*");
        Set<ObjectName> set = mBeanServer.queryNames(objectName, null);
        if (n == 0) {
            printWriter.print("<h1>");
            printWriter.print("Application list");
            printWriter.print("</h1>");
            printWriter.print("<p>");
            int n2 = 0;
            Iterator<ObjectName> iterator = set.iterator();
            while (iterator.hasNext()) {
                int n3;
                ObjectName objectName2 = iterator.next();
                String string = objectName2.getKeyProperty("name");
                if (string.startsWith("//")) {
                    string = string.substring(2);
                }
                if ((n3 = string.indexOf(47)) == -1) {
                    ++n2;
                    continue;
                }
                printWriter.print("<a href=\"#" + n2++ + ".0\">");
                printWriter.print(Escape.htmlElementContent((String)string));
                printWriter.print("</a>");
                if (!iterator.hasNext()) continue;
                printWriter.print("<br>");
            }
            printWriter.print("</p>");
            n2 = 0;
            for (ObjectName objectName2 : set) {
                printWriter.print("<a class=\"A.name\" name=\"" + n2++ + ".0\">");
                StatusTransformer.writeContext(printWriter, objectName2, mBeanServer, n);
            }
        } else if (n != 1 && n == 2) {
            printWriter.append(',').println();
            StatusTransformer.indent(printWriter, 1).append('\"').append("context").append('\"').append(':').append('[').println();
            Iterator<ObjectName> iterator = set.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    printWriter.append(',').println();
                }
                ObjectName objectName3 = iterator.next();
                StatusTransformer.writeContext(printWriter, objectName3, mBeanServer, n);
            }
            printWriter.println();
            StatusTransformer.indent(printWriter, 1).append(']').println();
        }
    }

    protected static void writeContext(PrintWriter printWriter, ObjectName objectName, MBeanServer mBeanServer, int n) throws Exception {
        int n2;
        String string = objectName.getKeyProperty("name");
        String string2 = string;
        if (string2 == null) {
            return;
        }
        if (string2.startsWith("//")) {
            string2 = string2.substring(2);
        }
        if ((n2 = string2.indexOf(47)) == -1) {
            return;
        }
        String string3 = string2.substring(0, n2);
        String string4 = string2.substring(n2);
        ObjectName objectName2 = new ObjectName(objectName.getDomain() + ":type=Manager,context=" + string4 + ",host=" + string3 + ",*");
        Set<ObjectName> set = mBeanServer.queryNames(objectName2, null);
        ObjectName objectName3 = null;
        Object objectName4 = set.iterator();
        while (objectName4.hasNext()) {
            ObjectName object2;
            objectName3 = object2 = objectName4.next();
        }
        objectName4 = new ObjectName(objectName.getDomain() + ":type=JspMonitor,WebModule=" + string + ",*");
        Set<ObjectName> set2 = mBeanServer.queryNames((ObjectName)objectName4, null);
        if (string4.equals("/")) {
            string4 = "";
        }
        if (n == 0) {
            printWriter.print("<h1>");
            printWriter.print(Escape.htmlElementContent((String)string2));
            printWriter.print("</h1>");
            printWriter.print("</a>");
            printWriter.print("<p>");
            Object string6 = mBeanServer.getAttribute(objectName, "startTime");
            printWriter.print(" Start time: " + String.valueOf(new Date((Long)string6)));
            printWriter.print(" Startup time: ");
            printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "startupTime"), false));
            printWriter.print(" TLD scan time: ");
            printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "tldScanTime"), false));
            if (objectName3 != null) {
                StatusTransformer.writeManager(printWriter, objectName3, mBeanServer, n);
            }
            if (set2 != null) {
                StatusTransformer.writeJspMonitor(printWriter, set2, mBeanServer, n);
            }
            printWriter.print("</p>");
            String objectName6 = objectName.getDomain() + ":j2eeType=Servlet,WebModule=" + string + ",*";
            ObjectName set3 = new ObjectName(objectName6);
            Set<ObjectInstance> bl = mBeanServer.queryMBeans(set3, null);
            for (ObjectInstance objectInstance : bl) {
                StatusTransformer.writeWrapper(printWriter, objectInstance.getObjectName(), mBeanServer, n);
            }
        } else if (n != 1 && n == 2) {
            StatusTransformer.indent(printWriter, 2).append('{').println();
            StatusTransformer.appendJSonValue(StatusTransformer.indent(printWriter, 3), "name", JSONFilter.escape((String)JSONFilter.escape((String)string2))).append(',');
            StatusTransformer.appendJSonValue(printWriter, "startTime", new Date((Long)mBeanServer.getAttribute(objectName, "startTime")).toString()).append(',');
            StatusTransformer.appendJSonValue(printWriter, "startupTime", mBeanServer.getAttribute(objectName, "startupTime")).append(',');
            StatusTransformer.appendJSonValue(printWriter, "tldScanTime", mBeanServer.getAttribute(objectName, "tldScanTime"));
            if (objectName3 != null) {
                StatusTransformer.writeManager(printWriter, objectName3, mBeanServer, n);
            }
            if (set2 != null) {
                StatusTransformer.writeJspMonitor(printWriter, set2, mBeanServer, n);
            }
            printWriter.append(',').println();
            StatusTransformer.indent(printWriter, 3).append('\"').append("wrapper").append('\"').append(':').append('[').println();
            String string5 = objectName.getDomain() + ":j2eeType=Servlet,WebModule=" + string + ",*";
            ObjectName objectName5 = new ObjectName(string5);
            Set<ObjectInstance> set3 = mBeanServer.queryMBeans(objectName5, null);
            boolean bl = true;
            for (ObjectInstance objectInstance : set3) {
                if (bl) {
                    bl = false;
                } else {
                    printWriter.append(',').println();
                }
                StatusTransformer.writeWrapper(printWriter, objectInstance.getObjectName(), mBeanServer, n);
            }
            printWriter.println();
            StatusTransformer.indent(printWriter, 3).append(']').println();
            StatusTransformer.indent(printWriter, 2).append('}');
        }
    }

    public static void writeManager(PrintWriter printWriter, ObjectName objectName, MBeanServer mBeanServer, int n) throws Exception {
        if (n == 0) {
            printWriter.print("<br>");
            printWriter.print(" Active sessions: ");
            printWriter.print(mBeanServer.getAttribute(objectName, "activeSessions"));
            printWriter.print(" Session count: ");
            printWriter.print(mBeanServer.getAttribute(objectName, "sessionCounter"));
            printWriter.print(" Max active sessions: ");
            printWriter.print(mBeanServer.getAttribute(objectName, "maxActive"));
            printWriter.print(" Rejected session creations: ");
            printWriter.print(mBeanServer.getAttribute(objectName, "rejectedSessions"));
            printWriter.print(" Expired sessions: ");
            printWriter.print(mBeanServer.getAttribute(objectName, "expiredSessions"));
            printWriter.print(" Longest session alive time: ");
            printWriter.print(StatusTransformer.formatSeconds(mBeanServer.getAttribute(objectName, "sessionMaxAliveTime")));
            printWriter.print(" Average session alive time: ");
            printWriter.print(StatusTransformer.formatSeconds(mBeanServer.getAttribute(objectName, "sessionAverageAliveTime")));
            printWriter.print(" Processing time: ");
            printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "processingTime"), false));
        } else if (n != 1 && n == 2) {
            printWriter.append(',').println();
            StatusTransformer.indent(printWriter, 3).append('\"').append("manager").append('\"').append(':').append('{');
            StatusTransformer.appendJSonValue(printWriter, "activeSessions", mBeanServer.getAttribute(objectName, "activeSessions")).append(',');
            StatusTransformer.appendJSonValue(printWriter, "sessionCounter", mBeanServer.getAttribute(objectName, "sessionCounter")).append(',');
            StatusTransformer.appendJSonValue(printWriter, "maxActive", mBeanServer.getAttribute(objectName, "maxActive")).append(',');
            StatusTransformer.appendJSonValue(printWriter, "rejectedSessions", mBeanServer.getAttribute(objectName, "rejectedSessions")).append(',');
            StatusTransformer.appendJSonValue(printWriter, "expiredSessions", mBeanServer.getAttribute(objectName, "expiredSessions")).append(',');
            StatusTransformer.appendJSonValue(printWriter, "sessionMaxAliveTime", mBeanServer.getAttribute(objectName, "sessionMaxAliveTime")).append(',');
            StatusTransformer.appendJSonValue(printWriter, "sessionAverageAliveTime", mBeanServer.getAttribute(objectName, "sessionAverageAliveTime")).append(',');
            StatusTransformer.appendJSonValue(printWriter, "processingTime", mBeanServer.getAttribute(objectName, "processingTime"));
            printWriter.append('}');
        }
    }

    public static void writeJspMonitor(PrintWriter printWriter, Set<ObjectName> set, MBeanServer mBeanServer, int n) throws Exception {
        int n2 = 0;
        int n3 = 0;
        for (ObjectName objectName : set) {
            Object object = mBeanServer.getAttribute(objectName, "jspCount");
            n2 += ((Integer)object).intValue();
            object = mBeanServer.getAttribute(objectName, "jspReloadCount");
            n3 += ((Integer)object).intValue();
        }
        if (n == 0) {
            printWriter.print("<br>");
            printWriter.print(" JSPs loaded: ");
            printWriter.print(n2);
            printWriter.print(" JSPs reloaded: ");
            printWriter.print(n3);
        } else if (n != 1 && n == 2) {
            printWriter.append(',').println();
            StatusTransformer.indent(printWriter, 3).append('\"').append("jsp").append('\"').append(':').append('{');
            StatusTransformer.appendJSonValue(printWriter, "jspCount", n2).append(',');
            StatusTransformer.appendJSonValue(printWriter, "jspReloadCount", n3);
            printWriter.append('}');
        }
    }

    public static void writeWrapper(PrintWriter printWriter, ObjectName objectName, MBeanServer mBeanServer, int n) throws Exception {
        String string = objectName.getKeyProperty("name");
        String[] stringArray = (String[])mBeanServer.invoke(objectName, "findMappings", null, null);
        if (n == 0) {
            printWriter.print("<h2>");
            printWriter.print(Escape.htmlElementContent((String)string));
            if (stringArray != null && stringArray.length > 0) {
                printWriter.print(" [ ");
                for (int i = 0; i < stringArray.length; ++i) {
                    printWriter.print(Escape.htmlElementContent((String)stringArray[i]));
                    if (i >= stringArray.length - 1) continue;
                    printWriter.print(" , ");
                }
                printWriter.print(" ] ");
            }
            printWriter.print("</h2>");
            printWriter.print("<p>");
            printWriter.print(" Processing time: ");
            printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "processingTime"), true));
            printWriter.print(" Max time: ");
            printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "maxTime"), false));
            printWriter.print(" Request count: ");
            printWriter.print(mBeanServer.getAttribute(objectName, "requestCount"));
            printWriter.print(" Error count: ");
            printWriter.print(mBeanServer.getAttribute(objectName, "errorCount"));
            printWriter.print(" Load time: ");
            printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "loadTime"), false));
            printWriter.print(" Classloading time: ");
            printWriter.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "classLoadTime"), false));
            printWriter.print("</p>");
        } else if (n != 1 && n == 2) {
            StatusTransformer.indent(printWriter, 4).append('{');
            StatusTransformer.appendJSonValue(printWriter, "servletName", JSONFilter.escape((String)string)).append(',');
            StatusTransformer.appendJSonValue(printWriter, "processingTime", mBeanServer.getAttribute(objectName, "processingTime")).append(',');
            StatusTransformer.appendJSonValue(printWriter, "maxTime", mBeanServer.getAttribute(objectName, "maxTime")).append(',');
            StatusTransformer.appendJSonValue(printWriter, "requestCount", mBeanServer.getAttribute(objectName, "requestCount")).append(',');
            StatusTransformer.appendJSonValue(printWriter, "errorCount", mBeanServer.getAttribute(objectName, "errorCount")).append(',');
            StatusTransformer.appendJSonValue(printWriter, "loadTime", mBeanServer.getAttribute(objectName, "loadTime")).append(',');
            StatusTransformer.appendJSonValue(printWriter, "classLoadTime", mBeanServer.getAttribute(objectName, "classLoadTime"));
            printWriter.append('}');
        }
    }

    public static String formatSize(Object object, boolean bl) {
        long l = -1L;
        if (object instanceof Long) {
            l = (Long)object;
        } else if (object instanceof Integer) {
            l = ((Integer)object).intValue();
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            if (l < 0L) {
                stringBuilder.append('-');
                l = -l;
            }
            long l2 = l / 0x100000L;
            long l3 = (l - l2 * 0x100000L) * 100L / 0x100000L;
            stringBuilder.append(l2).append('.');
            if (l3 < 10L) {
                stringBuilder.append('0');
            }
            stringBuilder.append(l3).append(" MiB");
            return stringBuilder.toString();
        }
        return l / 1024L + " KiB";
    }

    public static String formatTime(Object object, boolean bl) {
        long l = -1L;
        if (object instanceof Long) {
            l = (Long)object;
        } else if (object instanceof Integer) {
            l = ((Integer)object).intValue();
        }
        if (bl) {
            return (float)l / 1000.0f + " s";
        }
        return l + " ms";
    }

    public static String formatSeconds(Object object) {
        long l = -1L;
        if (object instanceof Long) {
            l = (Long)object;
        } else if (object instanceof Integer) {
            l = ((Integer)object).intValue();
        }
        return l + " s";
    }
}

