/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.debug;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mvel2.ast.LineLabel;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.debug.Debugger;
import org.mvel2.debug.Frame;
import org.mvel2.integration.VariableResolverFactory;

public class DebuggerContext {
    private Map<String, Set<Integer>> breakpoints = new HashMap<String, Set<Integer>>();
    private Debugger debugger;
    private int debuggerState = 0;

    public Map<String, Set<Integer>> getBreakpoints() {
        return this.breakpoints;
    }

    public void setBreakpoints(Map<String, Set<Integer>> breakpoints) {
        this.breakpoints = breakpoints;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public void setDebugger(Debugger debugger) {
        this.debugger = debugger;
    }

    public int getDebuggerState() {
        return this.debuggerState;
    }

    public void setDebuggerState(int debuggerState) {
        this.debuggerState = debuggerState;
    }

    public void registerBreakpoint(String sourceFile, int lineNumber) {
        if (!this.breakpoints.containsKey(sourceFile)) {
            this.breakpoints.put(sourceFile, new HashSet());
        }
        this.breakpoints.get(sourceFile).add(lineNumber);
    }

    public void removeBreakpoint(String sourceFile, int lineNumber) {
        if (!this.breakpoints.containsKey(sourceFile)) {
            return;
        }
        this.breakpoints.get(sourceFile).remove(lineNumber);
    }

    public void clearAllBreakpoints() {
        this.breakpoints.clear();
    }

    public boolean hasBreakpoints() {
        return this.breakpoints.size() != 0;
    }

    public boolean hasBreakpoint(LineLabel label) {
        return this.breakpoints.containsKey(label.getSourceFile()) && this.breakpoints.get(label.getSourceFile()).contains(label.getLineNumber());
    }

    public boolean hasBreakpoint(String sourceFile, int lineNumber) {
        return this.breakpoints.containsKey(sourceFile) && this.breakpoints.get(sourceFile).contains(lineNumber);
    }

    public boolean hasDebugger() {
        return this.debugger != null;
    }

    public int checkBreak(LineLabel label, VariableResolverFactory factory, CompiledExpression expression) {
        if (this.debuggerState == 1 || this.hasBreakpoint(label)) {
            if (this.debugger == null) {
                throw new RuntimeException("no debugger registered to handle breakpoint");
            }
            this.debuggerState = this.debugger.onBreak(new Frame(label, factory));
            return this.debuggerState;
        }
        return 0;
    }
}

