"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
const typescript_1 = __importDefault(require("typescript"));
const assert_1 = __importDefault(require("assert"));
const vscode_languageserver_1 = require("vscode-languageserver");
const documents_1 = require("../../../../src/lib/documents");
const SelectionRangeProvider_1 = require("../../../../src/plugins/typescript/features/SelectionRangeProvider");
const LSAndTSDocResolver_1 = require("../../../../src/plugins/typescript/LSAndTSDocResolver");
const utils_1 = require("../../../../src/utils");
const ls_config_1 = require("../../../../src/ls-config");
const test_utils_1 = require("../test-utils");
const testDir = path_1.default.join(__dirname, '..');
const selectionRangeTestDir = path_1.default.join(testDir, 'testfiles', 'selection-range');
describe('SelectionRangeProvider', function () {
    (0, test_utils_1.serviceWarmup)(this, selectionRangeTestDir, (0, utils_1.pathToUrl)(testDir));
    function setup(fileName) {
        const docManager = new documents_1.DocumentManager((textDocument) => new documents_1.Document(textDocument.uri, textDocument.text));
        const filePath = path_1.default.join(testDir, 'testfiles', 'selection-range', fileName);
        const lsAndTsDocResolver = new LSAndTSDocResolver_1.LSAndTSDocResolver(docManager, [(0, utils_1.pathToUrl)(testDir)], new ls_config_1.LSConfigManager());
        const provider = new SelectionRangeProvider_1.SelectionRangeProviderImpl(lsAndTsDocResolver);
        const document = docManager.openClientDocument({
            uri: (0, utils_1.pathToUrl)(filePath),
            text: typescript_1.default.sys.readFile(filePath)
        });
        return { provider, document };
    }
    it('provides selection range', async () => {
        const { provider, document } = setup('selection-range.svelte');
        const selectionRange = await provider.getSelectionRange(document, vscode_languageserver_1.Position.create(1, 9));
        assert_1.default.deepStrictEqual(selectionRange, {
            parent: {
                parent: undefined,
                // let a;
                range: {
                    end: {
                        character: 10,
                        line: 1
                    },
                    start: {
                        character: 4,
                        line: 1
                    }
                }
            },
            // a
            range: {
                end: {
                    character: 9,
                    line: 1
                },
                start: {
                    character: 8,
                    line: 1
                }
            }
        });
    });
    it('provides selection range for import without semicolon', async () => {
        const { provider, document } = setup('selection-range-import.svelte');
        const selectionRange = await provider.getSelectionRange(document, vscode_languageserver_1.Position.create(2, 28));
        assert_1.default.deepStrictEqual(selectionRange, {
            parent: {
                parent: {
                    parent: {
                        parent: undefined,
                        range: {
                            end: {
                                character: 34,
                                line: 2
                            },
                            start: {
                                character: 4,
                                line: 1
                            }
                        }
                    },
                    // import {onMount} from 'svelte';
                    range: {
                        end: {
                            character: 34,
                            line: 2
                        },
                        start: {
                            character: 4,
                            line: 2
                        }
                    }
                },
                // 'svelte';
                range: {
                    end: {
                        character: 34,
                        line: 2
                    },
                    start: {
                        character: 26,
                        line: 2
                    }
                }
            },
            // svelte
            range: {
                end: {
                    character: 33,
                    line: 2
                },
                start: {
                    character: 27,
                    line: 2
                }
            }
        });
    });
    it('return null when in style', async () => {
        const { provider, document } = setup('selection-range.svelte');
        const selectionRange = await provider.getSelectionRange(document, vscode_languageserver_1.Position.create(5, 0));
        assert_1.default.equal(selectionRange, null);
    });
});
//# sourceMappingURL=SelectionRangeProvider.test.js.map