/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import java.util.LinkedList;

public class RollingWindowAverage {
    public static final int MILLIS = 1;
    public static final int SECOND = 1000;
    public static final int MINUTE = 60000;
    final LinkedList<Bucket> buckets = new LinkedList();
    private long currentSum;
    private long currentCount;
    private long bucketSizeMillis;
    private long windowSizeMillis;

    public RollingWindowAverage(long windowSizeMillis, long bucketSizeMillis) {
        if (bucketSizeMillis <= 0L || windowSizeMillis <= 0L || windowSizeMillis <= bucketSizeMillis) {
            throw new IllegalArgumentException("Bucket size must be smaller than window size.");
        }
        this.bucketSizeMillis = bucketSizeMillis;
        this.windowSizeMillis = windowSizeMillis;
    }

    public final void add(long timestamp, long value) {
        Bucket bucket;
        block3: {
            long now;
            block2: {
                now = this.getNow();
                this.removeOldBuckets(now);
                if (this.buckets.isEmpty()) break block2;
                bucket = this.buckets.getFirst();
                if (bucket.deadline >= timestamp) break block3;
            }
            bucket = new Bucket(now + this.bucketSizeMillis);
            this.buckets.addFirst(bucket);
        }
        ++bucket.elements;
        ++this.currentCount;
        bucket.sum += value;
        this.currentSum += value;
    }

    public final double getCurrentAverage() {
        this.removeOldBuckets(this.getNow());
        if (this.currentCount == 0L) {
            return 0.0;
        }
        return (double)this.currentSum / (double)this.currentCount;
    }

    public final long getUpdatesInWindow() {
        this.removeOldBuckets(this.getNow());
        return this.currentCount;
    }

    public final long getWindowSizeMillis() {
        return this.windowSizeMillis;
    }

    long getNow() {
        return System.currentTimeMillis();
    }

    private void removeOldBuckets(long now) {
        long purgeTimestamp = now - this.windowSizeMillis;
        while (!this.buckets.isEmpty()) {
            Bucket bucket = this.buckets.getLast();
            if (bucket.deadline >= purgeTimestamp) break;
            this.currentSum -= bucket.sum;
            this.currentCount -= bucket.elements;
            this.buckets.removeLast();
        }
    }

    private static final class Bucket {
        public final long deadline;
        public long elements;
        public long sum;

        public Bucket(long deadline) {
            this.deadline = deadline;
        }
    }
}

