/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.client.api.endpoint.AliasPropertyApis;
import org.apache.solr.client.api.model.GetAliasPropertyResponse;
import org.apache.solr.client.api.model.GetAllAliasPropertiesResponse;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.UpdateAliasPropertiesRequestBody;
import org.apache.solr.client.api.model.UpdateAliasPropertyRequestBody;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class AliasProperty
extends AdminAPIBase
implements AliasPropertyApis {
    private static final String PROPERTIES = "property";

    @Inject
    public AliasProperty(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_READ_PERM)
    public GetAllAliasPropertiesResponse getAllAliasProperties(String aliasName) throws Exception {
        AliasProperty.recordCollectionForLogAndTracing(null, this.solrQueryRequest);
        GetAllAliasPropertiesResponse response = this.instantiateJerseyResponse(GetAllAliasPropertiesResponse.class);
        Aliases aliases = this.readAliasesFromZk();
        if (aliases == null) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, aliasName + " not found");
        }
        response.properties = aliases.getCollectionAliasProperties(aliasName);
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_READ_PERM)
    public GetAliasPropertyResponse getAliasProperty(String aliasName, String propName) throws Exception {
        AliasProperty.recordCollectionForLogAndTracing(null, this.solrQueryRequest);
        GetAliasPropertyResponse response = this.instantiateJerseyResponse(GetAliasPropertyResponse.class);
        Aliases aliases = this.readAliasesFromZk();
        if (aliases != null) {
            String value = (String)aliases.getCollectionAliasProperties(aliasName).get(propName);
            if (value != null) {
                response.value = value;
            } else {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, propName + " not found");
            }
        }
        return response;
    }

    private Aliases readAliasesFromZk() throws Exception {
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        ZkStateReader zkStateReader = coreContainer.getZkController().getZkStateReader();
        zkStateReader.getAliasesManager().update();
        return zkStateReader.getAliases();
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse updateAliasProperties(String aliasName, UpdateAliasPropertiesRequestBody requestBody) throws Exception {
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required request body");
        }
        AliasProperty.recordCollectionForLogAndTracing(null, this.solrQueryRequest);
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        this.modifyAliasProperties(aliasName, requestBody.properties, requestBody.async);
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse createOrUpdateAliasProperty(String aliasName, String propName, UpdateAliasPropertyRequestBody requestBody) throws Exception {
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required request body");
        }
        AliasProperty.recordCollectionForLogAndTracing(null, this.solrQueryRequest);
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        this.modifyAliasProperty(aliasName, propName, requestBody.value);
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse deleteAliasProperty(String aliasName, String propName) throws Exception {
        AliasProperty.recordCollectionForLogAndTracing(null, this.solrQueryRequest);
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        this.modifyAliasProperty(aliasName, propName, null);
        return response;
    }

    private void modifyAliasProperty(String alias, String proertyName, Object value) throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(proertyName, value);
        this.modifyAliasProperties(alias, props, null);
    }

    private void modifyAliasProperties(String alias, Map<String, Object> properties, String async) throws Exception {
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        ZkNodeProps remoteMessage = this.createRemoteMessage(alias, properties, async);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.ALIASPROP, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        this.disableResponseCaching();
    }

    public ZkNodeProps createRemoteMessage(String alias, Map<String, Object> properties, String async) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.ALIASPROP.toLower());
        remoteMessage.put("name", alias);
        remoteMessage.put(PROPERTIES, properties);
        if (async != null) {
            remoteMessage.put("async", async);
        }
        return new ZkNodeProps(remoteMessage);
    }
}

