/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.parser;

import com.ibm.db2.cmx.runtime.exception.DataSQLException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.metadata.ParameterInfoArray;
import com.ibm.db2.cmx.runtime.internal.metadata.SqlParameterInfo;
import com.ibm.db2.cmx.runtime.internal.parser.EscapeLexer;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;

public class QOCEscapeLexer
extends EscapeLexer {
    private Object[] parameters_ = null;

    public QOCEscapeLexer(String string, Object ... objectArray) {
        super(string);
        this.parameters_ = objectArray;
    }

    @Override
    protected void handlePositionalParm(StringBuilder stringBuilder, SqlParameterInfo sqlParameterInfo, String string, int n2, ParameterInfoArray parameterInfoArray) throws DataSQLException {
        String string2;
        String string3 = null;
        String string4 = null;
        int n3 = 0;
        string4 = null;
        Matcher matcher = regExPatternBeanRef.matcher(string);
        boolean bl2 = false;
        if (matcher.matches()) {
            bl2 = true;
            string2 = matcher.group(1);
            int n4 = string2.indexOf(".");
            if (n4 == 0) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_LEX_INV_PARM", string), null, 10014);
            }
            string3 = string2.substring(0, n4);
            if (string3 != null && string3.length() > 0) {
                n2 = Integer.parseInt(string3);
                this.positionalParameterExists_ = true;
                if (this.isVTIParam(n2 - 1, this.parameters_)) {
                    bl2 = false;
                }
            }
            if (bl2) {
                stringBuilder.append(" ? ");
                string4 = string2.substring(n4 + 1, string2.length());
            }
        }
        if (!bl2) {
            string2 = null;
            matcher = regExPatternVtiWithoutNum.matcher(string);
            if (matcher.matches()) {
                this.nonPositionalParameterExists_ = true;
                string2 = matcher.group(1);
            } else {
                matcher = regExPatternVtiWithNum.matcher(string);
                if (matcher.matches()) {
                    this.positionalParameterExists_ = true;
                    string3 = matcher.group(1);
                    string2 = matcher.group(2);
                } else {
                    string3 = string.substring(1);
                }
            }
            if (string3 != null) {
                this.positionalParameterExists_ = true;
                n2 = Integer.valueOf(string3);
                n3 = n2 - 1;
            } else {
                n3 = n2;
            }
            if (string2 != null && this.isVTIParam(n3, this.parameters_)) {
                String string5 = this.getVTIUsingGenericComponentClassName(this.parameters_[n3].getClass(), this.getClassForName(string2));
                stringBuilder.append(string5);
            } else {
                stringBuilder.append(" ? ");
            }
        }
        try {
            if (string3 != null) {
                n2 = Integer.valueOf(string3) - 1;
            }
            if (string4 != null) {
                sqlParameterInfo.setSqlParameterInfo(SqlParameterInfo.ParameterEntryInfoInSQL.isBean_OR_Map__, n2, string4);
                parameterInfoArray.setHasHostVariable(true);
            } else {
                sqlParameterInfo.setSqlParameterInfo(SqlParameterInfo.ParameterEntryInfoInSQL.isPositionalParameterMarker__, n2, null);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_LEX_QMARK", new Object[0]), numberFormatException, 10015);
        }
    }

    public boolean isVTIParam(int n2, Object[] objectArray) {
        return objectArray[n2] != null && (objectArray[n2] instanceof Iterable || objectArray[n2] instanceof Iterator || objectArray[n2].getClass().isArray());
    }

    private Class getClassForName(String string) throws DataSQLException {
        try {
            if (string.equals("int")) {
                return Integer.TYPE;
            }
            if (string.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (string.equals("byte")) {
                return Byte.TYPE;
            }
            if (string.equals("short")) {
                return Short.TYPE;
            }
            if (string.equals("long")) {
                return Long.TYPE;
            }
            if (string.equals("float")) {
                return Float.TYPE;
            }
            if (string.equals("double")) {
                return Double.TYPE;
            }
            Class<?> clazz = QOCEscapeLexer.getClassForNameUseThreadContextClassLoader(string);
            return clazz;
        }
        catch (Exception exception) {
            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_CLASS_NOT_FOUND_NAME", string), exception, 10013);
        }
    }

    private String getVTIUsingGenericComponentClassName(Class clazz, Class clazz2) throws DataSQLException {
        String string = null;
        if (clazz.isArray()) {
            string = "TABLE(A(?,'";
            if (clazz2.isPrimitive()) {
                return "TABLE(P" + clazz2.getName().toUpperCase() + "(?))";
            }
            return string + clazz2.getName() + "'))";
        }
        if (List.class.isAssignableFrom(clazz)) {
            string = "TABLE(L(?,'";
        } else if (Iterator.class.isAssignableFrom(clazz)) {
            string = "TABLE(IR(?,'";
        } else if (Iterable.class.isAssignableFrom(clazz)) {
            string = "TABLE(IE(?,'";
        }
        if (string == null) {
            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_UNSUP_COLL", clazz), null, 10016);
        }
        return string + clazz2.getName() + "'))";
    }

    private static Class<?> getClassForNameUseThreadContextClassLoader(String string) throws Exception {
        return QOCEscapeLexer.getClassForNameUseThreadContextClassLoaderNonPriv(string);
    }

    private static Class<?> getClassForNameUseThreadContextClassLoaderNonPriv(String string) throws Exception {
        return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
    }
}

