/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxComplex;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.lang.IfxTypes;
import com.informix.lang.Interval;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import com.informix.util.stringUtil;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;

public class ComplexTypeParser {
    private static final Object logger = Trace.getLoggerForClass(ComplexTypeParser.class);
    private final IfxConnection conn;
    private final Trace trace;
    private String currentToken = null;
    private boolean advanceToken = true;
    private int previousState = -1;
    private static final String T_COMMA = ",";
    private static final String T_LPAREN = "(";
    private static final String T_RPAREN = ")";
    private static final String T_SPACE = " ";
    private static final int CT_TYPE = 1;
    private static final int TYPE = 2;
    private static final int LENGTH = 3;
    private static final int NEXTELEMENT = 4;
    private static final int LPAREN = 5;
    private static final int RPAREN = 6;
    private static final int FIELDNAME = 7;
    private static final int NOTNULL = 8;
    private static final int CTEND = 9;
    private static final String DELIMS = " ,()";

    public ComplexTypeParser() {
        this.conn = null;
        this.trace = null;
    }

    public ComplexTypeParser(Trace trace) {
        this.conn = null;
        this.trace = trace;
    }

    public ComplexTypeParser(IfxConnection conn) {
        this.conn = conn;
        this.trace = conn.getTrace();
    }

    public Vector<IfxColumnInfo> parseTypeInfo(String rowDefinition) throws SQLException {
        Vector<IfxColumnInfo> v;
        block12: {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 1, "ComplexTypeParser.parseTypeInfo(string) entered");
                this.trace.writeTrace(logger, 3, "   parseTypeInfo(string) rowDefinition: " + rowDefinition);
            }
            if (rowDefinition == null) {
                throw IfxErrMsg.getSQLException(-79790, this.conn);
            }
            v = null;
            try {
                rowDefinition = rowDefinition.trim();
                StringTokenizer st = new StringTokenizer(rowDefinition, DELIMS, true);
                v = this.constructTypeInfo(st, 1, null, 0);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, " ****** begin dump constructed type information *****");
                    IfxComplex.dumpTypeInfoVector(v, this.trace, 4);
                    this.trace.writeTrace(logger, 2, " ****** end dump constructed type information *****");
                }
            }
            catch (SQLException e) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 1, "   getTypeInfoVector(string) constructTypeInfo() threw an exception");
                }
                if (this.conn == null) {
                    throw e;
                }
                IfxUDTInfo udtInfo = this.conn.getUDTInfo((IfxColumnInfo)null, rowDefinition);
                if (udtInfo == null) {
                    throw IfxErrMsg.getSQLException(-79770);
                }
                IfxResultSetMetaData rsmd = udtInfo.structInfo;
                if (rsmd == null) break block12;
                v = rsmd.getColumnInfoVector();
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            if (v == null) {
                this.trace.writeTrace(logger, 1, "   getTypeInfoVector(string) v is null");
            } else if (v.get((int)0).child == null) {
                this.trace.writeTrace(logger, 1, "   getTypeInfoVector(string) child is null");
            }
        }
        return v;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Vector<IfxColumnInfo> constructTypeInfo(StringTokenizer st, int stateWanted, Boolean isRow, int pretty) throws SQLException {
        Vector<IfxColumnInfo> typeInfoVector = new Vector<IfxColumnInfo>();
        int ifxType = -1;
        IfxColumnInfo colInfo = null;
        boolean finished = false;
        String indent = "";
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput.constructTypeInfo() entered");
            indent = stringUtil.fixLength("", pretty, ' ');
        }
        block10: while (!finished) {
            block64: {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "");
                    this.trace.writeTrace(logger, 3, "");
                    this.trace.writeTrace(logger, 3, indent + "advanceToken: " + this.advanceToken);
                    this.trace.writeTrace(logger, 3, indent + "token count: " + st.countTokens());
                }
                if (this.advanceToken) {
                    if (st.hasMoreTokens()) {
                        this.currentToken = this.getNextToken(st);
                        break block64;
                    } else {
                        if (this.currentToken.equals(T_RPAREN)) break;
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 3, "  constructTypeInfo() missing ')'");
                        }
                        throw IfxErrMsg.getSQLException(-79790);
                    }
                }
                this.advanceToken = true;
            }
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 3, indent + "currentToken: " + this.currentToken);
                this.trace.writeTrace(logger, 3, indent + "previousState: " + this.getState(this.previousState));
                this.trace.writeTrace(logger, 3, indent + "stateWanted: " + this.getState(stateWanted));
            }
            switch (stateWanted) {
                case 1: {
                    boolean elementIsRow;
                    ifxType = IfxTypes.FromIfxNameToIfxType(this.currentToken);
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, indent + "In case for CT_TYPE");
                        this.trace.writeTrace(logger, 3, indent + "CT_TYPE ifxType: " + ifxType);
                    }
                    if (!IfxTypes.isComplexType(ifxType)) {
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 3, indent + "constructTypeInfo() not a complex type");
                        }
                        throw IfxErrMsg.getSQLException(-79790);
                    }
                    if (colInfo == null) {
                        colInfo = new IfxColumnInfo();
                    }
                    if (ifxType == 102) {
                        ifxType = 40;
                        colInfo.ExtendedName = "blob";
                        colInfo.ExtendedId = 10;
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 3, indent + "CT_TYPE ifxType changed to IFX_TYPE_UDTVAR, IFX_XID_BLOB");
                        }
                    } else if (ifxType == 101) {
                        ifxType = 40;
                        colInfo.ExtendedName = "clob";
                        colInfo.ExtendedId = 11;
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 3, indent + "CT_TYPE ifxType changed to IFX_TYPE_UDTVAR, IFX_XID_CLOB");
                        }
                    }
                    colInfo.SQLtype = ifxType;
                    boolean bl = elementIsRow = ifxType == 22;
                    if (isRow == null) {
                        isRow = elementIsRow;
                    }
                    typeInfoVector.addElement(colInfo);
                    colInfo.Fieldno = 1;
                    this.previousState = stateWanted;
                    stateWanted = 5;
                    colInfo.child = this.constructTypeInfo(st, stateWanted, elementIsRow, pretty + 4);
                    if (this.previousState != 9) {
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 3, "  constructTypeInfo() previous state != CTEND");
                        }
                        throw IfxErrMsg.getSQLException(-79790);
                    }
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, "  constructTypeInfo() CT_TYPE setting stateWanted to NOTNULL");
                    }
                    stateWanted = 8;
                    continue block10;
                }
                case 7: {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, indent + "In case for FIELDNAME");
                    }
                    if (colInfo == null) {
                        colInfo = new IfxColumnInfo();
                    }
                    colInfo.ColName = this.currentToken;
                    this.previousState = stateWanted;
                    stateWanted = 2;
                    continue block10;
                }
                case 2: {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, indent + "In case for TYPE");
                    }
                    if (colInfo == null) {
                        colInfo = new IfxColumnInfo();
                    }
                    stateWanted = this.parseFieldType(this.currentToken, colInfo, indent);
                    continue block10;
                }
                case 4: {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, indent + "In case for NEXTELEMENT");
                    }
                    if (this.currentToken.equals(T_COMMA)) {
                        if (colInfo.Fieldno != 1) {
                            typeInfoVector.addElement(colInfo);
                            colInfo.Fieldno = 1;
                        }
                        colInfo = null;
                        this.previousState = stateWanted;
                        stateWanted = 7;
                        continue block10;
                    }
                    if (this.currentToken.equals(T_RPAREN)) {
                        if (colInfo.Fieldno != 1) {
                            typeInfoVector.addElement(colInfo);
                            colInfo.Fieldno = 1;
                        }
                        colInfo = null;
                    }
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, indent + "DONE ... DONE");
                    }
                    this.previousState = 9;
                    finished = true;
                    continue block10;
                }
                case 5: {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, indent + "In case for LPAREN");
                    }
                    if (this.previousState == 1) {
                        this.previousState = stateWanted;
                        if (isRow.booleanValue()) {
                            stateWanted = 7;
                            continue block10;
                        }
                        stateWanted = 2;
                        continue block10;
                    }
                    this.previousState = stateWanted;
                    stateWanted = 3;
                    continue block10;
                }
                case 3: {
                    int ifxLength;
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, indent + "In case for LENGTH");
                    }
                    colInfo.ColLength = ifxLength = this.getLength(st, colInfo.SQLtype);
                    if (colInfo.SQLtype == 5) {
                        short encodedLength = (short)ifxLength;
                        colInfo.setNumberOfBytes(((encodedLength >> 8 & 0xFF) + (encodedLength & 0xFF & 1) + 3) / 2 - 1 + 1);
                    } else if (colInfo.SQLtype == 10) {
                        byte digits = (byte)(ifxLength >> 8);
                        colInfo.setNumberOfBytes(digits % 2 == 0 ? digits / 2 + 1 : digits / 2 + 2);
                    }
                    stateWanted = 8;
                    continue block10;
                }
                case 6: {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, indent + "In case for RPAREN");
                    }
                    if (!this.currentToken.equals(T_RPAREN)) {
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 3, "  constructTypeInfo() missing a ')'");
                        }
                        throw IfxErrMsg.getSQLException(-79790);
                    }
                    if (!isRow.booleanValue()) {
                        if (colInfo.Fieldno != 1) {
                            typeInfoVector.addElement(colInfo);
                            colInfo.Fieldno = 1;
                        }
                        colInfo = null;
                        this.previousState = 9;
                        finished = true;
                        continue block10;
                    }
                    this.previousState = stateWanted;
                    stateWanted = 8;
                    continue block10;
                }
                case 8: {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, indent + "In case for NOTNULL");
                    }
                    if (!this.currentToken.equalsIgnoreCase("not")) {
                        if (!isRow.booleanValue()) {
                            if (TraceFlag.isTraceEnabled()) {
                                this.trace.writeTrace(logger, 3, "  constructTypeInfo() missing not null");
                            }
                            throw IfxErrMsg.getSQLException(-79790);
                        }
                        this.advanceToken = false;
                        stateWanted = 4;
                        continue block10;
                    }
                    this.currentToken = this.getNextToken(st);
                    if (this.currentToken.equalsIgnoreCase("null")) {
                        colInfo.Nullable = 0;
                        if (this.previousState == 9 && !st.hasMoreTokens()) {
                            finished = true;
                            continue block10;
                        }
                    } else {
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 3, "  constructTypeInfo() missing 'null'");
                        }
                        throw IfxErrMsg.getSQLException(-79790);
                    }
                    this.previousState = stateWanted;
                    if (isRow.booleanValue()) {
                        stateWanted = 4;
                        continue block10;
                    }
                    stateWanted = 6;
                    continue block10;
                }
            }
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 3, "  constructTypeInfo() unknown state");
            }
            throw IfxErrMsg.getSQLException(-79790);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput.constructTypeInfo() exited");
        }
        return typeInfoVector;
    }

    private String getNextToken(StringTokenizer st) throws SQLException {
        String token = null;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.equals(T_SPACE)) continue;
            return token;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "  getNextToken() no more tokens");
        }
        throw IfxErrMsg.getSQLException(-79790);
    }

    private int parseFieldType(String s, IfxColumnInfo colInfo, String indent) throws SQLException {
        int stateWanted = 0;
        int index = 0;
        String ownerName = null;
        String typeName = null;
        if (s.startsWith("'")) {
            index = s.indexOf(39, 1);
            if (index > 0) {
                ownerName = s.substring(1, index);
                ++index;
            } else {
                throw IfxErrMsg.getSQLException(-79790);
            }
        }
        if ((index = s.indexOf(46, index)) <= 0 && ownerName != null) {
            throw IfxErrMsg.getSQLException(-79790);
        }
        if (ownerName != null) {
            colInfo.ExtendedOwner = ownerName;
            ++index;
        } else if (index > 0) {
            colInfo.ExtendedOwner = ownerName = s.substring(0, index);
            ++index;
        } else {
            index = 0;
        }
        typeName = s.substring(index, s.length());
        int ifxType = IfxTypes.FromIfxNameToIfxType(typeName);
        if (IfxTypes.isComplexType(ifxType)) {
            stateWanted = 1;
            this.advanceToken = false;
        } else {
            if (ifxType == 1111) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "Type = OTHER");
                }
                this.getOther(colInfo, typeName, ownerName);
                ifxType = colInfo.SQLtype;
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "Other name = " + colInfo.ColName);
                    this.trace.writeTrace(logger, 3, "Other type = " + colInfo.SQLtype);
                }
            }
            if (ifxType == 102) {
                ifxType = 40;
                colInfo.ExtendedName = "blob";
                colInfo.ExtendedId = 10;
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, indent + "TYPE ifxType changed to IFX_TYPE_UDTVAR, IFX_XID_BLOB");
                }
            } else if (ifxType == 101) {
                ifxType = 40;
                colInfo.ExtendedName = "clob";
                colInfo.ExtendedId = 11;
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, indent + "TYPE ifxType changed to IFX_TYPE_UDTVAR, IFX_XID_CLOB");
                }
            }
            colInfo.SQLtype = ifxType;
            this.previousState = stateWanted;
            stateWanted = 3;
        }
        return stateWanted;
    }

    private void getOther(IfxColumnInfo colInfo, String name, String owner) throws SQLException {
        IfxUDTInfo udtInfo = null;
        udtInfo = owner != null ? this.conn.getUDTInfo(name, owner) : this.conn.getUDTInfo((IfxColumnInfo)null, name);
        if (udtInfo == null) {
            throw IfxErrMsg.getSQLException(-79770);
        }
        colInfo.ExtendedName = udtInfo.name;
        if (udtInfo.owner != null && owner != null) {
            colInfo.ExtendedOwner = udtInfo.owner;
        }
        colInfo.ExtendedId = udtInfo.xid;
        colInfo.SQLtype = udtInfo.SQLtype;
        if (udtInfo.JDBCtype == 2002) {
            IfxColumnInfo newColInfo = null;
            IfxResultSetMetaData rsmd = udtInfo.structInfo;
            newColInfo = rsmd.getColumnInfoVector().get(0);
            String svColName = colInfo.ColName;
            newColInfo.copy(colInfo);
            colInfo.ColName = svColName;
        } else if (udtInfo.JDBCtype == 2001) {
            colInfo.SourceType = udtInfo.source;
        }
    }

    private String getState(int state) {
        switch (state) {
            case 1: {
                return "CT_TYPE";
            }
            case 2: {
                return "TYPE";
            }
            case 3: {
                return "LENGTH";
            }
            case 4: {
                return "NEXTELEMENT";
            }
            case 5: {
                return "LPAREN";
            }
            case 6: {
                return "RPAREN";
            }
            case 7: {
                return "FIELDNAME";
            }
            case 8: {
                return "NOTNULL";
            }
        }
        return "";
    }

    private int getLength(StringTokenizer st, int ifxType) throws SQLException {
        int ifxLength = -1;
        if (ifxType == 0 || ifxType == 15 || ifxType == 13 || ifxType == 16) {
            if (!this.currentToken.equals(T_LPAREN)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "  getLength() char length");
                }
                throw IfxErrMsg.getSQLException(-79790);
            }
            this.currentToken = this.getNextToken(st);
            ifxLength = Integer.parseInt(this.currentToken);
            this.currentToken = this.getNextToken(st);
            if ((ifxType == 13 || ifxType == 16) && this.currentToken.equals(T_COMMA)) {
                this.getNextToken(st);
                this.currentToken = this.getNextToken(st);
            }
            if (!this.currentToken.equals(T_RPAREN)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "  getLength() missing ')'");
                }
                throw IfxErrMsg.getSQLException(-79790);
            }
        } else if (ifxType == 8 || ifxType == 5) {
            int prec = 16;
            int scale = this.conn != null && this.conn.isANSI() ? 0 : 255;
            if (!this.currentToken.equals(T_LPAREN)) {
                if (ifxType == 8) {
                    scale = 2;
                }
                ifxLength = ((byte)prec << 8) + scale;
                this.advanceToken = false;
            } else {
                this.currentToken = this.getNextToken(st);
                prec = Integer.parseInt(this.currentToken);
                this.currentToken = this.getNextToken(st);
                if (this.currentToken.equals(T_COMMA)) {
                    this.currentToken = this.getNextToken(st);
                    scale = Integer.parseInt(this.currentToken);
                    this.currentToken = this.getNextToken(st);
                }
                if (!this.currentToken.equals(T_RPAREN)) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, "  getLength() missing ')'");
                    }
                    throw IfxErrMsg.getSQLException(-79790);
                }
                ifxLength = ((byte)prec << 8) + scale;
            }
        } else if (ifxType == 10 || ifxType == 14) {
            ifxLength = ifxType == 10 ? this.getQualifier(st, false) : this.getQualifier(st, true);
        } else {
            this.advanceToken = false;
            switch (ifxType) {
                case 1: {
                    ifxLength = 2;
                    break;
                }
                case 2: 
                case 6: 
                case 7: {
                    ifxLength = 4;
                    break;
                }
                case 3: {
                    ifxLength = 8;
                    break;
                }
                case 4: {
                    ifxLength = 4;
                    break;
                }
                case 17: 
                case 18: {
                    ifxLength = 10;
                    break;
                }
                case 52: 
                case 53: {
                    ifxLength = 8;
                    break;
                }
                case 45: {
                    ifxLength = 1;
                    break;
                }
                case 43: {
                    if (this.conn.isLvcGtThan2kSupported() && this.currentToken.equals(T_LPAREN)) {
                        this.advanceToken = true;
                        this.currentToken = this.getNextToken(st);
                        ifxLength = Integer.parseInt(this.currentToken);
                        this.currentToken = this.getNextToken(st);
                        if (this.currentToken.equals(T_RPAREN)) break;
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 3, "  getLength() missing ')'");
                        }
                        throw IfxErrMsg.getSQLException(-79790);
                    }
                    ifxLength = 2048;
                    break;
                }
                default: {
                    ifxLength = 0;
                }
            }
        }
        if (ifxLength == -1) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 3, "  getLength() ifxLength == -1");
            }
            throw IfxErrMsg.getSQLException(-79790);
        }
        return ifxLength;
    }

    private int getQualifier(StringTokenizer st, boolean isInterval) throws SQLException {
        byte startCode = 0;
        byte endCode = 0;
        byte length = 0;
        int qualifier = 0;
        startCode = this.fieldNametoDatetimeMacro(st);
        this.currentToken = this.getNextToken(st);
        if (this.currentToken.equals(T_LPAREN)) {
            if (isInterval) {
                this.currentToken = this.getNextToken(st);
                length = (byte)Integer.parseInt(this.currentToken);
                this.currentToken = this.getNextToken(st);
                if (!this.currentToken.equals(T_RPAREN)) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, "  getQual() missing ')'");
                    }
                    throw IfxErrMsg.getSQLException(-79717);
                }
                this.currentToken = this.getNextToken(st);
            } else {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "  getQual() '(' and it a datetime");
                }
                throw IfxErrMsg.getSQLException(-79707);
            }
        }
        if (this.currentToken.equalsIgnoreCase("to")) {
            this.currentToken = this.getNextToken(st);
            endCode = this.fieldNametoDatetimeMacro(st);
            qualifier = isInterval ? (int)Interval.getQualifier(length, startCode, endCode) : (int)IfxDateTime.getQualifier(startCode, endCode);
        }
        return qualifier;
    }

    private byte fieldNametoDatetimeMacro(StringTokenizer st) throws SQLException {
        int code = -1;
        this.currentToken.trim();
        if (this.currentToken.equalsIgnoreCase("year")) {
            code = 0;
        } else if (this.currentToken.equalsIgnoreCase("month")) {
            code = 2;
        } else if (this.currentToken.equalsIgnoreCase("day")) {
            code = 4;
        } else if (this.currentToken.equalsIgnoreCase("hour")) {
            code = 6;
        } else if (this.currentToken.equalsIgnoreCase("minute")) {
            code = 8;
        } else if (this.currentToken.equalsIgnoreCase("second")) {
            code = 10;
        } else if (this.currentToken.equalsIgnoreCase("fraction")) {
            this.currentToken = this.getNextToken(st);
            if (this.currentToken.equals(T_LPAREN)) {
                this.currentToken = this.getNextToken(st);
                int frac = Integer.parseInt(this.currentToken);
                this.currentToken = this.getNextToken(st);
                if (this.currentToken.equals(T_RPAREN)) {
                    if (frac == 1) {
                        code = 11;
                    } else if (frac == 2) {
                        code = 12;
                    } else if (frac == 3) {
                        code = 13;
                    } else if (frac == 4) {
                        code = 14;
                    } else if (frac == 5) {
                        code = 15;
                    }
                }
            } else {
                this.advanceToken = false;
                code = 12;
            }
        }
        if (code == -1) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 3, "  fieldNametoDatetimeMacro() cod == -1");
            }
            throw IfxErrMsg.getSQLException(-79707);
        }
        return (byte)code;
    }
}

