/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.capsule;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.nio.charset.StandardCharsets;

@ExportLibrary(value=InteropLibrary.class)
public final class PyCapsule
extends PythonBuiltinObject {
    private final CapsuleData data;
    private CApiTransitions.PyCapsuleReference reference;

    public static byte[] capsuleName(String string) {
        return string.getBytes(StandardCharsets.US_ASCII);
    }

    public static boolean capsuleJavaNameIs(PyCapsule capsule, byte[] name) {
        CArrayWrappers.CByteArrayWrapper wrapper;
        Object object = capsule.getNamePtr();
        return object instanceof CArrayWrappers.CByteArrayWrapper && (wrapper = (CArrayWrappers.CByteArrayWrapper)object).getByteArray() == name;
    }

    public PyCapsule(PythonLanguage lang, CapsuleData data) {
        super((Object)PythonBuiltinClassType.Capsule, PythonBuiltinClassType.Capsule.getInstanceShape(lang));
        this.data = data;
    }

    public CapsuleData getData() {
        return this.data;
    }

    public Object getPointer() {
        return this.data.pointer;
    }

    public void setPointer(Object pointer) {
        this.data.pointer = pointer;
    }

    public Object getNamePtr() {
        return this.data.namePtr;
    }

    public void setNamePtr(Object name) {
        this.data.namePtr = name;
    }

    public Object getContext() {
        return this.data.context;
    }

    public void setContext(Object context) {
        this.data.context = context;
    }

    public Object getDestructor() {
        return this.data.destructor;
    }

    public void registerDestructor(Object destructor) {
        assert (destructor == null || !InteropLibrary.getUncached().isNull(destructor));
        if (this.reference == null && destructor != null) {
            this.reference = CApiTransitions.registerPyCapsuleDestructor(this);
        }
        this.data.destructor = destructor;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public String toDisplayString(boolean allowSideEffects) {
        String n;
        String quote;
        if (this.data.namePtr != null) {
            quote = "\"";
            n = CastToJavaStringNode.getUncached().execute(CExtNodesFactory.FromCharPointerNodeGen.getUncached().execute(this.data.namePtr, false));
        } else {
            quote = "";
            n = "NULL";
        }
        return String.format("<capsule object %s%s%s at %x>", quote, n, quote, this.hashCode());
    }

    public static class CapsuleData {
        private Object pointer;
        private Object namePtr;
        private Object context;
        private Object destructor;

        public CapsuleData(Object pointer, Object namePtr) {
            this.pointer = pointer;
            this.namePtr = namePtr;
        }

        public Object getDestructor() {
            return this.destructor;
        }
    }
}

