/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractDependantObject;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.ColumnPartial;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableIndex;
import schemacrawler.crawl.MutableIndexColumn;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.Column;
import schemacrawler.schema.IndexColumnSortSequence;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.exceptions.WrappedSQLException;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

final class IndexRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(IndexRetriever.class.getName());

    IndexRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) {
        super(retrieverConnection, catalog, options);
    }

    void retrieveIndexes(NamedObjectList<MutableTable> allTables) throws SQLException {
        Objects.requireNonNull(allTables, "No tables provided");
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.indexesRetrievalStrategy)) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving indexes, using fast data dictionary retrieval");
                this.retrieveIndexesFromDataDictionary();
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving indexes");
                this.retrieveIndexesFromMetadata(allTables);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Not retrieving indexes");
            }
        }
    }

    void retrieveIndexInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.EXT_INDEXES)) {
            LOGGER.log(Level.INFO, "Not retrieving additional index information, since this was not requested");
            LOGGER.log(Level.FINE, "Indexes information SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving additional index information");
        String name = "indexes for index information";
        RetrievalCounts retrievalCounts = new RetrievalCounts("indexes for index information");
        Query extIndexesInformationSql = informationSchemaViews.getQuery(InformationSchemaKey.EXT_INDEXES);
        try (Connection connection = this.getRetrieverConnection().getConnection("indexes for index information");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(extIndexesInformationSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                String catalogName = this.normalizeCatalogName(results.getString("INDEX_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("INDEX_SCHEMA"));
                String tableName = results.getString("TABLE_NAME");
                String indexName = results.getString("INDEX_NAME");
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{catalogName, schemaName, indexName}));
                    continue;
                }
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving index information <%s>", new Object[]{indexName}));
                MutableTable table = tableOptional.get();
                Optional<MutableIndex> indexOptional = table.lookupIndex(indexName);
                if (!indexOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find index <%s.%s.%s.%s>", new Object[]{catalogName, schemaName, tableName, indexName}));
                    continue;
                }
                MutableIndex index = indexOptional.get();
                String definition = results.getString("INDEX_DEFINITION");
                String remarks = results.getString("REMARKS");
                index.appendDefinition(definition);
                index.setRemarks(remarks);
                index.addAttributes(results.getAttributes());
                retrievalCounts.countIncluded();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve index information", e);
        }
        retrievalCounts.log();
    }

    private boolean createIndexForTable(MutableTable table, MetadataResultSet results) {
        MutableIndex index;
        Optional<MutableIndex> indexOptional;
        AbstractDependantObject column;
        String indexName = results.getString("INDEX_NAME");
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Retrieving index <%s.%s>", new Object[]{table, indexName}));
        String columnName = results.getString("COLUMN_NAME");
        if (Utility.isBlank((CharSequence)columnName)) {
            return false;
        }
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Retrieving index column <%s.%s.%s>", new Object[]{table, indexName, columnName}));
        boolean uniqueIndex = !results.getBoolean("NON_UNIQUE");
        IndexType type = results.getEnumFromId("TYPE", IndexType.unknown);
        short ordinalPosition = results.getShort("ORDINAL_POSITION", (short)0);
        IndexColumnSortSequence sortSequence = IndexColumnSortSequence.valueOfFromCode(results.getString("ASC_OR_DESC"));
        long cardinality = results.getLong("CARDINALITY", 0L);
        long pages = results.getLong("PAGES", 0L);
        Optional<MutableColumn> columnOptional = table.lookupColumn(columnName);
        if (columnOptional.isPresent()) {
            MutableColumn mutableColumn = columnOptional.get();
            mutableColumn.markAsPartOfIndex();
            if (uniqueIndex) {
                mutableColumn.markAsPartOfUniqueIndex();
            }
            column = mutableColumn;
        } else {
            column = new ColumnPartial(table, columnName);
        }
        if (Utility.isBlank((CharSequence)indexName)) {
            indexName = String.format("SC_%s", Integer.toHexString(column.getFullName().hashCode()).toUpperCase());
        }
        if ((indexOptional = table.lookupIndex(indexName)).isPresent()) {
            index = indexOptional.get();
        } else {
            index = new MutableIndex(table, indexName);
            table.addIndex(index);
        }
        index.withQuoting(this.getRetrieverConnection().getIdentifiers());
        MutableIndexColumn indexColumn = new MutableIndexColumn(index, (Column)((Object)column));
        indexColumn.setKeyOrdinalPosition(ordinalPosition);
        indexColumn.setSortSequence(sortSequence);
        index.addColumn(indexColumn);
        index.setUnique(uniqueIndex);
        index.setIndexType(type);
        index.setCardinality(cardinality);
        index.setPages(pages);
        index.addAttributes(results.getAttributes());
        return true;
    }

    private void retrieveIndexesFromDataDictionary() throws WrappedSQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.INDEXES)) {
            LOGGER.log(Level.FINE, "Extended indexes SQL statement was not provided");
            return;
        }
        String name = "indexes from data dictionary";
        RetrievalCounts retrievalCounts = new RetrievalCounts("indexes from data dictionary");
        Query indexesSql = informationSchemaViews.getQuery(InformationSchemaKey.INDEXES);
        try (Connection connection = this.getRetrieverConnection().getConnection("indexes from data dictionary");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(indexesSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                String catalogName = this.normalizeCatalogName(results.getString("TABLE_CAT"));
                String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEM"));
                String tableName = results.getString("TABLE_NAME");
                Optional<MutableTable> optionalTable = this.lookupTable(catalogName, schemaName, tableName);
                if (!optionalTable.isPresent()) continue;
                MutableTable table = optionalTable.get();
                boolean added = this.createIndexForTable(table, results);
                retrievalCounts.countIfIncluded(added);
            }
            retrievalCounts.log();
        }
        catch (SQLException e) {
            throw new WrappedSQLException(String.format("Could not retrieve indexes from SQL:%n%s", indexesSql), e);
        }
    }

    private void retrieveIndexesFromMetadata(NamedObjectList<MutableTable> allTables) throws SQLException {
        String name = "indexes from metadata";
        RetrievalCounts retrievalCounts = new RetrievalCounts("indexes from metadata");
        for (MutableTable table : allTables) {
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Retrieving %s for %s", new Object[]{"indexes from metadata", table.key()}));
            Schema tableSchema = table.getSchema();
            try {
                Connection connection = this.getRetrieverConnection().getConnection("indexes from metadata");
                try (MetadataResultSet results = new MetadataResultSet(connection.getMetaData().getIndexInfo(tableSchema.getCatalogName(), tableSchema.getName(), table.getName(), false, true), "DatabaseMetaData::getIndexInfo");){
                    while (results.next()) {
                        retrievalCounts.count();
                        boolean added = this.createIndexForTable(table, results);
                        retrievalCounts.countIfIncluded(added);
                    }
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.logPossiblyUnsupportedSQLFeature((Supplier<String>)new StringFormat("Could not retrieve indexes for table <%s>", new Object[]{table}), e);
            }
        }
        retrievalCounts.log();
    }
}

