/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbBatchConfig;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.StatementType;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.StatementListener;
import org.firebirdsql.jdbc.Batch;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBParameterMetaData;
import org.firebirdsql.jdbc.FBResultSetMetaData;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBStatement;
import org.firebirdsql.jdbc.FirebirdParameterMetaData;
import org.firebirdsql.jdbc.FirebirdPreparedStatement;
import org.firebirdsql.jdbc.ServerBatch;
import org.firebirdsql.jdbc.field.BlobListenableField;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

public class FBPreparedStatement
extends FBStatement
implements FirebirdPreparedStatement {
    public static final String METHOD_NOT_SUPPORTED = "This method is only supported on Statement and not supported on PreparedStatement and CallableStatement";
    private static final String UNICODE_STREAM_NOT_SUPPORTED = "Unicode stream not supported.";
    private final boolean metaDataQuery;
    private final boolean standaloneStatement;
    private final boolean generatedKeys;
    private FBField[] fields = null;
    private boolean isExecuteProcedureStatement;
    private final FBObjectListener.BlobListener blobListener;
    private RowValue fieldValues;
    private Batch batch;

    protected FBPreparedStatement(GDSHelper c, int rsType, int rsConcurrency, int rsHoldability, FBObjectListener.StatementListener statementListener, FBObjectListener.BlobListener blobListener) throws SQLException {
        super(c, rsType, rsConcurrency, rsHoldability, statementListener);
        this.blobListener = blobListener;
        this.standaloneStatement = false;
        this.metaDataQuery = false;
        this.generatedKeys = false;
    }

    protected FBPreparedStatement(GDSHelper c, String sql, int rsType, int rsConcurrency, int rsHoldability, FBObjectListener.StatementListener statementListener, FBObjectListener.BlobListener blobListener, boolean metaDataQuery, boolean standaloneStatement, boolean generatedKeys) throws SQLException {
        super(c, rsType, rsConcurrency, rsHoldability, statementListener);
        this.blobListener = blobListener;
        this.metaDataQuery = metaDataQuery;
        this.standaloneStatement = standaloneStatement;
        this.generatedKeys = generatedKeys;
        try (LockCloseable ignored = c.withLock();){
            this.notifyStatementStarted();
            try {
                this.prepareFixedStatement(sql);
            }
            catch (Exception e) {
                this.notifyStatementCompleted(false);
                throw e;
            }
        }
    }

    @Override
    public void completeStatement(CompletionReason reason) throws SQLException {
        if (!this.metaDataQuery) {
            super.completeStatement(reason);
        } else {
            this.notifyStatementCompleted();
        }
    }

    @Override
    protected void notifyStatementCompleted(boolean success) throws SQLException {
        try {
            super.notifyStatementCompleted(success);
        }
        finally {
            if (this.metaDataQuery && this.standaloneStatement) {
                this.close();
            }
        }
    }

    @Override
    protected boolean needsScrollableCursorEnabled() {
        return !this.metaDataQuery && super.needsScrollableCursorEnabled();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(false);
    }

    private ResultSet executeQuery(boolean metaDataQuery) throws SQLException {
        Throwable throwable = null;
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.notifyStatementStarted();
            try {
                if (!this.internalExecute(this.isExecuteProcedureStatement)) {
                    throw FBPreparedStatement.queryProducedNoResultSet();
                }
                ResultSet resultSet = this.getResultSet(metaDataQuery);
                return resultSet;
            }
            catch (Exception e) {
                try {
                    this.notifyStatementCompleted(true, e);
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        Throwable throwable = null;
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.notifyStatementStarted();
            try {
                if (this.internalExecute(this.isExecuteProcedureStatement) && !this.isGeneratedKeyQuery()) {
                    throw FBPreparedStatement.updateReturnedResultSet();
                }
                int updateCount = this.getUpdateCountMinZero();
                this.notifyStatementCompleted();
                int n = updateCount;
                return n;
            }
            catch (Exception e) {
                try {
                    this.notifyStatementCompleted(true, e);
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    void close(boolean ignoreAlreadyClosed) throws SQLException {
        try {
            Batch batch = this.batch;
            if (batch != null) {
                this.batch = null;
                batch.close();
            }
        }
        finally {
            super.close(ignoreAlreadyClosed);
        }
    }

    public FirebirdParameterMetaData getFirebirdParameterMetaData() throws SQLException {
        return new FBParameterMetaData(this.fbStatement.getParameterDescriptor(), this.connection);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.getField(parameterIndex).setNull();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.getField(parameterIndex).setBinaryStream(inputStream, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.getField(parameterIndex).setBinaryStream(inputStream, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream) throws SQLException {
        this.getField(parameterIndex).setBinaryStream(inputStream);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.getField(parameterIndex).setBytes(x);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.getField(parameterIndex).setBoolean(x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.getField(parameterIndex).setByte(x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.getField(parameterIndex).setDate(x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.getField(parameterIndex).setDouble(x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.getField(parameterIndex).setFloat(x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.getField(parameterIndex).setInteger(x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.getField(parameterIndex).setLong(x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.getField(parameterIndex).setObject(x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType.getVendorTypeNumber(), scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType.getVendorTypeNumber());
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.getField(parameterIndex).setShort(x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.getField(parameterIndex).setString(x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.getField(parameterIndex).setTime(x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.getField(parameterIndex).setTimestamp(x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.getField(parameterIndex).setBigDecimal(x);
    }

    protected FieldDescriptor getParameterDescriptor(int columnIndex) {
        return this.fbStatement.getParameterDescriptor().getFieldDescriptor(columnIndex - 1);
    }

    protected FBField getField(int columnIndex) throws SQLException {
        this.checkValidity();
        if (columnIndex > this.fields.length) {
            throw new SQLException("Invalid column index: " + columnIndex, "HY002");
        }
        return this.fields[columnIndex - 1];
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException(UNICODE_STREAM_NOT_SUPPORTED);
    }

    @Override
    public void setURL(int parameterIndex, URL url) throws SQLException {
        throw new FBDriverNotCapableException("Type URL not supported");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkValidity();
        if (this.fieldValues != null) {
            this.fieldValues.reset();
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        Throwable throwable = null;
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.notifyStatementStarted();
            try {
                boolean hasResultSet = this.internalExecute(this.isExecuteProcedureStatement);
                if (!hasResultSet) {
                    this.notifyStatementCompleted();
                }
                boolean bl = hasResultSet;
                return bl;
            }
            catch (Exception e) {
                try {
                    this.notifyStatementCompleted(true, e);
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    ResultSet executeMetaDataQuery() throws SQLException {
        return this.executeQuery(true);
    }

    protected boolean internalExecute(boolean sendOutParams) throws SQLException {
        this.checkAllParametersSet();
        try (LockCloseable ignored = this.withLock();){
            this.flushFields();
            boolean bl = this.internalExecute(this.fieldValues);
            return bl;
        }
    }

    private void checkAllParametersSet() throws SQLException {
        this.fbStatement.validateParameters(this.fieldValues);
    }

    @Override
    protected boolean isGeneratedKeyQuery() {
        return this.generatedKeys;
    }

    private void flushFields() throws SQLException {
        for (int i = 0; i < this.fields.length; ++i) {
            FBField field = this.fields[i];
            if (!(field instanceof FBFlushableField)) continue;
            ((FBFlushableField)((Object)field)).flushCachedData();
        }
    }

    private Batch requireBatch() throws SQLException {
        Batch batch = this.batch;
        if (batch != null) {
            return batch;
        }
        this.batch = this.createBatch();
        return this.batch;
    }

    private Batch createBatch() throws SQLException {
        if (this.canExecuteUsingServerBatch()) {
            return new ServerBatch(FbBatchConfig.of(false, true, -1, this.connection.getServerBatchBufferSize()), this.fbStatement);
        }
        return new EmulatedPreparedStatementBatch();
    }

    private boolean canExecuteUsingServerBatch() {
        return this.connection != null && this.connection.isUseServerBatch() && this.fbStatement != null && this.fbStatement.supportBatchUpdates() && this.fbStatement.getParameterDescriptor().getCount() != 0 && !this.isGeneratedKeyQuery();
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkValidity();
        this.checkAllParametersSet();
        try (LockCloseable ignored = this.withLock();){
            BatchedRowValue batchedValues = new BatchedRowValue(this.fieldValues.deepCopy());
            for (int i = 0; i < batchedValues.getCount(); ++i) {
                FBField field = this.getField(i + 1);
                if (!(field instanceof FBFlushableField)) continue;
                batchedValues.setCachedObject(i, ((FBFlushableField)((Object)field)).getCachedObject());
            }
            this.requireBatch().addBatch(batchedValues);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkValidity();
        try (LockCloseable ignored = this.withLock();){
            Batch batch = this.batch;
            if (batch != null) {
                batch.clearBatch();
            }
        }
    }

    @Override
    protected List<Long> executeBatchInternal() throws SQLException {
        Throwable throwable = null;
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.notifyStatementStarted();
            try {
                List<Long> results = this.requireBatch().execute();
                this.notifyStatementCompleted();
                List<Long> list = results;
                return list;
            }
            catch (Exception e) {
                try {
                    this.notifyStatementCompleted(false, e);
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.getField(parameterIndex).setCharacterStream(reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.getField(parameterIndex).setCharacterStream(reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.getField(parameterIndex).setCharacterStream(reader);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw new FBDriverNotCapableException("Type REF not supported");
    }

    @Override
    public void setBlob(int parameterIndex, Blob blob) throws SQLException {
        this.getField(parameterIndex).setBlob(blob);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream);
    }

    @Override
    public void setClob(int parameterIndex, Clob clob) throws SQLException {
        this.getField(parameterIndex).setClob(clob);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        throw new FBDriverNotCapableException("Type ARRAY not yet supported");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkValidity();
        return new FBResultSetMetaData(this.fbStatement.getRowDescriptor(), this.connection);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.getField(parameterIndex).setDate(x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.getField(parameterIndex).setTime(x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.getField(parameterIndex).setTimestamp(x, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    protected void prepareFixedStatement(String sql) throws SQLException {
        super.prepareFixedStatement(sql);
        RowDescriptor rowDescriptor = this.fbStatement.getParameterDescriptor();
        assert (rowDescriptor != null) : "RowDescriptor should not be null after prepare";
        int fieldCount = rowDescriptor.getCount();
        this.fieldValues = rowDescriptor.createDefaultFieldValues();
        this.fields = new FBField[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            final int fieldPosition = i;
            FieldDataProvider dataProvider = new FieldDataProvider(){

                @Override
                public byte[] getFieldData() {
                    return FBPreparedStatement.this.fieldValues.getFieldData(fieldPosition);
                }

                @Override
                public void setFieldData(byte[] data) {
                    FBPreparedStatement.this.fieldValues.setFieldData(fieldPosition, data);
                }
            };
            FBField field = FBField.createField(this.getParameterDescriptor(i + 1), dataProvider, this.gdsHelper, false);
            if (field instanceof BlobListenableField) {
                ((BlobListenableField)((Object)field)).setBlobListener(this.blobListener);
            }
            this.fields[i] = field;
        }
        this.isExecuteProcedureStatement = this.fbStatement.getType() == StatementType.STORED_PROCEDURE;
    }

    @Override
    public String getExecutionPlan() throws SQLException {
        return super.getExecutionPlan();
    }

    @Override
    public String getExplainedExecutionPlan() throws SQLException {
        return super.getExplainedExecutionPlan();
    }

    @Override
    public int getStatementType() throws SQLException {
        return super.getStatementType();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.getFirebirdParameterMetaData();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setClob(parameterIndex, value);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.getField(parameterIndex).setRowId(x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new FBDriverNotCapableException("Type SQLXML not supported");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndex) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.executeUpdate();
        return this.getLargeUpdateCountMinZero();
    }

    boolean isInitialized() {
        return this.fields != null;
    }

    private final class EmulatedPreparedStatementBatch
    implements Batch {
        private final Deque<Batch.BatchRowValue> batchRowValues = new ArrayDeque<Batch.BatchRowValue>();

        private EmulatedPreparedStatementBatch() {
        }

        @Override
        public void addBatch(Batch.BatchRowValue rowValue) throws SQLException {
            this.batchRowValues.addLast(rowValue);
        }

        private boolean isEmpty() throws SQLException {
            return this.batchRowValues.isEmpty();
        }

        @Override
        public List<Long> execute() throws SQLException {
            BatchStatementListener batchStatementListener;
            if (this.isEmpty()) {
                return Collections.emptyList();
            }
            int size = this.batchRowValues.size();
            if (FBPreparedStatement.this.isGeneratedKeyQuery()) {
                batchStatementListener = new BatchStatementListener(size);
                FBPreparedStatement.this.fbStatement.addStatementListener(batchStatementListener);
            } else {
                batchStatementListener = null;
            }
            ArrayList<Long> results = new ArrayList<Long>(size);
            try {
                Batch.BatchRowValue batchRowValue;
                Deque<Batch.BatchRowValue> batchRowValues = this.batchRowValues;
                while ((batchRowValue = batchRowValues.pollFirst()) != null) {
                    results.add(this.executeSingleForBatch(batchRowValue));
                }
                ArrayList<Long> arrayList = results;
                return arrayList;
            }
            catch (SQLException e) {
                throw FBPreparedStatement.this.createBatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), results, e);
            }
            finally {
                FBPreparedStatement.this.currentStatementResult = FBStatement.StatementResult.NO_MORE_RESULTS;
                if (batchStatementListener != null) {
                    FBPreparedStatement.this.fbStatement.removeStatementListener(batchStatementListener);
                    FBPreparedStatement.this.specialResult.clear();
                    FBPreparedStatement.this.specialResult.addAll(batchStatementListener.getRows());
                }
                this.clearBatch();
            }
        }

        private long executeSingleForBatch(Batch.BatchRowValue batchRowValue) throws SQLException {
            if (FBPreparedStatement.this.internalExecute(batchRowValue.toRowValue())) {
                throw FBStatement.batchStatementReturnedResultSet();
            }
            return FBPreparedStatement.this.getLargeUpdateCountMinZero();
        }

        @Override
        public void clearBatch() {
            this.batchRowValues.clear();
        }

        @Override
        public void close() {
            this.clearBatch();
        }
    }

    private final class BatchedRowValue
    implements Batch.BatchRowValue {
        private final RowValue rowValue;
        private Object[] cachedObjects;

        private BatchedRowValue(RowValue rowValue) {
            this.rowValue = rowValue;
        }

        private int getCount() {
            return this.rowValue.getCount();
        }

        private void setCachedObject(int index, Object object) {
            this.checkBounds(index);
            if (this.cachedObjects == null) {
                this.cachedObjects = new Object[this.getCount()];
            }
            this.cachedObjects[index] = object;
        }

        private Object getCachedObject(int index) {
            this.checkBounds(index);
            if (this.cachedObjects == null) {
                return null;
            }
            return this.cachedObjects[index];
        }

        private void checkBounds(int index) {
            if (index < 0 || index >= this.getCount()) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RowValue toRowValue() throws SQLException {
            RowValue preservedFieldValues = FBPreparedStatement.this.fieldValues;
            try {
                FBPreparedStatement.this.fieldValues = this.rowValue;
                for (int i = 0; i < FBPreparedStatement.this.fieldValues.getCount(); ++i) {
                    FBField field = FBPreparedStatement.this.getField(i + 1);
                    if (!(field instanceof FBFlushableField)) continue;
                    ((FBFlushableField)((Object)field)).setCachedObject((FBFlushableField.CachedObject)this.getCachedObject(i));
                }
                FBPreparedStatement.this.flushFields();
                RowValue rowValue = this.rowValue;
                return rowValue;
            }
            finally {
                FBPreparedStatement.this.fieldValues = preservedFieldValues;
            }
        }
    }

    private static final class BatchStatementListener
    implements StatementListener {
        private final List<RowValue> rows;

        private BatchStatementListener(int expectedSize) {
            this.rows = new ArrayList<RowValue>(expectedSize);
        }

        @Override
        public void receivedRow(FbStatement sender, RowValue rowValue) {
            this.rows.add(rowValue);
        }

        public List<RowValue> getRows() {
            return new ArrayList<RowValue>(this.rows);
        }
    }
}

