/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.formatter.serialize;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import schemacrawler.schema.Catalog;
import schemacrawler.tools.formatter.serialize.JavaSerializedCatalog;
import schemacrawler.utility.MetaDataUtility;

public final class CatalogSerializationUtility {
    private static final Logger LOGGER = Logger.getLogger(CatalogSerializationUtility.class.getName());

    public static Catalog deserializeCatalog(Path offlineDatabasePath) throws IOException {
        Catalog catalog;
        try (GZIPInputStream inputFileStream = new GZIPInputStream(Files.newInputStream(offlineDatabasePath, new OpenOption[0]));){
            JavaSerializedCatalog deserializedCatalog = new JavaSerializedCatalog(inputFileStream);
            catalog = deserializedCatalog.getCatalog();
            LOGGER.log(Level.INFO, () -> MetaDataUtility.summarizeCatalog((Catalog)catalog));
        }
        return catalog;
    }

    private CatalogSerializationUtility() {
    }
}

