/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.sql.SQLException;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.impl.DbAttachInfo;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.ProtocolCollection;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.gds.ng.wire.WireConnection;

public final class WireDatabaseConnection
extends WireConnection<IConnectionProperties, FbWireDatabase> {
    public WireDatabaseConnection(IConnectionProperties connectionProperties) throws SQLException {
        super(connectionProperties);
    }

    public WireDatabaseConnection(IConnectionProperties connectionProperties, IEncodingFactory encodingFactory, ProtocolCollection protocols) throws SQLException {
        super(connectionProperties, encodingFactory, protocols);
    }

    @Override
    protected DbAttachInfo toDbAttachInfo(IConnectionProperties attachProperties) throws SQLException {
        DbAttachInfo dbAttachInfo;
        DbAttachInfo initialDbAttachInfo = DbAttachInfo.of(attachProperties);
        DbAttachInfo dbAttachInfo2 = dbAttachInfo = initialDbAttachInfo.hasServerName() ? initialDbAttachInfo : DbAttachInfo.parseConnectString(initialDbAttachInfo.getAttachObjectName());
        if (!dbAttachInfo.hasServerName()) {
            dbAttachInfo = dbAttachInfo.withServerName("localhost");
        }
        if (!dbAttachInfo.hasAttachObjectName()) {
            throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter(initialDbAttachInfo.getAttachObjectName()).messageParameter("null or empty database name in connection string").toSQLException();
        }
        return dbAttachInfo;
    }

    @Override
    protected FbWireDatabase createConnectionHandle(ProtocolDescriptor protocolDescriptor) {
        return protocolDescriptor.createDatabase(this);
    }
}

