/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.string.StringFormat;

public enum ConditionTimingType {
    unknown("unknown"),
    before("BEFORE"),
    instead_of("INSTEAD OF"),
    after("AFTER");

    private static final Logger LOGGER;
    private final String value;

    public static ConditionTimingType valueOfFromValue(String value) {
        for (ConditionTimingType type : ConditionTimingType.values()) {
            if (!type.getValue().equalsIgnoreCase(value)) continue;
            return type;
        }
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Unknown value <%s>", new Object[]{value}));
        return unknown;
    }

    private ConditionTimingType(String value) {
        this.value = value;
    }

    public final String getValue() {
        return this.value;
    }

    static {
        LOGGER = Logger.getLogger(ConditionTimingType.class.getName());
    }
}

