/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.embeddeddiagram;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.regex.Pattern;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.schemacrawler.exceptions.IORuntimeException;
import schemacrawler.schemacrawler.exceptions.SchemaCrawlerException;
import schemacrawler.tools.command.text.diagram.DiagramRenderer;
import schemacrawler.tools.command.text.diagram.GraphExecutorFactory;
import schemacrawler.tools.command.text.diagram.options.DiagramOptions;
import schemacrawler.tools.command.text.diagram.options.DiagramOutputFormat;
import schemacrawler.tools.command.text.schema.SchemaTextRenderer;
import schemacrawler.tools.command.text.schema.options.TextOutputFormat;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.executable.CommandOptions;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.property.PropertyName;

public class EmbeddedDiagramRenderer
extends BaseSchemaCrawlerCommand<DiagramOptions> {
    private static final Pattern svgInsertionPoint = Pattern.compile("<h2.*Tables.*h2>");
    private static final Pattern svgStart = Pattern.compile("<svg.*");
    private final GraphExecutorFactory graphExecutorFactory;

    private static void insertSvg(BufferedWriter finalHtmlFileWriter, BufferedReader baseSvgFileReader) throws IOException {
        String line;
        finalHtmlFileWriter.append(System.lineSeparator());
        boolean skipLines = true;
        boolean isSvgStart = false;
        while ((line = baseSvgFileReader.readLine()) != null) {
            if (skipLines) {
                isSvgStart = svgStart.matcher(line).matches();
                boolean bl = skipLines = !isSvgStart;
            }
            if (skipLines) continue;
            if (isSvgStart) {
                line = "<svg";
                isSvgStart = false;
            }
            finalHtmlFileWriter.append(line).append(System.lineSeparator());
        }
        finalHtmlFileWriter.append(System.lineSeparator());
    }

    public EmbeddedDiagramRenderer(PropertyName command, GraphExecutorFactory graphExecutorFactory) {
        super(command);
        this.graphExecutorFactory = Objects.requireNonNull(graphExecutorFactory, "No graph executor factory provided");
    }

    @Override
    public void checkAvailability() {
        this.graphExecutorFactory.canGenerate(DiagramOutputFormat.svg);
    }

    @Override
    public void execute() {
        this.checkCatalog();
        try {
            String stem = "schemacrawler";
            Path finalHtmlFile = IOUtility.createTempFilePath("schemacrawler", DiagramOutputFormat.htmlx.getFormat());
            Path baseHtmlFile = IOUtility.createTempFilePath("schemacrawler", TextOutputFormat.html.getFormat());
            Path baseSvgFile = IOUtility.createTempFilePath("schemacrawler", DiagramOutputFormat.svg.getFormat());
            this.executeCommand(new SchemaTextRenderer(this.command), baseHtmlFile, TextOutputFormat.html);
            this.executeCommand(new DiagramRenderer(this.command, this.graphExecutorFactory), baseSvgFile, DiagramOutputFormat.svg);
            try (BufferedWriter finalHtmlFileWriter = Files.newBufferedWriter(finalHtmlFile, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                 BufferedReader baseHtmlFileReader = Files.newBufferedReader(baseHtmlFile, StandardCharsets.UTF_8);
                 BufferedReader baseSvgFileReader = Files.newBufferedReader(baseSvgFile, StandardCharsets.UTF_8);){
                String line;
                while ((line = baseHtmlFileReader.readLine()) != null) {
                    if (svgInsertionPoint.matcher(line).matches()) {
                        EmbeddedDiagramRenderer.insertSvg(finalHtmlFileWriter, baseSvgFileReader);
                    }
                    finalHtmlFileWriter.append(line).append(System.lineSeparator());
                }
            }
            try (PrintWriter writer = this.outputOptions.openNewOutputWriter();){
                IOUtility.copy(Files.newBufferedReader(finalHtmlFile, StandardCharsets.UTF_8), writer);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException("Could not create embedded diagram", e);
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutionRuntimeException(e);
        }
    }

    @Override
    public boolean usesConnection() {
        return false;
    }

    private void executeCommand(SchemaCrawlerCommand<? super DiagramOptions> scCommand, Path outputFile, OutputFormat outputFormat) throws Exception {
        OutputOptions outputOptions = OutputOptionsBuilder.builder(this.getOutputOptions()).withOutputFormat(outputFormat).withOutputFile(outputFile).toOptions();
        scCommand.configure((CommandOptions)this.commandOptions);
        scCommand.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
        scCommand.setOutputOptions(outputOptions);
        scCommand.setIdentifiers(this.identifiers);
        scCommand.initialize();
        scCommand.checkAvailability();
        scCommand.setCatalog(this.catalog);
        scCommand.call();
    }
}

