/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.ColumnPointer;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.TablePointer;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Table;
import schemacrawler.schema.TypedObject;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;

final class TablePrivilegeRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(TablePrivilegeRetriever.class.getName());

    TablePrivilegeRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveTableColumnPrivileges() throws SQLException {
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.tableColumnPrivilegesRetrievalStrategy)) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving column privileges, using fast data dictionary retrieval");
                this.retrieveTableColumnPrivilegesFromDataDictionary();
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving column privileges from metadata");
                this.retrieveTableColumnPrivilegesFromMetadata();
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Not retrieving tables");
            }
        }
    }

    void retrieveTablePrivileges() throws SQLException {
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.tablePrivilegesRetrievalStrategy)) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving table privileges, using fast data dictionary retrieval");
                this.retrieveTablePrivilegesFromDataDictionary();
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving table privileges from metadata");
                this.retrieveTablePrivilegesFromMetadata();
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Not retrieving tables");
            }
        }
    }

    private void createPrivileges(MetadataResultSet results, boolean privilegesForColumn) throws SQLException {
        RetrievalCounts retrievalCounts = new RetrievalCounts(String.format("%s privileges", privilegesForColumn ? "column" : "table"));
        while (results.next()) {
            MutablePrivilege<TypedObject<ColumnDataType>> privilege;
            Optional<MutablePrivilege<TypedObject<ColumnDataType>>> privilegeOptional;
            MutableColumn column;
            retrievalCounts.count();
            String catalogName = this.normalizeCatalogName(results.getString("TABLE_CAT"));
            String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEM"));
            String tableName = results.getString("TABLE_NAME");
            String columnName = privilegesForColumn ? results.getString("COLUMN_NAME") : null;
            Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
            if (!tableOptional.isPresent()) continue;
            MutableTable table = tableOptional.get();
            if (privilegesForColumn) {
                Optional<MutableColumn> columnOptional = table.lookupColumn(columnName);
                if (!columnOptional.isPresent()) continue;
                column = columnOptional.get();
            } else {
                column = null;
            }
            String privilegeName = results.getString("PRIVILEGE");
            String grantor = results.getString("GRANTOR");
            String grantee = results.getString("GRANTEE");
            boolean isGrantable = results.getBoolean("IS_GRANTABLE");
            if (privilegesForColumn) {
                privilegeOptional = column.lookupPrivilege(privilegeName);
                privilege = privilegeOptional.orElse(new MutablePrivilege<Column>(new ColumnPointer(column), privilegeName));
            } else {
                privilegeOptional = table.lookupPrivilege(privilegeName);
                privilege = privilegeOptional.orElse(new MutablePrivilege<Table>(new TablePointer(table), privilegeName));
            }
            privilege.withQuoting(this.getRetrieverConnection().getIdentifiers());
            privilege.addGrant(grantor, grantee, isGrantable);
            if (privilegesForColumn) {
                column.addPrivilege(privilege);
            } else {
                table.addPrivilege(privilege);
            }
            retrievalCounts.countIncluded();
        }
        retrievalCounts.log();
    }

    private void retrieveTableColumnPrivilegesFromDataDictionary() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.TABLE_COLUMN_PRIVILEGES)) {
            throw new ExecutionRuntimeException("No table column privileges SQL provided");
        }
        Query tablePrivelegesSql = informationSchemaViews.getQuery(InformationSchemaKey.TABLE_COLUMN_PRIVILEGES);
        try (Connection connection = this.getRetrieverConnection().getConnection();
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(tablePrivelegesSql, statement, this.getLimitMap());){
            this.createPrivileges(results, true);
        }
    }

    private void retrieveTableColumnPrivilegesFromMetadata() {
        try (Connection connection = this.getRetrieverConnection().getConnection();
             MetadataResultSet results = new MetadataResultSet(connection.getMetaData().getColumnPrivileges(null, null, null, null), "DatabaseMetaData::getColumnPrivileges");){
            this.createPrivileges(results, true);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table column privileges:" + e.getMessage());
        }
    }

    private void retrieveTablePrivilegesFromDataDictionary() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.TABLE_PRIVILEGES)) {
            throw new ExecutionRuntimeException("No table privileges SQL provided");
        }
        Query tablePrivelegesSql = informationSchemaViews.getQuery(InformationSchemaKey.TABLE_PRIVILEGES);
        try (Connection connection = this.getRetrieverConnection().getConnection();
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(tablePrivelegesSql, statement, this.getLimitMap());){
            this.createPrivileges(results, false);
        }
    }

    private void retrieveTablePrivilegesFromMetadata() {
        try (Connection connection = this.getRetrieverConnection().getConnection();
             MetadataResultSet results = new MetadataResultSet(connection.getMetaData().getTablePrivileges(null, null, null), "DatabaseMetaData::getTablePrivileges");){
            this.createPrivileges(results, false);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table privileges", e);
        }
    }
}

