/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.wbs.WBSDiagram;

public class CommandWBSItem
extends SingleLineCommand2<WBSDiagram> {
    public CommandWBSItem(int mode) {
        super(false, CommandWBSItem.getRegexConcat(mode));
    }

    static IRegex getRegexConcat(int mode) {
        if (mode == 0) {
            return RegexConcat.build(CommandWBSItem.class.getName() + mode, RegexLeaf.start(), new RegexLeaf(1, "TYPE", "([ \t]*[*+-]+)"), new RegexOptional((IRegex)new RegexLeaf(1, "BACKCOLOR", "\\[(#\\w+)\\]")), new RegexOptional((IRegex)new RegexLeaf(1, "CODE", "\\(([%pLN_]+)\\)")), new RegexLeaf(1, "SHAPE", "(_)?"), new RegexLeaf(1, "DIRECTION", "([<>])?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "LABEL", "([^%s].*)"), RegexLeaf.end());
        }
        return RegexConcat.build(CommandWBSItem.class.getName() + mode, RegexLeaf.start(), new RegexLeaf(1, "TYPE", "([ \t]*[*+-]+)"), new RegexOptional((IRegex)new RegexLeaf(1, "BACKCOLOR", "\\[(#\\w+)\\]")), new RegexLeaf(1, "SHAPE", "(_)?"), new RegexLeaf(1, "DIRECTION", "([<>])?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "LABEL", "[%g](.*)[%g]"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "CODE", "([%pLN_]+)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(WBSDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String type = arg.get("TYPE", 0);
        String label = arg.get("LABEL", 0);
        String code = arg.get("CODE", 0);
        String stringColor = arg.get("BACKCOLOR", 0);
        HColor backColor = null;
        if (stringColor != null) {
            backColor = diagram.getSkinParam().getIHtmlColorSet().getColor(stringColor);
        }
        Direction dir = type.contains("-") ? Direction.LEFT : Direction.RIGHT;
        String direction = arg.get("DIRECTION", 0);
        if ("<".equals(direction)) {
            dir = Direction.LEFT;
        } else if (">".equals(direction)) {
            dir = Direction.RIGHT;
        }
        return diagram.addIdea(code, backColor, diagram.getSmartLevel(type), label, dir, IdeaShape.fromDesc(arg.get("SHAPE", 0)));
    }
}

