/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.decoration.symbol.USymbols;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.Style;

public class ComponentRoseQueue
extends AbstractTextualComponent {
    private final TextBlock stickman;
    private final boolean head;

    public ComponentRoseQueue(Style style, Style stereo, Display stringsToDisplay, boolean head, ISkinParam skinParam) {
        super(style, stereo, LineBreakStrategy.NONE, 3, 3, 0, skinParam, stringsToDisplay, false);
        Fashion biColor = style.getSymbolContext(this.getIHtmlColorSet());
        this.head = head;
        this.stickman = USymbols.QUEUE.asSmall(TextBlockUtils.empty(0.0, 0.0), this.getTextBlock(), TextBlockUtils.empty(0.0, 0.0), biColor, HorizontalAlignment.CENTER);
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimStickman = this.stickman.calculateDimension(stringBounder);
        double delta = (this.getPreferredWidth(stringBounder) - dimStickman.getWidth()) / 2.0;
        ug = ug.apply(UTranslate.dx(delta));
        this.stickman.drawU(ug);
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        XDimension2D dimStickman = this.stickman.calculateDimension(stringBounder);
        return dimStickman.getHeight();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        XDimension2D dimStickman = this.stickman.calculateDimension(stringBounder);
        return dimStickman.getWidth();
    }
}

