/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.Set;
import java.util.function.Consumer;
import oracle.jdbc.diagnostics.Diagnosable;

public abstract class SocketChannelWrapper
extends SocketChannel
implements Diagnosable {
    protected final Diagnosable diagnosable;
    protected SocketChannel socketChannel = null;
    protected int bufferSize = 8192;
    protected boolean blockingReadMode = true;

    SocketChannelWrapper(SocketChannel socketChannel, Diagnosable diagnosable) {
        super(socketChannel != null ? socketChannel.provider() : null);
        this.socketChannel = socketChannel;
        this.diagnosable = diagnosable;
    }

    abstract void disconnect() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int readNow(ByteBuffer buffer) throws IOException {
        this.setBlockingReadMode(false);
        try {
            int readBytes;
            int n = readBytes = this.read(buffer);
            return n;
        }
        finally {
            this.setBlockingReadMode(true);
        }
    }

    protected final void setBlockingReadMode(boolean status) {
        if (this.socketChannel instanceof SocketChannelWrapper) {
            ((SocketChannelWrapper)this.socketChannel).setBlockingReadMode(status);
        }
        this.blockingReadMode = status;
    }

    public SocketChannel getUnderlyingChannel() {
        return this.socketChannel;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosable;
    }

    public void setBufferSize(int newBufferSize) {
        this.bufferSize = newBufferSize;
    }

    void setUnderlyingChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    void setSoTimeout(int soTimeout) throws SocketException {
        if (!(this.socketChannel instanceof SocketChannelWrapper)) {
            throw new UnsupportedOperationException();
        }
        ((SocketChannelWrapper)this.socketChannel).setSoTimeout(soTimeout);
    }

    int getSoTimeout() {
        if (this.socketChannel instanceof SocketChannelWrapper) {
            return ((SocketChannelWrapper)this.socketChannel).getSoTimeout();
        }
        throw new UnsupportedOperationException();
    }

    void registerForNonBlockingRead(Consumer<Throwable> onReadReady) throws IOException {
        if (!(this.socketChannel instanceof SocketChannelWrapper)) {
            throw new UnsupportedOperationException();
        }
        ((SocketChannelWrapper)this.socketChannel).registerForNonBlockingRead(onReadReady);
    }

    void registerForNonBlockingWrite(Consumer<Throwable> onWriteReady) throws IOException {
        if (!(this.socketChannel instanceof SocketChannelWrapper)) {
            throw new UnsupportedOperationException();
        }
        ((SocketChannelWrapper)this.socketChannel).registerForNonBlockingWrite(onWriteReady);
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.requireOpenChannel().getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.requireNonNullChannel().supportedOptions();
    }

    @Override
    public SocketChannel bind(SocketAddress local) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> SocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        return this.requireOpenChannel().setOption((SocketOption)name, (Object)value);
    }

    @Override
    public SocketChannel shutdownInput() throws IOException {
        return this.requireOpenChannel().shutdownInput();
    }

    @Override
    public SocketChannel shutdownOutput() throws IOException {
        return this.requireOpenChannel().shutdownOutput();
    }

    @Override
    public Socket socket() {
        return this.requireNonNullChannel().socket();
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel != null && this.socketChannel.isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        return this.requireNonNullChannel().isConnectionPending();
    }

    @Override
    public boolean connect(SocketAddress remote) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this.requireOpenChannel().finishConnect();
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return this.requireOpenChannel().getRemoteAddress();
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.requireOpenChannel().getLocalAddress();
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        this.requireOpenChannel().close();
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        this.requireOpenChannel().configureBlocking(block);
    }

    protected void enqueueAllWrites(boolean isEnabled) {
        assert (this.socketChannel instanceof SocketChannelWrapper) : "Not a SocketChannelWrapper: " + this.socketChannel;
        ((SocketChannelWrapper)this.socketChannel).enqueueAllWrites(isEnabled);
    }

    protected boolean getEnqueueAllWrites() {
        if (this.socketChannel instanceof SocketChannelWrapper) {
            return ((SocketChannelWrapper)this.socketChannel).getEnqueueAllWrites();
        }
        return false;
    }

    protected void completeWrites() throws IOException {
        assert (this.socketChannel instanceof SocketChannelWrapper) : "Not a SocketChannelWrapper: " + this.socketChannel;
        ((SocketChannelWrapper)this.socketChannel).completeWrites();
    }

    protected void enqueueBlockedWrites(boolean isEnabled) {
        assert (this.socketChannel instanceof SocketChannelWrapper) : "Not a SocketChannelWrapper: " + this.socketChannel;
        ((SocketChannelWrapper)this.socketChannel).enqueueBlockedWrites(isEnabled);
    }

    protected boolean completeBlockedWrites() throws IOException {
        assert (this.socketChannel instanceof SocketChannelWrapper) : "Not a SocketChannelWrapper: " + this.socketChannel;
        return ((SocketChannelWrapper)this.socketChannel).completeBlockedWrites();
    }

    protected SocketChannel requireOpenChannel() throws ClosedChannelException {
        SocketChannel socketChannel = this.socketChannel;
        if (socketChannel == null) {
            throw new ClosedChannelException();
        }
        return socketChannel;
    }

    private SocketChannel requireNonNullChannel() throws IllegalStateException {
        try {
            return this.requireOpenChannel();
        }
        catch (ClosedChannelException closedChannelException) {
            throw new IllegalStateException("Socket is closed.", closedChannelException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ByteBuffer copy(ByteBuffer buffer, int length) {
        if (length < 1) {
            return null;
        }
        int origPosition = buffer.position();
        try {
            byte[] copyBytes = new byte[length];
            buffer.position(buffer.position() - length);
            buffer.get(copyBytes);
            ByteBuffer byteBuffer = ByteBuffer.wrap(copyBytes);
            return byteBuffer;
        }
        finally {
            buffer.position(origPosition);
        }
    }

    static SocketChannel unwrap(SocketChannel socketChannel) {
        SocketChannel unwrapped = socketChannel;
        while (unwrapped instanceof SocketChannelWrapper) {
            unwrapped = ((SocketChannelWrapper)unwrapped).getUnderlyingChannel();
        }
        return unwrapped;
    }
}

