/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.apacheconf.lexer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;

public class ApacheConfLexerUtils {
    public static <T extends TokenId> TokenSequence<T> seqForText(String text, Language<T> language) {
        TokenHierarchy hi = TokenHierarchy.create((CharSequence)text, language);
        return hi.tokenSequence(language);
    }

    public static String getFileContent(File file) throws Exception {
        StringBuilder sb = new StringBuilder();
        String lineSep = "\n";
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        String line = br.readLine();
        while (line != null) {
            sb.append(line);
            sb.append(lineSep);
            line = br.readLine();
        }
        br.close();
        return sb.toString();
    }

    public static String replaceLinesAndTabs(String input) {
        String escapedString = input;
        escapedString = escapedString.replace("\n", "\\n");
        escapedString = escapedString.replace("\r", "\\r");
        escapedString = escapedString.replace("\t", "\\t");
        return escapedString;
    }
}

