/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.spi.viewmodel.ColumnModel;

final class HyperColumnModel
extends ColumnModel {
    private ColumnModel main;
    private ColumnModel specific;
    private final Set<String> ids;

    public HyperColumnModel(ColumnModel main, ColumnModel specific) {
        this.main = main;
        this.specific = specific;
        this.ids = HyperColumnModel.createAllIDs(main, specific);
    }

    private static Set<String> createAllIDs(ColumnModel ... cms) {
        HashSet<String> allIds = new HashSet<String>();
        for (ColumnModel cm : cms) {
            if (cm instanceof HyperColumnModel) {
                allIds.addAll(((HyperColumnModel)cm).getAllIDs());
                continue;
            }
            allIds.add(cm.getID());
        }
        return allIds;
    }

    public ColumnModel getMain() {
        return this.main;
    }

    public ColumnModel getSpecific() {
        return this.specific;
    }

    @Override
    public String getID() {
        return this.main.getID();
    }

    @Override
    public String getDisplayName() {
        return this.main.getDisplayName();
    }

    @Override
    public String getShortDescription() {
        return this.main.getShortDescription();
    }

    @Override
    public Class getType() {
        return this.specific.getType();
    }

    Set<String> getAllIDs() {
        return this.ids;
    }
}

