/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsClientRootNode;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsRootNode;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.jaxws.light.spi.JAXWSLightSupportProvider;
import org.netbeans.modules.websvc.project.api.WebServiceData;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class JaxWsNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project p) {
        assert (p != null);
        return new WsNodeList(p);
    }

    private static class WsNodeList
    implements NodeList<String>,
    PropertyChangeListener,
    LookupListener,
    Runnable {
        private static final String KEY_SERVICES = "web_services";
        private static final String KEY_SERVICE_REFS = "serviceRefs";
        private final Project project;
        private JAXWSLightSupport jaxwsSupport;
        private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        private Lookup.Result<JAXWSLightSupportProvider> lookupResult;
        private final AtomicReference<List<String>> nodeList;
        private static final RequestProcessor JAX_WS_RP = new RequestProcessor(WsNodeList.class);

        public WsNodeList(Project proj) {
            this.project = proj;
            this.nodeList = new AtomicReference();
        }

        @Override
        public void run() {
            ArrayList<String> result = new ArrayList<String>(2);
            if (this.jaxwsSupport != null) {
                List services = this.jaxwsSupport.getServices();
                boolean hasServices = false;
                boolean hasClients = false;
                for (JaxWsService s : services) {
                    if (!hasServices && s.isServiceProvider()) {
                        hasServices = true;
                    } else if (!hasClients && !s.isServiceProvider()) {
                        hasClients = true;
                    }
                    if (!hasServices || !hasClients) continue;
                    break;
                }
                if (hasServices) {
                    result.add(KEY_SERVICES);
                }
                if (hasClients) {
                    result.add(KEY_SERVICE_REFS);
                }
                this.nodeList.set(result);
                if (hasServices || hasClients) {
                    this.fireChange();
                }
            }
        }

        public List<String> keys() {
            List<String> keys = this.nodeList.get();
            if (keys != null && !keys.isEmpty()) {
                this.nodeList.compareAndSet(keys, null);
                return keys;
            }
            JAX_WS_RP.post((Runnable)this, 100);
            return Collections.emptyList();
        }

        public synchronized void addChangeListener(ChangeListener l) {
            this.listeners.add(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            this.listeners.remove(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ArrayList<ChangeListener> list = new ArrayList<ChangeListener>();
            WsNodeList wsNodeList = this;
            synchronized (wsNodeList) {
                list.addAll(this.listeners);
            }
            for (ChangeListener elem : list) {
                elem.stateChanged(new ChangeEvent(this));
            }
        }

        public Node node(String key) {
            if (KEY_SERVICES.equals(key)) {
                WebServiceData wsData = WebServiceData.getWebServiceData((Project)this.project);
                return new JaxWsRootNode(this.project, wsData);
            }
            if (KEY_SERVICE_REFS.equals(key)) {
                WebServiceData wsData = WebServiceData.getWebServiceData((Project)this.project);
                return new JaxWsClientRootNode(this.project, wsData);
            }
            return null;
        }

        public void addNotify() {
            if (this.jaxwsSupport == null) {
                this.jaxwsSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)this.project.getProjectDirectory());
            }
            if (this.jaxwsSupport != null) {
                this.jaxwsSupport.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.jaxwsSupport));
            } else {
                this.lookupResult = this.project.getLookup().lookupResult(JAXWSLightSupportProvider.class);
                if (this.lookupResult.allInstances().size() == 0) {
                    this.lookupResult.addLookupListener((LookupListener)this);
                }
            }
        }

        public void removeNotify() {
            if (this.jaxwsSupport != null) {
                this.jaxwsSupport.removePropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.jaxwsSupport));
                this.jaxwsSupport = null;
            }
            if (this.lookupResult != null) {
                this.lookupResult.removeLookupListener((LookupListener)this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.fireChange();
        }

        public void resultChanged(LookupEvent evt) {
            this.jaxwsSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)this.project.getProjectDirectory());
            if (this.jaxwsSupport != null) {
                this.jaxwsSupport.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.jaxwsSupport));
            }
        }
    }
}

