/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.DatabaseServerManager;
import org.netbeans.modules.db.mysql.impl.DbExplorerConnectionListener;
import org.netbeans.modules.db.mysql.impl.Installation;
import org.netbeans.modules.db.mysql.impl.InstallationManager;
import org.netbeans.modules.db.mysql.impl.MySQLOptions;
import org.netbeans.modules.db.mysql.nodes.ServerNode;
import org.netbeans.modules.db.mysql.util.DatabaseUtils;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class ServerNodeProvider
extends NodeProvider {
    private static final Logger LOGGER = Logger.getLogger(ServerNodeProvider.class.getName());
    private static ServerNodeProvider DEFAULT = null;
    private static final MySQLOptions options = MySQLOptions.getDefault();
    private final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    public static ServerNodeProvider getDefault() {
        return DEFAULT;
    }

    private ServerNodeProvider(Lookup lookup) {
        super(lookup);
    }

    protected void initialize() {
        if (!options.isProviderRegistered() && !options.isProviderRemoved()) {
            this.findAndRegisterMySQL();
        }
        if (!options.isProviderRegistered()) {
            DatabaseServerManager.getDatabaseServer().disconnect();
        }
        this.update();
    }

    private void update() {
        ArrayList<ServerNode> newList = new ArrayList<ServerNode>();
        if (this.isRegistered()) {
            ServerNode node = ServerNode.create(DatabaseServerManager.getDatabaseServer());
            newList.add(node);
        }
        this.setNodes(newList);
    }

    private void findAndRegisterMySQL() {
        if (DatabaseUtils.getJDBCDriver() == null) {
            return;
        }
        if (options.isProviderRegistered() || options.isProviderRemoved()) {
            return;
        }
        this.registerConnectionListener();
        this.findAndRegisterInstallation();
    }

    private void registerConnectionListener() {
        ConnectionManager.getDefault().addConnectionListener((ConnectionListener)new DbExplorerConnectionListener());
    }

    private void findAndRegisterInstallation() {
        Installation installation = InstallationManager.detectInstallation();
        this.registerInstallation(installation);
    }

    public void registerInstallation(Installation installation) {
        if (installation == null) {
            return;
        }
        String[] command = installation.getAdminCommand();
        if (Utils.isValidExecutable(command[0], true) || Utils.isValidURL(command[0], true)) {
            options.setAdminPath(command[0]);
            options.setAdminArgs(command[1]);
        }
        if (Utils.isValidExecutable((command = installation.getStartCommand())[0], true)) {
            options.setStartPath(command[0]);
            options.setStartArgs(command[1]);
        }
        if (Utils.isValidExecutable((command = installation.getStopCommand())[0], true)) {
            options.setStopPath(command[0]);
            options.setStopArgs(command[1]);
        }
        options.setPort(installation.getDefaultPort());
        this.setRegistered(true);
    }

    public void setRegistered(boolean registered) {
        boolean old = this.isRegistered();
        if (registered != old) {
            final DatabaseServer instance = DatabaseServerManager.getDatabaseServer();
            options.setProviderRegistered(registered);
            if (!registered) {
                instance.disconnect();
            } else {
                RequestProcessor.getDefault().post(new Runnable(){
                    final /* synthetic */ ServerNodeProvider this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        try {
                            instance.checkConfiguration();
                        }
                        catch (DatabaseException dbe) {
                            LOGGER.log(Level.INFO, null, dbe);
                        }
                    }
                });
            }
            this.update();
            this.notifyChange();
        }
    }

    public synchronized boolean isRegistered() {
        return options.isProviderRegistered();
    }

    void notifyChange() {
        ChangeEvent evt = new ChangeEvent((Object)this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(evt);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            public ServerNodeProvider createInstance(Lookup lookup) {
                DEFAULT = new ServerNodeProvider(lookup);
                return DEFAULT;
            }
        };

        private FactoryHolder() {
        }
    }
}

