/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nbform;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.RequestProcessor;

public class SwingAppLibDownloader
implements BrokenReferencesSupport.LibraryDefiner {
    private static RequestProcessor RP = new RequestProcessor(SwingAppLibDownloader.class.getName(), 1);
    private static final Logger LOG = Logger.getLogger(SwingAppLibDownloader.class.getName());
    private JButton libraryManager;
    private JButton tryAgain;
    private JButton proxySettings;

    public Callable<Library> missingLibrary(final String name) {
        if (!name.matches("swing-app-framework")) {
            return null;
        }
        return new Callable<Library>(){
            final /* synthetic */ SwingAppLibDownloader this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Library call() throws Exception {
                return this.this$0.download(name);
            }
        };
    }

    private Library download(String name) throws Exception {
        UpdateElement element;
        UpdateUnit unit = this.findSwingAppLibModule();
        if (unit == null) {
            String searchingHandleTxt = FormUtils.getBundleString((String)"swingapp.searching_handle");
            final ProgressHandle handle = ProgressHandleFactory.createHandle((String)searchingHandleTxt);
            this.initButtons();
            final DialogDescriptor searching = new DialogDescriptor((Object)SwingAppLibDownloader.searchingPanel(new JLabel(searchingHandleTxt), ProgressHandleFactory.createProgressComponent((ProgressHandle)handle)), FormUtils.getBundleString((String)"swingapp.resolve_title"), true, null);
            handle.setInitialDelay(0);
            handle.start();
            searching.setOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
            searching.setMessageType(-1);
            final Dialog dlg = DialogDisplayer.getDefault().createDialog(searching);
            RP.post(new Runnable(){
                final /* synthetic */ SwingAppLibDownloader this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    block7: {
                        try {
                            for (UpdateUnitProvider p : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true)) {
                                p.refresh(handle, true);
                            }
                            dlg.dispose();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(SwingAppLibDownloader.class.getName()).log(Level.FINE, ex.getMessage(), ex);
                            if (!dlg.isVisible()) {
                                LOG.fine("dialog not visible => do nothing");
                                return;
                            }
                            DialogDescriptor networkProblem = new DialogDescriptor((Object)SwingAppLibDownloader.problemPanel(FormUtils.getBundleString((String)"swingapp.resolve_title"), FormUtils.getBundleString((String)"swingapp.networkproblem_message")), FormUtils.getBundleString((String)"swingapp.networkproblem_header"), true, null);
                            networkProblem.setOptions(new Object[]{this.this$0.tryAgain, this.this$0.proxySettings, NotifyDescriptor.CANCEL_OPTION});
                            networkProblem.setAdditionalOptions(new Object[]{this.this$0.libraryManager});
                            networkProblem.setClosingOptions(new Object[]{this.this$0.libraryManager, this.this$0.tryAgain, NotifyDescriptor.CANCEL_OPTION});
                            networkProblem.setMessageType(2);
                            Dialog networkProblemDialog = DialogDisplayer.getDefault().createDialog(networkProblem);
                            networkProblemDialog.setVisible(true);
                            Object answer = networkProblem.getValue();
                            if (NotifyDescriptor.CANCEL_OPTION.equals(answer) || answer.equals(-1)) {
                                LOG.fine("cancel network problem dialog");
                                searching.setValue(answer);
                                dlg.dispose();
                            }
                            if (this.this$0.tryAgain.equals(answer)) {
                                LOG.fine("try again searching");
                                RP.post((Runnable)this);
                            }
                            if (this.this$0.libraryManager.equals(answer)) {
                                LOG.fine("open library manager");
                                searching.setValue(answer);
                                dlg.dispose();
                            }
                            if ($assertionsDisabled) break block7;
                            throw new AssertionError((Object)("Unknown " + answer));
                        }
                    }
                }
            });
            dlg.setVisible(true);
            handle.finish();
            if (NotifyDescriptor.CANCEL_OPTION.equals(searching.getValue()) || searching.getValue().equals(-1)) {
                LOG.fine("user canceled searching swingapplib");
                return this.showNoDownloadDialog(name);
            }
            if (this.libraryManager.equals(searching.getValue())) {
                throw new Exception("user canceled searching");
            }
            unit = this.findSwingAppLibModule();
            if (unit == null) {
                LOG.fine("could not find swingapplib on any update site");
                return this.showNoDownloadDialog(name);
            }
        }
        if (unit.getInstalled() != null) {
            LOG.log(Level.FINE, "{0} already installed. Is active? {1}", new Object[]{unit.getInstalled(), unit.getInstalled().isEnabled()});
            if (unit.getInstalled().isEnabled()) {
                throw new Exception(unit.getInstalled() + " already installed and active");
            }
            OperationContainer oc = OperationContainer.createForEnable();
            if (!oc.canBeAdded(unit, unit.getInstalled())) {
                throw new Exception("could not add " + unit.getInstalled() + " for activation");
            }
            for (UpdateElement req : oc.add(unit.getInstalled()).getRequiredElements()) {
                oc.add(req);
            }
            ProgressHandle activeHandle = ProgressHandleFactory.createHandle((String)FormUtils.getBundleString((String)"swingapp.active_handle"));
            OperationSupport.Restarter restarter = ((OperationSupport)oc.getSupport()).doOperation(activeHandle);
            assert (restarter == null) : "No Restater need to make " + unit.getInstalled() + " active";
            for (int i = 0; i < 10; ++i) {
                Library lib = LibraryManager.getDefault().getLibrary(name);
                if (lib != null) {
                    return lib;
                }
                Thread.sleep(1000L);
            }
            LOG.info("swingapplib failed to make active properly");
            return this.showNoDownloadDialog(name);
        }
        List updates = unit.getAvailableUpdates();
        if (updates.isEmpty()) {
            throw new Exception("no updates for " + unit);
        }
        OperationContainer oc = OperationContainer.createForInstall();
        if (!oc.canBeAdded(unit, element = (UpdateElement)updates.get(0))) {
            throw new Exception("could not add " + element + " to updates");
        }
        for (UpdateElement req : oc.add(element).getRequiredElements()) {
            oc.add(req);
        }
        if (!PluginManager.openInstallWizard((OperationContainer)oc)) {
            LOG.fine("user canceled PM");
            return this.showNoDownloadDialog(name);
        }
        for (int i = 0; i < 10; ++i) {
            Library lib = LibraryManager.getDefault().getLibrary(name);
            if (lib != null) {
                return lib;
            }
            Thread.sleep(1000L);
        }
        LOG.info("swingapplib failed to install properly");
        return this.showNoDownloadDialog(name);
    }

    private UpdateUnit findSwingAppLibModule() throws IOException {
        for (UpdateUnit unit : UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE})) {
            if (!unit.getCodeName().equals("org.netbeans.modules.swingapplib")) continue;
            return unit;
        }
        return null;
    }

    private void initButtons() {
        if (this.libraryManager != null) {
            return;
        }
        this.libraryManager = new JButton();
        this.tryAgain = new JButton();
        this.proxySettings = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.tryAgain, (String)FormUtils.getBundleString((String)"swingapp.tryagain_button"));
        Mnemonics.setLocalizedText((AbstractButton)this.libraryManager, (String)FormUtils.getBundleString((String)"swingapp.library_button"));
        Mnemonics.setLocalizedText((AbstractButton)this.proxySettings, (String)FormUtils.getBundleString((String)"swingapp.proxy_button"));
        this.proxySettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOG.fine("show proxy options");
                OptionsDisplayer.getDefault().open("General");
            }
        });
    }

    private Library showNoDownloadDialog(String name) throws Exception {
        DialogDescriptor networkProblem = new DialogDescriptor((Object)SwingAppLibDownloader.problemPanel(FormUtils.getBundleString((String)"swingapp.nodownload_header"), FormUtils.getBundleString((String)"swingapp.nodownload_message")), FormUtils.getBundleString((String)"swingapp.resolve_title"), true, null);
        this.initButtons();
        networkProblem.setOptions(new Object[]{this.tryAgain, NotifyDescriptor.CANCEL_OPTION});
        networkProblem.setAdditionalOptions(new Object[]{this.libraryManager});
        networkProblem.setClosingOptions(new Object[]{this.libraryManager, this.tryAgain, NotifyDescriptor.CANCEL_OPTION});
        networkProblem.setMessageType(2);
        Dialog networkProblemDialog = DialogDisplayer.getDefault().createDialog(networkProblem);
        networkProblemDialog.setVisible(true);
        Object answer = networkProblem.getValue();
        if (NotifyDescriptor.CANCEL_OPTION.equals(answer) || answer.equals(-1)) {
            LOG.fine("cancel no download dialog");
            return null;
        }
        if (this.tryAgain.equals(answer)) {
            LOG.fine("try again download()");
            return this.download(name);
        }
        if (this.libraryManager.equals(answer)) {
            LOG.fine("open library manager");
            throw new Exception("swingapplib failed/canceled to install properly, open library manager instaed");
        }
        assert (false) : "Unknown " + answer;
        return null;
    }

    private static JPanel searchingPanel(JLabel progressLabel, JComponent progressComponent) {
        JPanel panel = new JPanel();
        progressLabel.setLabelFor(progressComponent);
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(progressLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(progressComponent, GroupLayout.Alignment.LEADING, -1, 399, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(96, 96, 96).addComponent(progressLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(progressComponent, -2, -1, -2).addContainerGap(109, Short.MAX_VALUE)));
        return panel;
    }

    private static JPanel problemPanel(String header, String message) {
        JPanel panel = new JPanel();
        JLabel jLabel1 = new JLabel();
        JScrollPane jScrollPane1 = new JScrollPane();
        JTextArea jTextArea1 = new JTextArea();
        jLabel1.setFont(jLabel1.getFont().deriveFont(jLabel1.getFont().getStyle() | 1));
        jLabel1.setText(header);
        jTextArea1.setColumns(20);
        jTextArea1.setEditable(false);
        jTextArea1.setLineWrap(true);
        jTextArea1.setWrapStyleWord(true);
        jTextArea1.setRows(5);
        jTextArea1.setText(message);
        jTextArea1.setOpaque(false);
        jScrollPane1.setViewportView(jTextArea1);
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane1, -1, 478, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(jLabel1).addGap(107, 107, 107))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jScrollPane1, -1, 133, Short.MAX_VALUE).addGap(82, 82, 82)));
        return panel;
    }
}

