/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.ignore;

import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class IgnoreAction
extends ContextAction {
    public static final int UNDEFINED = 0;
    public static final int IGNORING = 1;
    public static final int UNIGNORING = 2;

    @Override
    protected boolean enable(Node[] nodes) {
        Set ctxFiles;
        VCSContext context = HgUtils.getCurrentContext(nodes);
        Set set = ctxFiles = context != null ? context.getRootFiles() : null;
        if (!HgUtils.isFromHgRepository(context) || ctxFiles == null || ctxFiles.isEmpty()) {
            return false;
        }
        return !HgUtils.onlyProjects(nodes);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Ignore";
    }

    public int getActionStatus(File[] files) {
        int actionStatus = -1;
        if (files.length == 0) {
            return 0;
        }
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().equals(".hg") || SharabilityQuery.getSharability((File)files[i]) == 2) {
                actionStatus = 0;
                break;
            }
            FileInformation info = cache.getStatus(files[i]);
            if (info.getStatus() == 4 || info.getStatus() == 8 && info.isDirectory()) {
                if (actionStatus == 2) {
                    actionStatus = 0;
                    break;
                }
                actionStatus = 1;
                continue;
            }
            if (info.getStatus() == 2) {
                if (actionStatus == 1) {
                    actionStatus = 0;
                    break;
                }
                actionStatus = 2;
                continue;
            }
            actionStatus = 0;
            break;
        }
        return actionStatus == -1 ? 0 : actionStatus;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        Set ctxFiles;
        final VCSContext context = HgUtils.getCurrentContext(nodes);
        final Set<File> repositories = HgUtils.getRepositoryRoots(context);
        if (repositories == null || repositories.isEmpty()) {
            return;
        }
        Set set = ctxFiles = context != null ? context.getRootFiles() : null;
        if (ctxFiles == null || ctxFiles.isEmpty()) {
            return;
        }
        File repository = repositories.iterator().next();
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
        HgProgressSupport support = new HgProgressSupport(this){
            final /* synthetic */ IgnoreAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void perform() {
                for (File repository : repositories) {
                    File[] files = HgUtils.filterForRepository(context, repository, true);
                    this.performIgnore(repository, files);
                }
            }

            private void performIgnore(File repository, File[] files) throws MissingResourceException {
                OutputLogger logger = this.getLogger();
                int mActionStatus = this.this$0.getActionStatus(files);
                try {
                    if (mActionStatus == 0) {
                        logger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_TITLE"));
                        logger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_TITLE_SEP"));
                        logger.output(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_ONLY_LOCALLY_NEW"));
                        logger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_DONE"));
                        logger.output("");
                        return;
                    }
                    if (mActionStatus == 1) {
                        HgUtils.addIgnored(repository, files);
                        logger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_TITLE"));
                        logger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_TITLE_SEP"));
                        logger.output(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_INIT_SEP", (Object)repository.getName()));
                    } else {
                        HgUtils.removeIgnored(repository, files);
                        logger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_UNIGNORE_TITLE"));
                        logger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_UNIGNORE_TITLE_SEP"));
                        logger.output(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_UNIGNORE_INIT_SEP", (Object)repository.getName()));
                    }
                }
                catch (IOException ex) {
                    Mercurial.LOG.log(Level.FINE, "IgnoreAction(): File {0} - {1}", new Object[]{repository.getAbsolutePath(), ex.toString()});
                }
                for (File file : files) {
                    Mercurial.getInstance().getFileStatusCache().refreshIgnores(file);
                    logger.output("\t" + file.getAbsolutePath());
                }
                if (mActionStatus == 1) {
                    logger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_IGNORE_DONE"));
                } else {
                    logger.outputInRed(NbBundle.getMessage(IgnoreAction.class, (String)"MSG_UNIGNORE_DONE"));
                }
                logger.output("");
            }
        };
        support.start(rp, repository, NbBundle.getMessage(IgnoreAction.class, (String)"LBL_Ignore_Progress"));
    }
}

