/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2sedeploy;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.java.j2sedeploy.J2SEDeployProperties;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public class J2SEDeployProjectOpenHook
extends ProjectOpenedHook {
    private static final Logger LOG = Logger.getLogger(J2SEDeployProjectOpenHook.class.getName());
    private final Project prj;
    private final J2SEPropertyEvaluator eval;

    public J2SEDeployProjectOpenHook(@NonNull Lookup baseLookup) {
        Parameters.notNull((CharSequence)"baseLookup", (Object)baseLookup);
        this.prj = (Project)baseLookup.lookup(Project.class);
        Parameters.notNull((CharSequence)"prj", (Object)this.prj);
        this.eval = (J2SEPropertyEvaluator)baseLookup.lookup(J2SEPropertyEvaluator.class);
        Parameters.notNull((CharSequence)"eval", (Object)this.eval);
    }

    protected void projectOpened() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Project opened {0} ({1}).", new Object[]{ProjectUtils.getInformation((Project)this.prj).getDisplayName(), FileUtil.getFileDisplayName((FileObject)this.prj.getProjectDirectory())});
        }
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                J2SEDeployProjectOpenHook.this.updateBuildScript();
            }
        });
    }

    protected void projectClosed() {
    }

    private void updateBuildScript() {
        assert (ProjectManager.mutex().isWriteAccess());
        AntBuildExtender extender = (AntBuildExtender)this.prj.getLookup().lookup(AntBuildExtender.class);
        if (extender == null) {
            LOG.log(Level.WARNING, "The project {0} ({1}) does not support AntBuildExtender.", new Object[]{ProjectUtils.getInformation((Project)this.prj).getDisplayName(), FileUtil.getFileDisplayName((FileObject)this.prj.getProjectDirectory())});
            return;
        }
        if (extender.getExtension(J2SEDeployProperties.getCurrentExtensionName()) == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "The project {0} ({1}) does not have a current version ({2}) of J2SEDeploy extension.", new Object[]{ProjectUtils.getInformation((Project)this.prj).getDisplayName(), FileUtil.getFileDisplayName((FileObject)this.prj.getProjectDirectory()), J2SEDeployProperties.getCurrentExtensionName()});
            }
            return;
        }
        if (J2SEDeployProperties.isBuildNativeUpToDate(this.prj)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "The project {0} ({1}) have an up to date J2SEDeploy extension.", new Object[]{ProjectUtils.getInformation((Project)this.prj).getDisplayName(), FileUtil.getFileDisplayName((FileObject)this.prj.getProjectDirectory())});
            }
            return;
        }
        try {
            J2SEDeployProperties.copyBuildNativeTemplate(this.prj);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

