/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.ConvertToPdbDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ConvertToPdbRequest
extends BmcRequest<ConvertToPdbDetails> {
    private String databaseId;
    private ConvertToPdbDetails convertToPdbDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getDatabaseId() {
        return this.databaseId;
    }

    public ConvertToPdbDetails getConvertToPdbDetails() {
        return this.convertToPdbDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ConvertToPdbDetails getBody$() {
        return this.convertToPdbDetails;
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).convertToPdbDetails(this.convertToPdbDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",convertToPdbDetails=").append(String.valueOf((Object)this.convertToPdbDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConvertToPdbRequest)) {
            return false;
        }
        ConvertToPdbRequest other = (ConvertToPdbRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals((Object)this.convertToPdbDetails, (Object)other.convertToPdbDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.convertToPdbDetails == null ? 43 : this.convertToPdbDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ConvertToPdbRequest, ConvertToPdbDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseId = null;
        private ConvertToPdbDetails convertToPdbDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder convertToPdbDetails(ConvertToPdbDetails convertToPdbDetails) {
            this.convertToPdbDetails = convertToPdbDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ConvertToPdbRequest o) {
            this.databaseId(o.getDatabaseId());
            this.convertToPdbDetails(o.getConvertToPdbDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ConvertToPdbRequest build() {
            ConvertToPdbRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ConvertToPdbDetails body) {
            this.convertToPdbDetails(body);
            return this;
        }

        public ConvertToPdbRequest buildWithoutInvocationCallback() {
            ConvertToPdbRequest request = new ConvertToPdbRequest();
            request.databaseId = this.databaseId;
            request.convertToPdbDetails = this.convertToPdbDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

