/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.artifacts.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.artifacts.model.UpdateRepositoryDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateRepositoryRequest
extends BmcRequest<UpdateRepositoryDetails> {
    private String repositoryId;
    private UpdateRepositoryDetails updateRepositoryDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public UpdateRepositoryDetails getUpdateRepositoryDetails() {
        return this.updateRepositoryDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateRepositoryDetails getBody$() {
        return this.updateRepositoryDetails;
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).updateRepositoryDetails(this.updateRepositoryDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(",updateRepositoryDetails=").append(String.valueOf((Object)this.updateRepositoryDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateRepositoryRequest)) {
            return false;
        }
        UpdateRepositoryRequest other = (UpdateRepositoryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals((Object)this.updateRepositoryDetails, (Object)other.updateRepositoryDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.updateRepositoryDetails == null ? 43 : this.updateRepositoryDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateRepositoryRequest, UpdateRepositoryDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String repositoryId = null;
        private UpdateRepositoryDetails updateRepositoryDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder updateRepositoryDetails(UpdateRepositoryDetails updateRepositoryDetails) {
            this.updateRepositoryDetails = updateRepositoryDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateRepositoryRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.updateRepositoryDetails(o.getUpdateRepositoryDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateRepositoryRequest build() {
            UpdateRepositoryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateRepositoryDetails body) {
            this.updateRepositoryDetails(body);
            return this;
        }

        public UpdateRepositoryRequest buildWithoutInvocationCallback() {
            UpdateRepositoryRequest request = new UpdateRepositoryRequest();
            request.repositoryId = this.repositoryId;
            request.updateRepositoryDetails = this.updateRepositoryDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

