/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.config.parser;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.ConfigurationException;
import com.sun.xml.rpc.processor.config.ModelInfo;
import com.sun.xml.rpc.processor.config.parser.Constants;
import com.sun.xml.rpc.processor.config.parser.ModelFileModelInfoParser;
import com.sun.xml.rpc.processor.config.parser.ModelInfoParser;
import com.sun.xml.rpc.processor.config.parser.ModelInfoPlugin;
import com.sun.xml.rpc.processor.config.parser.NoMetadataModelInfoParser;
import com.sun.xml.rpc.processor.config.parser.ParserUtil;
import com.sun.xml.rpc.processor.config.parser.RmiModelInfoParser;
import com.sun.xml.rpc.processor.config.parser.WSDLModelInfoParser;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderException;
import com.sun.xml.rpc.streaming.XMLReaderFactory;
import com.sun.xml.rpc.tools.plugin.ToolPluginFactory;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConfigurationParser {
    private ProcessorEnvironment _env;
    private Map _modelInfoParsers;

    public ConfigurationParser(ProcessorEnvironment env) {
        this._env = env;
        this._modelInfoParsers = new HashMap();
        this._modelInfoParsers.put(Constants.QNAME_SERVICE, new RmiModelInfoParser(env));
        this._modelInfoParsers.put(Constants.QNAME_WSDL, new WSDLModelInfoParser(env));
        this._modelInfoParsers.put(Constants.QNAME_MODELFILE, new ModelFileModelInfoParser(env));
        this._modelInfoParsers.put(Constants.QNAME_NO_METADATA, new NoMetadataModelInfoParser(env));
        Iterator i = ToolPluginFactory.getInstance().getExtensions("com.sun.xml.rpc.tools.wscompile", "com.sun.xml.rpc.tools.wscompile.modelInfo");
        while (i != null && i.hasNext()) {
            ModelInfoPlugin plugin = (ModelInfoPlugin)i.next();
            this._modelInfoParsers.put(plugin.getModelInfoName(), plugin.createModelInfoParser(env));
        }
    }

    public com.sun.xml.rpc.spi.tools.Configuration parse(InputStream is) {
        try {
            XMLReader reader = XMLReaderFactory.newInstance().createXMLReader(is);
            reader.next();
            return this.parseConfiguration(reader);
        }
        catch (XMLReaderException e) {
            throw new ConfigurationException("configuration.xmlReader", e);
        }
    }

    protected com.sun.xml.rpc.spi.tools.Configuration parseConfiguration(XMLReader reader) {
        String version;
        if (!reader.getName().equals(Constants.QNAME_CONFIGURATION)) {
            ParserUtil.failWithFullName("configuration.invalidElement", reader);
        }
        if ((version = ParserUtil.getAttribute(reader, "version")) != null && !version.equals("1.0")) {
            ParserUtil.failWithLocalName("configuration.invalidVersionNumber", reader, version);
        }
        Configuration configuration = new Configuration(this._env);
        if (reader.nextElementContent() == 1) {
            configuration.setModelInfo(this.parseModelInfo(reader));
        } else {
            ParserUtil.fail("configuration.missing.model", reader);
        }
        if (reader.nextElementContent() != 2) {
            ParserUtil.fail("configuration.unexpectedContent", reader);
        }
        reader.close();
        return configuration;
    }

    protected ModelInfo parseModelInfo(XMLReader reader) {
        ModelInfoParser miParser = (ModelInfoParser)this._modelInfoParsers.get(reader.getName());
        if (miParser != null) {
            return miParser.parse(reader);
        }
        ParserUtil.fail("configuration.unknown.modelInfo", reader);
        return null;
    }
}

