/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.common.util.Utility;
import com.sun.xml.registry.common.util.VersionUtil;
import com.sun.xml.registry.uddi.ProtoCallbackHandler;
import com.sun.xml.registry.uddi.RegistryServiceImpl;
import java.net.PasswordAuthentication;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.registry.Connection;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;

public class ConnectionImpl
implements Connection {
    static final String QUERY_URL_PROP = "javax.xml.registry.queryManagerURL";
    static final String LIFE_CYCLE_URL_PROP = "javax.xml.registry.lifeCycleManagerURL";
    static final String SEMANTIC_EQ_PROP = "javax.xml.registry.semanticEquivalences";
    static final String AUTH_METHOD_PROP = "javax.xml.registry.security.authenticationMethod";
    static final String MAX_ROWS = "javax.xml.registry.uddi.maxRows";
    static final String POSTAL_SCHEME_PROP = "javax.xml.registry.postalAddressScheme";
    static final String HTTP_PROXY_HOST = "com.sun.xml.registry.http.proxyHost";
    static final String HTTP_PROXY_PORT = "com.sun.xml.registry.http.proxyPort";
    static final String HTTPS_PROXY_HOST = "com.sun.xml.registry.https.proxyHost";
    static final String HTTPS_PROXY_PORT = "com.sun.xml.registry.https.proxyPort";
    static final String PROXY_USER_NAME = "com.sun.xml.registry.http.proxyUserName";
    static final String PROXY_PASSWORD = "com.sun.xml.registry.http.proxyPassword";
    static final String USE_SOAP = "com.sun.xml.registry.useSOAP";
    static final String USE_CACHE = "com.sun.xml.registry.useCache";
    static final String AUTH_TOKEN_TIMEOUT = "com.sun.xml.registry.authTokenTimeout";
    static final long DEFAULT_TIMEOUT = 15000L;
    public static final String USER_DEF_TAXONOMIES = "com.sun.xml.registry.userTaxonomyFilenames";
    String userDefinedTaxonomy;
    Logger logger = (Logger)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Logger.getLogger("javax.enterprise.resource.webservices.registry.uddi");
        }
    });
    String connectionId;
    char[] authToken;
    private LoginContext lc;
    private Subject subject;
    private String queryManagerURLString;
    private String lifeCycleManagerURLString;
    private String semanticEquivalences;
    private String authenticationMethod;
    private String maxRows;
    private String httpProxyHost;
    private String httpProxyPort;
    private String httpsProxyHost;
    private String httpsProxyPort;
    private String proxyUserName;
    private String proxyPassword;
    private String defaultPostalAddressScheme;
    private boolean useSOAP = false;
    private boolean useCache = true;
    private long timeout;
    private long timestamp;
    private RegistryServiceImpl service;
    private HashMap equivalences;
    private boolean synchronous = true;
    private Locale locale;
    boolean isClosed = false;
    Set privateCredentials;

    ConnectionImpl() {
        this.connectionId = Utility.generateUUID();
    }

    ConnectionImpl(Properties properties) throws JAXRException, InvalidRequestException {
        String timeoutString;
        String useCacheString;
        String useSoapString;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("JAXR implementation version: " + VersionUtil.getJAXRCompleteVersion());
        }
        this.queryManagerURLString = (String)properties.get(QUERY_URL_PROP);
        this.lifeCycleManagerURLString = (String)properties.get(LIFE_CYCLE_URL_PROP);
        if (this.queryManagerURLString == null) {
            throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Missing_connection_property_") + QUERY_URL_PROP);
        }
        if (this.lifeCycleManagerURLString == null) {
            this.logger.finest("making lifeCycleUrl to queryManagerUrl");
            this.lifeCycleManagerURLString = this.queryManagerURLString;
        }
        this.semanticEquivalences = (String)properties.get(SEMANTIC_EQ_PROP);
        this.authenticationMethod = (String)properties.get(AUTH_METHOD_PROP);
        this.logger.finest("authentication method=" + this.authenticationMethod);
        if (this.authenticationMethod != null && !this.authenticationMethod.equals("UDDI_GET_AUTHTOKEN")) {
            throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_only_supports_UDDI_GET_AUTHTOKEN_authentication"));
        }
        this.maxRows = (String)properties.get(MAX_ROWS);
        this.httpProxyHost = (String)properties.get(HTTP_PROXY_HOST);
        this.httpProxyPort = (String)properties.get(HTTP_PROXY_PORT);
        this.httpsProxyHost = (String)properties.get(HTTPS_PROXY_HOST);
        this.httpsProxyPort = (String)properties.get(HTTPS_PROXY_PORT);
        this.proxyUserName = (String)properties.get(PROXY_USER_NAME);
        this.proxyPassword = (String)properties.get(PROXY_PASSWORD);
        if (this.httpProxyHost != null) {
            final String fHttpHost = this.httpProxyHost;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.setProperty("http.proxyHost", fHttpHost);
                    return null;
                }
            });
        }
        if (this.httpProxyPort != null) {
            final String fHttpPort = this.httpProxyPort;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.setProperty("http.proxyPort", fHttpPort);
                    return null;
                }
            });
        }
        if (this.httpsProxyHost != null) {
            final String fHttpsHost = this.httpsProxyHost;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.setProperty("https.proxyHost", fHttpsHost);
                    return null;
                }
            });
        }
        if (this.httpsProxyPort != null) {
            final String fHttpsPort = this.httpsProxyPort;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.setProperty("https.proxyPort", fHttpsPort);
                    return null;
                }
            });
        }
        this.userDefinedTaxonomy = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(ConnectionImpl.USER_DEF_TAXONOMIES);
            }
        });
        String propDefinedTaxonomy = (String)properties.get(USER_DEF_TAXONOMIES);
        if (propDefinedTaxonomy != null && !propDefinedTaxonomy.equals("")) {
            this.userDefinedTaxonomy = propDefinedTaxonomy;
        }
        this.defaultPostalAddressScheme = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(ConnectionImpl.POSTAL_SCHEME_PROP);
            }
        });
        String propPostalAddressScheme = (String)properties.get(POSTAL_SCHEME_PROP);
        if (propPostalAddressScheme != null && !propPostalAddressScheme.equals("")) {
            this.defaultPostalAddressScheme = propPostalAddressScheme;
        }
        if ((useSoapString = (String)properties.get(USE_SOAP)) != null && useSoapString.equalsIgnoreCase("true")) {
            this.useSOAP = true;
        }
        if ((useCacheString = (String)properties.get(USE_CACHE)) != null && useCacheString.equalsIgnoreCase("false")) {
            this.useCache = false;
        }
        this.timeout = (timeoutString = (String)properties.get(AUTH_TOKEN_TIMEOUT)) != null && !timeoutString.equalsIgnoreCase("0") ? new Long(timeoutString) : 15000L;
        this.subject = new Subject();
        this.service = new RegistryServiceImpl(this);
        this.connectionId = Utility.generateUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryService getRegistryService() throws JAXRException {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (!this.isClosed) {
                if (this.service == null) {
                    this.service = new RegistryServiceImpl(this);
                }
            } else {
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_closed"));
            }
            return this.service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JAXRException {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (!this.isClosed) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Closing UDDI connection" + this);
                }
                this.service = null;
                this.isClosed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            return this.isClosed;
        }
    }

    String getQueryManagerURL() throws JAXRException {
        if (!this.isClosed) {
            return this.queryManagerURLString;
        }
        throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_Closed"));
    }

    String getLifeCycleManagerURL() throws JAXRException {
        if (!this.isClosed) {
            return this.lifeCycleManagerURLString;
        }
        throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_closed"));
    }

    HashMap getSemanticEquivalences() {
        if (this.semanticEquivalences == null) {
            return null;
        }
        if (this.equivalences == null) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Parsing semantic equivalences");
            }
            String space = " ";
            String comma = ",";
            String prefix = "urn:";
            String delimiter = "|";
            StringBuffer seBuffer = new StringBuffer();
            this.equivalences = new HashMap();
            this.logger.finest(this.semanticEquivalences);
            StringTokenizer spaceTokenizer = new StringTokenizer(this.semanticEquivalences, space);
            while (spaceTokenizer.hasMoreElements()) {
                seBuffer.append(spaceTokenizer.nextToken());
            }
            this.semanticEquivalences = seBuffer.toString();
            this.logger.finest(this.semanticEquivalences);
            StringTokenizer tokenizer = new StringTokenizer(this.semanticEquivalences, delimiter);
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                String source = token.substring(token.indexOf(prefix) + prefix.length(), token.indexOf(comma));
                String target = token.substring(token.lastIndexOf(prefix) + prefix.length());
                this.logger.finest(source + "->" + target);
                this.equivalences.put(source, target);
            }
        }
        return this.equivalences;
    }

    HashMap fetchEquivalences() {
        return this.equivalences;
    }

    String getDefaultPostalAddressScheme() {
        return this.defaultPostalAddressScheme;
    }

    String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    String getMaxRows() {
        return this.maxRows;
    }

    public boolean isSynchronous() throws JAXRException {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (!this.isClosed) {
                return this.synchronous;
            }
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_Closed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronous(boolean sync) throws JAXRException {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this.isClosed) {
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_closed"));
            }
            this.synchronous = sync;
        }
    }

    Locale getLocale() throws JAXRException {
        if (!this.isClosed) {
            if (this.locale == null) {
                return Locale.getDefault();
            }
            return this.locale;
        }
        throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_closed"));
    }

    void setLocale(Locale locale) throws JAXRException {
        if (this.isClosed) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_closed"));
        }
        this.locale = locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCredentials(Set credentials) throws JAXRException {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.privateCredentials = credentials;
            if (this.isClosed) {
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_closed"));
            }
            this.authToken = this.service.getUDDIMapper().getAuthorizationToken(credentials).toCharArray();
        }
    }

    public Set getCredentials() throws JAXRException {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (!this.isClosed) {
                return this.privateCredentials;
            }
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_closed"));
        }
    }

    String getAuthToken() throws JAXRException {
        if (!this.isClosed) {
            return new String(this.authToken);
        }
        throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_closed"));
    }

    void setAuthToken(char[] token) throws JAXRException {
        if (this.isClosed) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_closed"));
        }
        this.authToken = token;
    }

    void setAuthTokenTimestamp(long stamp) {
        this.timestamp = stamp;
    }

    long getAuthTokenTimestamp() {
        return this.timestamp;
    }

    Set getAuthCreds() throws JAXRException {
        if (!this.isClosed) {
            return this.privateCredentials;
        }
        throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_closed"));
    }

    long getTokenTimeout() {
        if (this.timeout == 0L) {
            return 15000L;
        }
        return this.timeout;
    }

    private LoginContext getLoginContext() throws JAXRException {
        if (this.lc == null) {
            try {
                this.lc = new LoginContext("Prototype", this.subject, new ProtoCallbackHandler(this.service.getUDDIMapper()));
            }
            catch (LoginException lex) {
                throw new JAXRException((Throwable)lex);
            }
        }
        return this.lc;
    }

    void login() throws JAXRException {
        try {
            this.getLoginContext().login();
        }
        catch (LoginException lex) {
            throw new JAXRException((Throwable)lex);
        }
    }

    String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    String getHttpProxyPort() {
        return this.httpProxyPort;
    }

    String getHttpsProxyHost() {
        return this.httpsProxyHost;
    }

    String getHttpsProxyPort() {
        return this.httpsProxyPort;
    }

    String getProxyUserName() {
        return this.proxyUserName;
    }

    String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getUserDefinedTaxonomy() {
        return this.userDefinedTaxonomy;
    }

    boolean useSOAP() {
        return this.useSOAP;
    }

    public boolean useCache() {
        return this.useCache;
    }

    public String getCurrentUser() {
        if (this.privateCredentials != null && !this.privateCredentials.isEmpty()) {
            for (Object credential : this.privateCredentials) {
                if (!(credential instanceof PasswordAuthentication)) continue;
                return ((PasswordAuthentication)credential).getUserName();
            }
        }
        return null;
    }
}

