/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayElement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class ArrayCreation
extends Expression {
    private final Type type;
    private final ArrayList<ArrayElement> elements = new ArrayList();

    private ArrayCreation(int start, int end, ArrayElement[] elements, Type type) {
        super(start, end);
        if (elements == null) {
            throw new IllegalArgumentException();
        }
        this.elements.addAll(Arrays.asList(elements));
        this.type = type;
    }

    public ArrayCreation(int start, int end, List<ArrayElement> elements, Type type) {
        this(start, end, elements == null ? null : elements.toArray(new ArrayElement[0]), type);
    }

    public List<ArrayElement> getElements() {
        return this.elements;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ArrayElement arrayElement : this.getElements()) {
            sb.append(arrayElement).append(",");
        }
        return this.type.toString(sb.toString());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Type {
        OLD{

            @Override
            String toString(String innerElements) {
                return "array(" + innerElements + ")";
            }
        }
        ,
        NEW{

            @Override
            String toString(String innerElements) {
                return "[" + innerElements + "]";
            }
        };


        abstract String toString(String var1);
    }
}

