/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing.renderer;

import org.netbeans.lib.profiler.ui.Formatters;
import org.netbeans.lib.profiler.ui.swing.renderer.FormattedLabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.RelativeRenderer;
import org.netbeans.lib.profiler.utils.StringUtils;

public class McsTimeRenderer
extends FormattedLabelRenderer
implements RelativeRenderer {
    protected boolean renderingDiff;

    public McsTimeRenderer() {
        super(Formatters.millisecondsFormat());
        this.setHorizontalAlignment(11);
    }

    @Override
    public void setDiffMode(boolean diffMode) {
        this.renderingDiff = diffMode;
    }

    @Override
    public boolean isDiffMode() {
        return this.renderingDiff;
    }

    @Override
    public void setValue(Object value, int row) {
        long lvalue = value == null ? 0L : ((Number)value).longValue();
        String s = StringUtils.mcsTimeToString((long)lvalue);
        if (this.renderingDiff && lvalue >= 0L) {
            s = '+' + s;
        }
        super.setValue(s, row);
    }
}

