/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.debugger.jpda.models.ShortenedStrings;
import org.netbeans.modules.debugger.jpda.ui.models.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.RequestProcessor;

class BigStringCustomEditor
extends JPanel
implements ActionListener {
    static final int MAX_STRING_LENGTH;
    private final ShortenedStrings.StringInfo shortenedInfo;
    private final String fullString;

    private BigStringCustomEditor(Component delegateCustomEditor, ShortenedStrings.StringInfo shortenedInfo, int preferredShortLength) {
        this.shortenedInfo = shortenedInfo;
        this.fullString = null;
        int shortLength = preferredShortLength >= 0 ? preferredShortLength : shortenedInfo.getShortLength();
        int fullLength = shortenedInfo.getLength();
        this.init(delegateCustomEditor, shortLength, fullLength);
    }

    private BigStringCustomEditor(Component delegateCustomEditor, String shortString, String fullString) {
        this.shortenedInfo = null;
        this.fullString = fullString;
        this.init(delegateCustomEditor, shortString.length(), fullString.length());
    }

    static BigStringCustomEditor createIfBig(PropertyEditor propertyEditor, String value) {
        ShortenedStrings.StringInfo shortenedInfo = ShortenedStrings.getShortenedInfo((String)value);
        if (shortenedInfo != null) {
            if (shortenedInfo.getShortLength() <= MAX_STRING_LENGTH) {
                return new BigStringCustomEditor(propertyEditor.getCustomEditor(), shortenedInfo, -1);
            }
            String shortText = value.substring(0, MAX_STRING_LENGTH) + "...";
            propertyEditor.setValue(shortText);
            return new BigStringCustomEditor(propertyEditor.getCustomEditor(), shortenedInfo, shortText.length() - 3);
        }
        if (value.length() > MAX_STRING_LENGTH) {
            String shortText = value.substring(0, MAX_STRING_LENGTH) + "...";
            propertyEditor.setValue(shortText);
            return new BigStringCustomEditor(propertyEditor.getCustomEditor(), shortText, value);
        }
        return null;
    }

    private void init(Component contentComponent, int shortLength, int fullLength) {
        this.setLayout(new BorderLayout());
        this.add(contentComponent, "Center");
        this.add((Component)this.createSavePanel(shortLength, fullLength), "South");
    }

    private JPanel createSavePanel(int shortLength, int fullLength) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 5));
        panel.add((Component)new JLabel(Bundle.MSG_TooLargeString(shortLength, fullLength)), "Before");
        panel.add((Component)this.createSaveButton(), "After");
        panel.setBorder(new EmptyBorder(10, 12, 0, 11));
        return panel;
    }

    private JButton createSaveButton() {
        JButton button = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)button, (String)Bundle.BTN_SaveValueToFile());
        button.addActionListener(this);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileChooserBuilder fchb = new FileChooserBuilder(BigStringCustomEditor.class);
        fchb.setTitle(Bundle.DLG_SaveToFile());
        final File f = fchb.showSaveDialog();
        if (f != null) {
            new RequestProcessor(BigStringCustomEditor.class).post(new Runnable(){
                final /* synthetic */ BigStringCustomEditor this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.save(f);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(File f) {
        Reader r = this.shortenedInfo != null ? this.shortenedInfo.getContent() : new StringReader(this.fullString);
        FileWriter w = null;
        try {
            int len;
            w = new FileWriter(f);
            char[] BUFFER = new char[65536];
            while ((len = r.read(BUFFER)) > 0) {
                ((Writer)w).write(BUFFER, 0, len);
            }
        }
        catch (IOException ioex) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ioex.getLocalizedMessage(), 2);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
        }
        finally {
            if (w != null) {
                try {
                    ((Writer)w).close();
                }
                catch (IOException iOException) {}
            }
            try {
                r.close();
            }
            catch (IOException iOException) {}
        }
    }

    static {
        int maxStringLength = 100000;
        String javaV = System.getProperty("java.version");
        if (javaV.startsWith("1.8.0")) {
            char c;
            String update = "";
            for (int i = "1.8.0_".length(); i < javaV.length() && Character.isDigit(c = javaV.charAt(i)); ++i) {
                update = update + c;
            }
            int updateNo = 0;
            if (!update.isEmpty()) {
                try {
                    updateNo = Integer.parseInt(update);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (updateNo < 60) {
                maxStringLength = 1000;
            }
        }
        MAX_STRING_LENGTH = maxStringLength;
    }
}

