/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTreeModelFilter;
import org.netbeans.modules.debugger.jpda.ui.models.WatchesNodeModelFilter;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.datatransfer.PasteType;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class FixedWatchesManager
implements TreeModelFilter,
NodeActionsProviderFilter,
ExtendedNodeModelFilter,
TableModelFilter {
    public static final String FIXED_WATCH = "org/netbeans/modules/debugger/resources/watchesView/watch_type3_16.png";
    private final Action DELETE_ACTION = Models.createAction((String)NbBundle.getMessage(FixedWatchesManager.class, (String)"CTL_DeleteFixedWatch_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return !WatchesNodeModelFilter.isEmptyWatch(node);
        }

        public void perform(Object[] nodes) {
            int k = nodes.length;
            for (int i = 0; i < k; ++i) {
                FixedWatchesManager.this.fixedWatches.remove(new KeyWrapper(nodes[i]));
            }
            FixedWatchesManager.this.fireModelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)FixedWatchesManager.this, (Object)"Root", 8));
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action CREATE_FIXED_WATCH_ACTION;
    private Map fixedWatches;
    private HashSet listeners;
    private ContextProvider contextProvider;

    public FixedWatchesManager(ContextProvider contextProvider) {
        this.DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        this.CREATE_FIXED_WATCH_ACTION = Models.createAction((String)NbBundle.getMessage(FixedWatchesManager.class, (String)"CTL_CreateFixedWatch_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return !WatchesNodeModelFilter.isEmptyWatch(node) && !this.isPrimitive(node);
            }

            public void perform(Object[] nodes) {
                int k = nodes.length;
                for (int i = 0; i < k; ++i) {
                    FixedWatchesManager.this.createFixedWatch(nodes[i]);
                }
            }

            private boolean isPrimitive(Object node) {
                if (!(node instanceof Variable)) {
                    return false;
                }
                Variable v = (Variable)node;
                if (!VariablesTreeModelFilter.isEvaluated(v)) {
                    return false;
                }
                String type = v.getType();
                return "".equals(type) || "boolean".equals(type) || "byte".equals(type) || "char".equals(type) || "short".equals(type) || "int".equals(type) || "long".equals(type) || "float".equals(type) || "double".equals(type);
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
        this.fixedWatches = new LinkedHashMap();
        this.contextProvider = contextProvider;
    }

    public void deleteAllFixedWatches() {
        ArrayList nodes = new ArrayList(this.fixedWatches.keySet());
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            this.fixedWatches.remove(iter.next());
            this.fireModelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)"Root", 8));
        }
    }

    public Object getRoot(TreeModel original) {
        return original.getRoot();
    }

    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            if (this.fixedWatches.isEmpty()) {
                return original.getChildren(parent, from, to);
            }
            int fixedSize = this.fixedWatches.size();
            int originalFrom = from - fixedSize;
            int originalTo = to - fixedSize;
            if (originalFrom < 0) {
                originalFrom = 0;
            }
            Object[] children = originalTo > originalFrom ? original.getChildren(parent, originalFrom, originalTo) : new Object[]{};
            Object[] allChildren = new Object[children.length + fixedSize];
            int index = 0;
            for (Object wrapper : this.fixedWatches.keySet()) {
                allChildren[index++] = ((KeyWrapper)wrapper).value;
            }
            System.arraycopy(children, 0, allChildren, fixedSize, children.length);
            if (from > 0 || to < allChildren.length) {
                if (to > allChildren.length) {
                    to = allChildren.length;
                }
                Object[] fallChildren = new Object[to - from];
                System.arraycopy(allChildren, from, fallChildren, 0, to - from);
                return fallChildren;
            }
            return allChildren;
        }
        return original.getChildren(parent, from, to);
    }

    public int getChildrenCount(TreeModel original, Object parent) throws UnknownTypeException {
        if (parent == "Root") {
            int chc = original.getChildrenCount(parent);
            if (chc < Integer.MAX_VALUE) {
                chc += this.fixedWatches.size();
            }
            return chc;
        }
        return original.getChildrenCount(parent);
    }

    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        return original.isLeaf(node);
    }

    public synchronized void addModelListener(ModelListener l) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(l);
    }

    public synchronized void removeModelListener(ModelListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (this.fixedWatches.containsKey(new KeyWrapper(node))) {
            return;
        }
        original.performDefaultAction(node);
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        Action[] actions = original.getActions(node);
        ArrayList<Action> myActions = new ArrayList<Action>();
        if (this.fixedWatches.containsKey(new KeyWrapper(node))) {
            KeyStroke deleteKey = KeyStroke.getKeyStroke("DELETE");
            int deleteIndex = -1;
            int editIndex = -1;
            for (int i = 0; i < actions.length; ++i) {
                if (actions[i] == null) continue;
                if (deleteKey.equals(actions[i].getValue("AcceleratorKey"))) {
                    deleteIndex = i;
                }
                if (!Boolean.TRUE.equals(actions[i].getValue("edit"))) continue;
                editIndex = i;
            }
            if (deleteIndex >= 0) {
                actions = Arrays.copyOf(actions, actions.length);
                if (deleteIndex >= 0) {
                    actions[deleteIndex] = this.DELETE_ACTION;
                }
            } else {
                myActions.add(0, this.DELETE_ACTION);
            }
            if (editIndex >= 0) {
                if (editIndex == actions.length - 1) {
                    actions = Arrays.copyOf(actions, actions.length - 1);
                } else {
                    Action[] actions2 = new Action[actions.length - 1];
                    System.arraycopy(actions, 0, actions2, 0, editIndex);
                    System.arraycopy(actions, editIndex + 1, actions2, editIndex, actions2.length - editIndex);
                    actions = actions2;
                }
            }
        } else if (node instanceof Variable) {
            myActions.add(this.CREATE_FIXED_WATCH_ACTION);
        } else if (node instanceof JPDAWatch) {
            myActions.add(this.CREATE_FIXED_WATCH_ACTION);
        } else {
            return actions;
        }
        myActions.addAll(Arrays.asList(actions));
        return myActions.toArray(new Action[0]);
    }

    public String getDisplayName(NodeModel original, Object node) throws UnknownTypeException {
        KeyWrapper wrapper = new KeyWrapper(node);
        if (this.fixedWatches.containsKey(wrapper)) {
            return (String)this.fixedWatches.get(wrapper);
        }
        return original.getDisplayName(node);
    }

    public String getShortDescription(NodeModel original, Object node) throws UnknownTypeException {
        return original.getShortDescription(node);
    }

    public String getIconBase(NodeModel original, Object node) throws UnknownTypeException {
        return original.getIconBase(node);
    }

    private void createFixedWatch(Object node) {
        if (node instanceof JPDAWatch) {
            JPDAWatch jw = (JPDAWatch)node;
            this.addFixedWatch(jw.getExpression(), (Variable)jw);
        } else {
            Variable variable = (Variable)node;
            String name = variable instanceof LocalVariable ? ((LocalVariable)variable).getName() : (variable instanceof Field ? ((Field)variable).getName() : (variable instanceof This ? "this" : (variable instanceof ObjectVariable ? "object" : "unnamed")));
            this.addFixedWatch(name, variable);
        }
    }

    public void addFixedWatch(String name, Variable variable) {
        if (variable instanceof Cloneable) {
            try {
                Method cloneMethod = variable.getClass().getMethod("clone", new Class[0]);
                cloneMethod.setAccessible(true);
                Object newVar = cloneMethod.invoke((Object)variable, new Object[0]);
                if (newVar instanceof Variable) {
                    variable = (Variable)newVar;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fixedWatches.put(new KeyWrapper(variable), name);
        this.fireModelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)"Root", 8));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Mode mw;
                TopComponent watchesView = WindowManager.getDefault().findTopComponent("watchesView");
                if (watchesView != null && watchesView.isOpened() && (mw = WindowManager.getDefault().findMode(watchesView)) != null && mw.getSelectedTopComponent() == watchesView) {
                    return;
                }
                Preferences preferences = NbPreferences.forModule(ContextProvider.class).node("variables_view");
                String viewName = preferences.getBoolean("show_watches", true) ? "localsView" : "watchesView";
                TopComponent view = WindowManager.getDefault().findTopComponent(viewName);
                if (view != null) {
                    view.open();
                    view.requestVisible();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChanged(ModelEvent event) {
        HashSet listenersCopy;
        FixedWatchesManager fixedWatchesManager = this;
        synchronized (fixedWatchesManager) {
            if (this.listeners == null) {
                return;
            }
            listenersCopy = new HashSet(this.listeners);
        }
        for (ModelListener listener : listenersCopy) {
            listener.modelChanged(event);
        }
    }

    public boolean canRename(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        if (this.fixedWatches.containsKey(new KeyWrapper(node))) {
            return false;
        }
        return original.canRename(node);
    }

    public boolean canCopy(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canCopy(node);
    }

    public boolean canCut(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canCut(node);
    }

    public Transferable clipboardCopy(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        return original.clipboardCopy(node);
    }

    public Transferable clipboardCut(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        return original.clipboardCut(node);
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel original, Object node, Transferable t) throws UnknownTypeException {
        return original.getPasteTypes(node, t);
    }

    public void setName(ExtendedNodeModel original, Object node, String name) throws UnknownTypeException {
        original.setName(node, name);
    }

    public String getIconBaseWithExtension(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        if (this.fixedWatches.containsKey(new KeyWrapper(node))) {
            return FIXED_WATCH;
        }
        return original.getIconBaseWithExtension(node);
    }

    public Object getValueAt(TableModel original, Object node, String columnID) throws UnknownTypeException {
        return original.getValueAt(node, columnID);
    }

    public boolean isReadOnly(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if (this.fixedWatches.containsKey(new KeyWrapper(node))) {
            return true;
        }
        return original.isReadOnly(node, columnID);
    }

    public void setValueAt(TableModel original, Object node, String columnID, Object value) throws UnknownTypeException {
        original.setValueAt(node, columnID, value);
    }

    private static class KeyWrapper {
        private Object value;

        KeyWrapper(Object value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof KeyWrapper)) {
                return false;
            }
            return this.value == ((KeyWrapper)obj).value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

