/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.util.Arrays;
import mediathek.tool.GuiFunktionenProgramme;
import org.jetbrains.annotations.NotNull;

public class DatenProg
implements Comparable<DatenProg> {
    public static final int PROGRAMM_NAME = 0;
    public static final int PROGRAMM_ZIEL_DATEINAME = 1;
    public static final int PROGRAMM_PROGRAMMPFAD = 2;
    public static final int PROGRAMM_SCHALTER = 3;
    public static final int PROGRAMM_PRAEFIX = 4;
    public static final int PROGRAMM_SUFFIX = 5;
    public static final int PROGRAMM_RESTART = 6;
    public static final int PROGRAMM_DOWNLOADMANAGER = 7;
    public static final int MAX_ELEM = 8;
    public static final String TAG = "Programm";
    public static final String[] COLUMN_NAMES = new String[]{"Beschreibung", "Zieldateiname", "Programm", "Schalter", "Pr\u00e4fix", "Suffix", "Restart", "Downloadmanager"};
    public static final String[] XML_NAMES = new String[]{"Programmname", "Zieldateiname", "Programmpfad", "Programmschalter", "Praefix", "Suffix", "Restart", "Downloadmanager"};
    public String[] arr;

    public DatenProg() {
        this.initialize();
        this.arr[6] = Boolean.toString(false);
        this.arr[7] = Boolean.toString(false);
    }

    public DatenProg(String name, String programmpfad, String schalter, String restart, String downloadmanager) {
        this.initialize();
        this.arr[0] = name;
        this.arr[2] = programmpfad;
        this.arr[3] = schalter;
        this.arr[6] = restart.equals("") ? Boolean.toString(false) : restart;
        this.arr[7] = downloadmanager.equals("") ? Boolean.toString(false) : downloadmanager;
    }

    public DatenProg copy() {
        DatenProg ret = new DatenProg();
        System.arraycopy(this.arr, 0, ret.arr, 0, this.arr.length);
        return ret;
    }

    public boolean isRestart() {
        if (this.arr[6].equals("")) {
            return false;
        }
        return Boolean.parseBoolean(this.arr[6]);
    }

    public boolean isDownloadManager() {
        if (this.arr[7].equals("")) {
            return false;
        }
        return Boolean.parseBoolean(this.arr[7]);
    }

    public boolean urlTesten(String url) {
        boolean ret = false;
        if (url != null && GuiFunktionenProgramme.praefixTesten(this.arr[4], url, true) && GuiFunktionenProgramme.praefixTesten(this.arr[5], url, false)) {
            ret = true;
        }
        return ret;
    }

    public String getProgrammAufruf() {
        return this.arr[2] + " " + this.arr[3];
    }

    public String getProgrammAufrufArray() {
        String[] ar;
        Object ret = this.arr[2];
        for (String s2 : ar = this.arr[3].split(" ")) {
            ret = (String)ret + "<>" + s2;
        }
        return ret;
    }

    public static String makeProgAufrufArray(String pArray) {
        String[] progArray = pArray.split("<>");
        Object execStr = "";
        for (String s2 : progArray) {
            execStr = (String)execStr + s2 + " ";
        }
        execStr = ((String)execStr).trim();
        return execStr;
    }

    public String toString() {
        Object ret = "";
        for (int i = 0; i < 8; ++i) {
            ret = i == 0 ? (String)ret + "| ***|" + COLUMN_NAMES[i] + ": " + this.arr[i] + System.lineSeparator() : (String)ret + "|    |" + COLUMN_NAMES[i] + ": " + this.arr[i] + System.lineSeparator();
        }
        return ret;
    }

    private void initialize() {
        this.arr = new String[8];
        Arrays.fill(this.arr, "");
    }

    @Override
    public int compareTo(@NotNull DatenProg o) {
        return 0;
    }
}

