/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import io.quarkus.bootstrap.runner.QuarkusEntryPoint;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.runtime.LaunchMode;
import io.smallrye.config.ConfigValue;
import io.smallrye.mutiny.tuples.Functions;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.keycloak.common.profile.ProfileException;
import org.keycloak.config.DeprecatedMetadata;
import org.keycloak.config.Option;
import org.keycloak.config.OptionCategory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.KeycloakMain;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.ExecutionExceptionHandler;
import org.keycloak.quarkus.runtime.cli.Help;
import org.keycloak.quarkus.runtime.cli.HelpFactory;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.ShortErrorMessageHandler;
import org.keycloak.quarkus.runtime.cli.SubCommandListRenderer;
import org.keycloak.quarkus.runtime.cli.command.AbstractAutoBuildCommand;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.cli.command.AbstractNonServerCommand;
import org.keycloak.quarkus.runtime.cli.command.Build;
import org.keycloak.quarkus.runtime.cli.command.Main;
import org.keycloak.quarkus.runtime.cli.command.ShowConfig;
import org.keycloak.quarkus.runtime.configuration.ConfigArgsConfigSource;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.DisabledMappersInterceptor;
import org.keycloak.quarkus.runtime.configuration.KcUnmatchedArgumentException;
import org.keycloak.quarkus.runtime.configuration.PropertyMappingInterceptor;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import picocli.CommandLine;

public class Picocli {
    static final String PROVIDER_TIMESTAMP_ERROR = "A provider JAR was updated since the last build, please rebuild for this to be fully utilized.";
    static final String PROVIDER_TIMESTAMP_WARNING = "A provider jar has a different timestamp than when the optimized container image was created. If you are changing provider jars after the build, you must run another build to properly account for those modifications.";
    static final String KC_PROVIDER_FILE_PREFIX = "kc.provider.file.";
    public static final String ARG_PREFIX = "--";
    public static final String ARG_SHORT_PREFIX = "-";
    public static final String NO_PARAM_LABEL = "none";
    private final ExecutionExceptionHandler errorHandler = new ExecutionExceptionHandler();
    private Optional<AbstractCommand> parsedCommand = Optional.empty();
    private boolean warnedTimestampChanged;
    private CommandLine.Help.Ansi colorMode = Picocli.hasColorSupport() ? CommandLine.Help.Ansi.ON : CommandLine.Help.Ansi.OFF;
    private IncludeOptions options;

    public static boolean hasColorSupport() {
        return QuarkusConsole.hasColorSupport();
    }

    public CommandLine.Help.Ansi getColorMode() {
        return this.colorMode;
    }

    private boolean isHelpRequested(CommandLine.ParseResult result) {
        if (result.isUsageHelpRequested()) {
            return true;
        }
        return result.subcommands().stream().anyMatch(this::isHelpRequested);
    }

    public void parseAndRun(List<String> cliArgs) {
        ArrayList<String> unrecognizedArgs = new ArrayList<String>();
        CommandLine cmd = this.createCommandLine(unrecognizedArgs);
        String[] argArray = cliArgs.toArray(new String[0]);
        try {
            AbstractCommand ac;
            CommandLine.ParseResult result = cmd.parseArgs(argArray);
            List commandLineList = result.asCommandLineList();
            CommandLine cl = (CommandLine)commandLineList.get(commandLineList.size() - 1);
            Object object = cl.getCommand();
            AbstractCommand currentCommand = object instanceof AbstractCommand ? (ac = (AbstractCommand)object) : null;
            this.initConfig(currentCommand);
            if (!unrecognizedArgs.isEmpty() && this.options.allowUnrecognized) {
                unrecognizedArgs.removeIf(arg -> {
                    PropertyMapper<?> mapper;
                    boolean hasArg = false;
                    if (arg.contains("=")) {
                        arg = arg.substring(0, arg.indexOf("="));
                        hasArg = true;
                    }
                    if ((mapper = PropertyMappers.getMapperByCliKey(arg)) != null) {
                        if (!hasArg) {
                            this.addCommandOptions(cl, currentCommand);
                            throw new CommandLine.MissingParameterException(cl, (CommandLine.Model.ArgSpec)cl.getCommandSpec().optionsMap().get(arg), null);
                        }
                        return true;
                    }
                    return false;
                });
            }
            if (!unrecognizedArgs.isEmpty()) {
                this.addCommandOptions(cl, currentCommand);
                throw new KcUnmatchedArgumentException(cl, unrecognizedArgs);
            }
            if (this.isHelpRequested(result)) {
                this.addCommandOptions(cl, currentCommand);
            }
            result = null;
            int exitCode = cmd.execute(argArray);
            this.exit(exitCode);
        }
        catch (CommandLine.ParameterException parEx) {
            this.catchParameterException(parEx, cmd, argArray);
        }
        catch (ProfileException | PropertyException proEx) {
            this.usageException(proEx.getMessage(), proEx.getCause());
        }
    }

    public Optional<AbstractCommand> getParsedCommand() {
        return this.parsedCommand;
    }

    private void catchParameterException(CommandLine.ParameterException parEx, CommandLine cmd, String[] args) {
        int exitCode;
        try {
            exitCode = cmd.getParameterExceptionHandler().handleParseException(parEx, args);
        }
        catch (Exception e) {
            this.errorHandler.error(cmd.getErr(), e.getMessage(), null);
            exitCode = parEx.getCommandLine().getCommandSpec().exitCodeOnInvalidInput();
        }
        this.exit(exitCode);
    }

    public void usageException(String message, Throwable cause) {
        this.errorHandler.error(this.getErrWriter(), message, cause);
        this.exit(2);
    }

    public void exit(int exitCode) {
        System.exit(exitCode);
    }

    private static boolean wasBuildEverRun() {
        return !Configuration.getRawPersistedProperties().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateConfig() {
        AbstractCommand abstractCommand = this.getParsedCommand().orElseThrow();
        if (abstractCommand.isOptimized() && !Picocli.wasBuildEverRun()) {
            throw new PropertyException(Messages.optimizedUsedForFirstStartup());
        }
        this.warnOnDuplicatedOptionsInCli();
        if (!this.options.includeBuildTime && !this.options.includeRuntime) {
            return;
        }
        if (!this.options.includeBuildTime) {
            this.validateBuildtime();
        }
        boolean disabledMappersInterceptorEnabled = DisabledMappersInterceptor.isEnabled();
        try {
            DisabledMappersInterceptor.disable();
            ArrayList<String> ignoredRunTime = new ArrayList<String>();
            LinkedHashSet<String> disabledBuildTime = new LinkedHashSet<String>();
            LinkedHashSet<String> disabledRunTime = new LinkedHashSet<String>();
            LinkedHashSet<String> deprecatedInUse = new LinkedHashSet<String>();
            LinkedHashSet<String> missingOption = new LinkedHashSet<String>();
            LinkedHashSet ambiguousSpi = new LinkedHashSet();
            LinkedHashSet<String> unnecessary = new LinkedHashSet<String>();
            LinkedHashMap<String, String> secondClassOptions = new LinkedHashMap<String, String>();
            HashSet disabledMappers = new HashSet();
            if (this.options.includeBuildTime) {
                disabledMappers.addAll(PropertyMappers.getDisabledBuildTimeMappers().values());
            }
            if (this.options.includeRuntime) {
                disabledMappers.addAll(PropertyMappers.getDisabledRuntimeMappers().values());
            }
            Configuration.getPropertyNames().forEach(name -> {
                ConfigValue value;
                PropertyMapper<?> mapper;
                if (!name.startsWith("kc.")) {
                    return;
                }
                if (!this.options.includeRuntime) {
                    Picocli.checkRuntimeSpiOptions(name, ignoredRunTime);
                }
                if (PropertyMappers.isMaybeSpiBuildTimeProperty(name)) {
                    ambiguousSpi.add(name);
                }
                if ((mapper = PropertyMappers.getMapper(name)) == null) {
                    return;
                }
                PropertyMapper<?> forKey = mapper.forKey((String)name);
                if (!name.equals(forKey.getFrom()) && (value = this.getUnmappedValue((String)name)).getValue() != null && Configuration.isUserModifiable(value)) {
                    secondClassOptions.put((String)name, forKey.getFrom());
                }
                if (!mapper.hasWildcard()) {
                    return;
                }
                this.validateProperty(abstractCommand, this.options, ignoredRunTime, disabledBuildTime, disabledRunTime, deprecatedInUse, missingOption, disabledMappers.contains(mapper), forKey, unnecessary);
            });
            for (PropertyMapper<Object> mapper : PropertyMappers.getMappers()) {
                if (mapper.hasWildcard()) continue;
                this.validateProperty(abstractCommand, this.options, ignoredRunTime, disabledBuildTime, disabledRunTime, deprecatedInUse, missingOption, disabledMappers.contains(mapper), mapper, unnecessary);
            }
            PropertyMappers.getPropertyMapperGroupings().forEach(g -> g.validateConfig(this));
            for (PropertyMapper<Object> mapper : disabledMappers) {
                if (mapper.hasWildcard()) continue;
                this.validateProperty(abstractCommand, this.options, ignoredRunTime, disabledBuildTime, disabledRunTime, deprecatedInUse, missingOption, disabledMappers.contains(mapper), mapper, unnecessary);
            }
            if (!missingOption.isEmpty()) {
                throw new PropertyException("The following options are required: \n%s".formatted(String.join((CharSequence)"\n", missingOption)));
            }
            if (!ignoredRunTime.isEmpty()) {
                this.info(String.format("The following run time options were found, but will be ignored during build time: %s\n", String.join((CharSequence)", ", ignoredRunTime)));
            }
            if (!disabledBuildTime.isEmpty()) {
                this.outputDisabledProperties(disabledBuildTime, true);
            } else if (!disabledRunTime.isEmpty()) {
                this.outputDisabledProperties(disabledRunTime, false);
            }
            if (!deprecatedInUse.isEmpty()) {
                this.warn("The following used options or option values are DEPRECATED and will be removed or their behaviour changed in a future release:\n" + String.join((CharSequence)"\n", deprecatedInUse) + "\nConsult the Release Notes for details.");
            }
            if (!ambiguousSpi.isEmpty()) {
                this.warn("The following SPI options are using the legacy format and are not being treated as build time options. Please use the new format with the appropriate -- separators to resolve this ambiguity: " + String.join((CharSequence)"\n", ambiguousSpi));
            }
            secondClassOptions.forEach((key, firstClass) -> this.warn("Please use the first-class option `%s` instead of `%s`".formatted(firstClass, key)));
            if (!unnecessary.isEmpty()) {
                this.info("The following options were specified, but are typically not relevant for this command: " + String.join((CharSequence)"\n", unnecessary));
            }
        }
        finally {
            DisabledMappersInterceptor.enable(disabledMappersInterceptorEnabled);
        }
    }

    private void validateBuildtime() {
        ArrayList ignoredBuildTime = new ArrayList();
        Picocli.checkChangesInBuildOptions((Functions.TriConsumer<String, String, String>)((Functions.TriConsumer)(key, oldValue, newValue) -> {
            if (key.startsWith(KC_PROVIDER_FILE_PREFIX)) {
                boolean changed = false;
                if (newValue == null || oldValue == null) {
                    changed = true;
                } else if (!this.warnedTimestampChanged && Picocli.timestampChanged(oldValue, newValue)) {
                    if (Configuration.getOptionalBooleanKcValue("run-in-container").orElse(false).booleanValue()) {
                        this.warnedTimestampChanged = true;
                        this.warn(PROVIDER_TIMESTAMP_WARNING);
                    } else {
                        changed = true;
                    }
                }
                if (changed) {
                    throw new PropertyException(PROVIDER_TIMESTAMP_ERROR);
                }
            } else if (newValue != null && !Picocli.isIgnoredPersistedOption(key) && Configuration.isUserModifiable(Configuration.getConfigValue(key)) && !key.startsWith("quarkus.")) {
                ignoredBuildTime.add(key);
            }
        }));
        if (!ignoredBuildTime.isEmpty()) {
            throw new PropertyException(String.format("The following build time options have values that differ from what is persisted - the new values will NOT be used until another build is run: %s\n", String.join((CharSequence)", ", ignoredBuildTime)));
        }
    }

    static boolean timestampChanged(String oldValue, String newValue) {
        long longNewValue = Long.valueOf(newValue);
        long longOldValue = Long.valueOf(oldValue);
        return longNewValue / 1000L * 1000L != longNewValue || longOldValue / 1000L * 1000L != longNewValue;
    }

    private ConfigValue getUnmappedValue(String key) {
        PropertyMappingInterceptor.disable();
        try {
            ConfigValue configValue = Configuration.getConfigValue(key);
            return configValue;
        }
        finally {
            PropertyMappingInterceptor.enable();
        }
    }

    private void validateProperty(AbstractCommand abstractCommand, IncludeOptions options, List<String> ignoredRunTime, Set<String> disabledBuildTime, Set<String> disabledRunTime, Set<String> deprecatedInUse, Set<String> missingOption, boolean disabled, PropertyMapper<?> mapper, Set<String> unnecessary) {
        if (mapper.isBuildTime() && !options.includeBuildTime) {
            return;
        }
        ConfigValue configValue = this.getUnmappedValue(mapper.getFrom());
        String configValueStr = configValue.getValue();
        if (configValueStr == null) {
            if (mapper.isRequired()) {
                Picocli.handleRequired(missingOption, mapper);
            }
            return;
        }
        if (!Configuration.isUserModifiable(configValue)) {
            return;
        }
        if (disabled) {
            if (PropertyMappers.getMapper(mapper.getFrom()) == null && !PropertyMapper.isCliOption(configValue)) {
                Picocli.handleDisabled(mapper.isRunTime() ? disabledRunTime : disabledBuildTime, mapper);
            }
            return;
        }
        if (mapper.isRunTime() && !options.includeRuntime) {
            ignoredRunTime.add(mapper.getFrom());
            return;
        }
        mapper.validate(configValue);
        mapper.getDeprecatedMetadata().ifPresent(metadata -> Picocli.handleDeprecated(deprecatedInUse, mapper, configValueStr, metadata));
        if (mapper.isRunTime() && PropertyMapper.isCliOption(configValue) && abstractCommand.isHiddenCategory(mapper.getCategory())) {
            unnecessary.add(mapper.getCliFormat());
        }
    }

    private static void checkRuntimeSpiOptions(String key, List<String> ignoredRunTime) {
        ConfigValue configValue;
        String configValueStr;
        if (!key.startsWith("kc.spi")) {
            return;
        }
        boolean buildTimeOption = PropertyMappers.isSpiBuildTimeProperty(key);
        if (!buildTimeOption && (configValueStr = (configValue = Configuration.getConfigValue(key)).getValue()) != null && Configuration.isUserModifiable(configValue)) {
            ignoredRunTime.add(key);
        }
    }

    private static void handleDeprecated(Set<String> deprecatedInUse, PropertyMapper<?> mapper, String configValue, DeprecatedMetadata metadata) {
        String optionName;
        HashSet<String> deprecatedValuesInUse = new HashSet<String>();
        if (!metadata.getDeprecatedValues().isEmpty()) {
            deprecatedValuesInUse.addAll(Arrays.asList(configValue.split(",")));
            deprecatedValuesInUse.retainAll(metadata.getDeprecatedValues());
            if (deprecatedValuesInUse.isEmpty()) {
                return;
            }
        }
        if ((optionName = mapper.getFrom()).startsWith("kc.")) {
            optionName = optionName.substring("kc.".length());
        }
        StringBuilder sb = new StringBuilder("\t- ");
        sb.append(optionName);
        if (!deprecatedValuesInUse.isEmpty()) {
            sb.append("=").append(String.join((CharSequence)",", deprecatedValuesInUse));
        }
        if (metadata.getNote() != null || !metadata.getNewOptionsKeys().isEmpty()) {
            sb.append(":");
        }
        if (metadata.getNote() != null) {
            sb.append(" ");
            sb.append(metadata.getNote());
            if (!metadata.getNote().endsWith(".")) {
                sb.append(".");
            }
        }
        if (!metadata.getNewOptionsKeys().isEmpty()) {
            sb.append(" Use ");
            sb.append(String.join((CharSequence)", ", metadata.getNewOptionsKeys()));
            sb.append(".");
        }
        deprecatedInUse.add(sb.toString());
    }

    private static void handleDisabled(Set<String> disabledInUse, PropertyMapper<?> mapper) {
        Picocli.handleMessage(disabledInUse, mapper, PropertyMapper::getEnabledWhen);
    }

    private static void handleRequired(Set<String> requiredOptions, PropertyMapper<?> mapper) {
        Picocli.handleMessage(requiredOptions, mapper, PropertyMapper::getRequiredWhen);
    }

    private static void handleMessage(Set<String> messages, PropertyMapper<?> mapper, Function<PropertyMapper<?>, Optional<String>> retrieveMessage) {
        String optionName = mapper.getOption().getKey();
        StringBuilder sb = new StringBuilder("\t- ");
        sb.append(optionName);
        retrieveMessage.apply(mapper).ifPresent(msg -> sb.append(": ").append((String)msg).append("."));
        messages.add(sb.toString());
    }

    public void info(String text) {
        CommandLine.Help.ColorScheme defaultColorScheme = CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)this.colorMode);
        this.getOutWriter().println(String.valueOf(defaultColorScheme.apply("INFO: ", Arrays.asList(CommandLine.Help.Ansi.Style.fg_green, CommandLine.Help.Ansi.Style.bold))) + text);
    }

    public void error(String text) {
        CommandLine.Help.ColorScheme defaultColorScheme = CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)this.colorMode);
        this.getErrWriter().println(defaultColorScheme.apply(text, Arrays.asList(CommandLine.Help.Ansi.Style.fg_red, CommandLine.Help.Ansi.Style.bold)));
    }

    public void warn(String text) {
        CommandLine.Help.ColorScheme defaultColorScheme = CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)this.colorMode);
        this.getOutWriter().println(String.valueOf(defaultColorScheme.apply("WARNING: ", Arrays.asList(CommandLine.Help.Ansi.Style.fg_yellow, CommandLine.Help.Ansi.Style.bold))) + text);
    }

    private void outputDisabledProperties(Set<String> properties, boolean build) {
        this.warn(String.format("The following used %s time options are UNAVAILABLE and will be ignored during %s time:\n %s", build ? "build" : "run", build ? "run" : "build", String.join((CharSequence)"\n", properties)));
    }

    public static Properties getNonPersistedBuildTimeOptions() {
        String profile;
        Properties properties = new Properties();
        Configuration.getPropertyNames().forEach(name -> {
            ConfigValue value;
            boolean quarkus = false;
            PropertyMapper<?> mapper = PropertyMappers.getMapper(name);
            if (mapper != null) {
                if (!mapper.isBuildTime()) {
                    return;
                }
                if (properties.containsKey(name = mapper.forKey((String)name).getFrom())) {
                    return;
                }
            } else if (name.startsWith("quarkus")) {
                quarkus = true;
            } else if (!PropertyMappers.isSpiBuildTimeProperty(name)) {
                return;
            }
            if ((value = Configuration.getNonPersistedConfigValue(name)).getValue() == null || value.getConfigSourceName() == null || quarkus && !value.getConfigSourceName().contains("KcQuarkusPropertiesConfigSource")) {
                return;
            }
            String stringValue = value.getValue();
            if (quarkus && value.getRawValue() != null) {
                stringValue = value.getRawValue();
            }
            properties.put(name, stringValue);
        });
        for (File jar : Environment.getProviderFiles().values()) {
            properties.put(String.format("kc.provider.file.%s.last-modified", jar.getName()), String.valueOf(jar.lastModified()));
        }
        if (!Environment.isRebuildCheck()) {
            Configuration.markAsOptimized(properties);
        }
        if ((profile = org.keycloak.common.util.Environment.getProfile()) != null) {
            properties.put("kc.profile", profile);
            properties.put(LaunchMode.current().getProfileKey(), profile);
        }
        return properties;
    }

    private void updateSpecHelpAndUnmatched(CommandLine.Model.CommandSpec spec, final List<String> unrecognizedArgs) {
        try {
            spec.addOption(((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String[])Help.OPTION_NAMES).usageHelp(true).description(new String[]{"This help message."})).build());
        }
        catch (CommandLine.DuplicateOptionAnnotationsException duplicateOptionAnnotationsException) {
            // empty catch block
        }
        spec.addUnmatchedArgsBinding(CommandLine.Model.UnmatchedArgsBinding.forStringArrayConsumer((CommandLine.Model.ISetter)new CommandLine.Model.ISetter(){

            public <T> T set(T value) {
                if (value != null) {
                    unrecognizedArgs.addAll(Arrays.asList((String[])value));
                }
                return null;
            }
        }));
        spec.subcommands().values().forEach(c -> this.updateSpecHelpAndUnmatched(c.getCommandSpec(), unrecognizedArgs));
    }

    CommandLine createCommandLine(List<String> unrecognizedArgs) {
        CommandLine.Model.CommandSpec spec = CommandLine.Model.CommandSpec.forAnnotatedObject((Object)new Main(), (CommandLine.IFactory)new CommandLine.IFactory(){

            public <K> K create(Class<K> cls) throws Exception {
                Object result = CommandLine.defaultFactory().create(cls);
                if (result instanceof AbstractCommand) {
                    AbstractCommand ac = (AbstractCommand)result;
                    ac.setPicocli(Picocli.this);
                }
                return (K)result;
            }
        }).name(Environment.getCommand());
        this.updateSpecHelpAndUnmatched(spec, unrecognizedArgs);
        CommandLine cmd = new CommandLine((Object)spec);
        cmd.setExpandAtFiles(false);
        cmd.setPosixClusteredShortOptionsAllowed(false);
        cmd.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)this.errorHandler);
        cmd.setParameterExceptionHandler((CommandLine.IParameterExceptionHandler)new ShortErrorMessageHandler());
        cmd.setHelpFactory((CommandLine.IHelpFactory)new HelpFactory());
        cmd.getHelpSectionMap().put("commandList", new SubCommandListRenderer());
        cmd.setErr(this.getErrWriter());
        cmd.setOut(this.getOutWriter());
        this.removePlatformSpecificCommands(cmd);
        return cmd;
    }

    private void removePlatformSpecificCommands(CommandLine cmd) {
        CommandLine windowsServiceCmd;
        CommandLine toolsCmd;
        if (this.getCommandMode() == CommandMode.UNIX && (toolsCmd = (CommandLine)cmd.getSubcommands().get("tools")) != null && (windowsServiceCmd = (CommandLine)toolsCmd.getSubcommands().get("windows-service")) != null) {
            toolsCmd.getCommandSpec().removeSubcommand("windows-service");
        }
    }

    protected CommandMode getCommandMode() {
        return Optional.ofNullable(System.getenv("KEYCLOAK_COMMAND_MODE")).map(CommandMode::valueOf).orElse(Environment.isWindows() ? CommandMode.WIN : CommandMode.UNIX);
    }

    public PrintWriter getErrWriter() {
        return new PrintWriter(System.err, true);
    }

    public PrintWriter getOutWriter() {
        return new PrintWriter(System.out, true);
    }

    private IncludeOptions getIncludeOptions(AbstractCommand abstractCommand) {
        if (abstractCommand == null) {
            return new IncludeOptions(false, false, false);
        }
        boolean autoBuild = abstractCommand instanceof AbstractAutoBuildCommand;
        boolean includeBuildTime = abstractCommand instanceof Build || autoBuild && !abstractCommand.isOptimized();
        return new IncludeOptions(autoBuild, includeBuildTime, autoBuild || includeBuildTime || abstractCommand instanceof ShowConfig);
    }

    private void addCommandOptions(CommandLine command, AbstractCommand ac) {
        if (!this.options.includeBuildTime && !this.options.includeRuntime) {
            return;
        }
        EnumMap mappers = new EnumMap(OptionCategory.class);
        PropertyMappers.getRuntimeMappers().entrySet().forEach(e -> mappers.put((OptionCategory)e.getKey(), new ArrayList((Collection)e.getValue())));
        PropertyMappers.getBuildTimeMappers().entrySet().forEach(e -> mappers.computeIfAbsent((OptionCategory)e.getKey(), category -> new ArrayList()).addAll((Collection)e.getValue()));
        Picocli.addMappedOptionsToArgGroups(command, mappers, ac, this.options);
    }

    private static void addMappedOptionsToArgGroups(CommandLine commandLine, Map<OptionCategory, List<PropertyMapper<?>>> propertyMappers, AbstractCommand ac, IncludeOptions options) {
        CommandLine.Model.CommandSpec cSpec = commandLine.getCommandSpec();
        for (Map.Entry<OptionCategory, List<PropertyMapper<?>>> entry : propertyMappers.entrySet()) {
            HashSet<String> names = new HashSet<String>();
            OptionCategory category = entry.getKey();
            CommandLine.Model.ArgGroupSpec.Builder argGroupBuilder = CommandLine.Model.ArgGroupSpec.builder().heading(category.getHeading() + ":").order(category.getOrder()).validate(false);
            for (PropertyMapper<?> mapper : entry.getValue()) {
                boolean hidden;
                String name = mapper.getCliFormat();
                boolean bl = hidden = mapper.isHidden() || ac.isHiddenCategory(mapper.getCategory()) || !options.includeBuildTime && mapper.isBuildTime() || !options.includeRuntime && mapper.isRunTime();
                if (hidden && ac.isHelpAll() || cSpec.optionsMap().containsKey(name) || ac.isHelpAll() && !names.add(name)) continue;
                CommandLine.Model.OptionSpec.Builder optBuilder = (CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)name, (String[])new String[0]).description(new String[]{Picocli.getDecoratedOptionDescription(mapper)})).completionCandidates(() -> mapper.getExpectedValues().iterator())).hidden(hidden);
                if (mapper.getParamLabel() != null) {
                    optBuilder.paramLabel(mapper.getParamLabel());
                }
                if (mapper.getDefaultValue().isPresent()) {
                    optBuilder.defaultValue(Option.getDefaultValueString(mapper.getDefaultValue().get()));
                }
                optBuilder.arity("1");
                if (mapper.getType() != null) {
                    optBuilder.type(mapper.getType());
                    if (mapper.isList()) {
                        optBuilder.splitRegex(",");
                    } else if (mapper.getType().isEnum()) {
                        optBuilder.type(String.class);
                    }
                } else {
                    optBuilder.type(String.class);
                }
                argGroupBuilder.addArg((CommandLine.Model.ArgSpec)optBuilder.build());
            }
            if (argGroupBuilder.args().isEmpty()) continue;
            cSpec.addArgGroup(argGroupBuilder.build());
        }
    }

    private static String getDecoratedOptionDescription(PropertyMapper<?> mapper) {
        StringBuilder transformedDesc = new StringBuilder(Optional.ofNullable(mapper.getDescription()).orElse(""));
        if (mapper.getType() != Boolean.class && !mapper.getExpectedValues().isEmpty()) {
            List<String> decoratedExpectedValues = mapper.getExpectedValues().stream().map(value -> {
                if (mapper.getDeprecatedMetadata().filter(metadata -> metadata.getDeprecatedValues().contains(value)).isPresent()) {
                    return value + " (deprecated)";
                }
                return value;
            }).toList();
            boolean isStrictExpectedValues = mapper.getOption().isStrictExpectedValues();
            boolean isCaseInsensitiveExpectedValues = mapper.getOption().isCaseInsensitiveExpectedValues();
            String printableValues = String.join((CharSequence)", ", decoratedExpectedValues) + (!isStrictExpectedValues ? ", or a custom one" : "");
            transformedDesc.append(String.format(" Possible values are%s: %s.", isCaseInsensitiveExpectedValues ? " (case insensitive)" : "", printableValues));
        }
        mapper.getDefaultValue().map(d -> Option.getDefaultValueString((Object)d).replaceAll("%", "%%")).map(d -> " Default: " + d + ".").ifPresent(transformedDesc::append);
        mapper.getEnabledWhen().map(e -> String.format(" %s.", e)).ifPresent(transformedDesc::append);
        mapper.getRequiredWhen().map(e -> String.format(" %s.", e)).ifPresent(transformedDesc::append);
        mapper.getDeprecatedMetadata().filter(deprecatedMetadata -> deprecatedMetadata.getDeprecatedValues().isEmpty()).ifPresent(deprecatedMetadata -> {
            ArrayList<Object> deprecatedDetails = new ArrayList<Object>();
            Object note = deprecatedMetadata.getNote();
            if (note != null) {
                if (!((String)note).endsWith(".")) {
                    note = (String)note + ".";
                }
                deprecatedDetails.add(note);
            }
            if (!deprecatedMetadata.getNewOptionsKeys().isEmpty()) {
                String s = deprecatedMetadata.getNewOptionsKeys().size() > 1 ? "s" : "";
                deprecatedDetails.add("Use the following option" + s + " instead: " + String.join((CharSequence)", ", deprecatedMetadata.getNewOptionsKeys()) + ".");
            }
            transformedDesc.insert(0, "@|bold DEPRECATED.|@ ");
            if (!deprecatedDetails.isEmpty()) {
                transformedDesc.append(" @|bold ").append(String.join((CharSequence)" ", deprecatedDetails)).append("|@");
            }
        });
        return transformedDesc.toString();
    }

    public void println(String message) {
        this.getOutWriter().println(message);
    }

    public static List<String> parseArgs(String[] rawArgs) throws PropertyException {
        if (rawArgs.length == 0) {
            return List.of();
        }
        ConfigArgsConfigSource.setCliArgs(rawArgs);
        ArrayList<String> args = new ArrayList<String>();
        ConfigArgsConfigSource.parseConfigArgs(List.of(rawArgs), (arg, value) -> {
            if (!arg.startsWith("--spi") && !arg.startsWith("-D")) {
                args.add(arg + "=" + value);
            }
        }, arg -> {
            if (arg.startsWith("--spi")) {
                throw new PropertyException(String.format("spi argument %s requires a value.", arg));
            }
            if (!arg.startsWith("-D")) {
                args.add((String)arg);
            }
        });
        return args;
    }

    public void checkChangesInBuildOptionsDuringAutoBuild(PrintWriter out) {
        StringBuilder options = new StringBuilder();
        Picocli.checkChangesInBuildOptions((Functions.TriConsumer<String, String, String>)((Functions.TriConsumer)(key, oldValue, newValue) -> Picocli.optionChanged(options, key, oldValue, newValue)));
        if (options.isEmpty()) {
            return;
        }
        out.println(this.colorMode.string("@|bold,red " + "The previous optimized build will be overridden with the following build options:" + options + "\nTo avoid that, run the 'build' command again and then start the optimized server instance using the '--optimized' flag." + "|@"));
    }

    private static void checkChangesInBuildOptions(Functions.TriConsumer<String, String, String> valueChanged) {
        Properties current = Picocli.getNonPersistedBuildTimeOptions();
        Map<String, String> persisted = Configuration.getRawPersistedProperties();
        current.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String persistedValue = (String)persisted.get(key);
            if (!value.equals(persistedValue)) {
                valueChanged.accept((Object)((String)key), (Object)persistedValue, (Object)((String)value));
            }
        }));
        persisted.forEach((key, value) -> {
            if (current.get(key) == null) {
                valueChanged.accept(key, value, null);
            }
        });
    }

    private static void optionChanged(StringBuilder options, String key, String oldValue, String newValue) {
        boolean isIgnored;
        boolean bl = isIgnored = !key.startsWith("kc.") || key.startsWith(KC_PROVIDER_FILE_PREFIX) || Picocli.isIgnoredPersistedOption(key);
        if (!isIgnored) {
            key = key.substring(3);
            options.append("\n\t- ").append(key).append("=").append(Optional.ofNullable(oldValue).orElse("<unset>")).append(" > ").append(key).append("=").append(Optional.ofNullable(newValue).orElse("<unset>"));
        }
    }

    private static boolean isIgnoredPersistedOption(String key) {
        return key.equals("kc.optimized") || key.equals("kc.profile") || key.equals(LaunchMode.current().getProfileKey());
    }

    public void start() {
        KeycloakMain.start(this, this.getParsedCommand().filter(AbstractNonServerCommand.class::isInstance).orElse(null), this.errorHandler);
    }

    public void build() throws Throwable {
        QuarkusEntryPoint.main((String[])new String[0]);
    }

    public void initConfig(AbstractCommand command) {
        if (Configuration.isInitialized()) {
            throw new IllegalStateException("Config should not be initialized until profile is determined");
        }
        this.parsedCommand = Optional.ofNullable(command);
        this.options = this.getIncludeOptions(command);
        if (!Environment.isRebuilt() && command instanceof AbstractAutoBuildCommand && !command.isOptimized()) {
            Environment.setRebuildCheck(true);
        }
        String profile = Optional.ofNullable(org.keycloak.common.util.Environment.getProfile()).or(() -> this.parsedCommand.map(AbstractCommand::getInitProfile)).orElse("prod");
        Environment.setProfile(profile);
        if (this.parsedCommand.filter(AbstractCommand::isHelpAll).isEmpty()) {
            this.parsedCommand.ifPresent(PropertyMappers::sanitizeDisabledMappers);
        }
    }

    public void warnOnDuplicatedOptionsInCli() {
        Set<String> duplicatedOptionsNames = ConfigArgsConfigSource.getDuplicatedArgNames();
        if (!duplicatedOptionsNames.isEmpty()) {
            this.warn("Duplicated options present in CLI: %s".formatted(String.join((CharSequence)", ", duplicatedOptionsNames)));
            ConfigArgsConfigSource.clearDuplicatedArgNames();
        }
    }

    private record IncludeOptions(boolean includeRuntime, boolean includeBuildTime, boolean allowUnrecognized) {
    }

    static enum CommandMode {
        ALL,
        WIN,
        UNIX;

    }
}

