/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.admin.resource;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.keycloak.authentication.actiontoken.inviteorg.InviteOrgActionToken;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationInvitationModel;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.organization.InvitationManager;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.idm.OrganizationInvitationRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.services.validation.Validation;
import org.keycloak.storage.adapter.InMemoryUserAdapter;
import org.keycloak.utils.StringUtil;

@Tag(name="Organizations")
public class OrganizationInvitationResource {
    private final KeycloakSession session;
    private final RealmModel realm;
    private final OrganizationModel organization;
    private final AdminEventBuilder adminEvent;

    public OrganizationInvitationResource(KeycloakSession session, OrganizationModel organization, AdminEventBuilder adminEvent) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.organization = organization;
        this.adminEvent = adminEvent.resource(ResourceType.ORGANIZATION_MEMBERSHIP);
    }

    public Response inviteUser(String email, String firstName, String lastName) {
        UserModel user;
        if (StringUtil.isBlank((String)email)) {
            throw ErrorResponse.error("Email is required to invite a member", Response.Status.BAD_REQUEST);
        }
        if (!Validation.isEmailValid(email = email.trim().toLowerCase())) {
            throw ErrorResponse.error("Invalid email format", Response.Status.BAD_REQUEST);
        }
        OrganizationProvider invitationProvider = (OrganizationProvider)this.session.getProvider(OrganizationProvider.class);
        InvitationManager invitationManager = invitationProvider.getInvitationManager();
        OrganizationInvitationModel existingInvitation = invitationManager.getByEmail(this.organization, email);
        if (existingInvitation != null) {
            if (!existingInvitation.isExpired()) {
                throw ErrorResponse.error("User already has a pending invitation", Response.Status.CONFLICT);
            }
            invitationManager.remove(existingInvitation.getId());
        }
        if ((user = this.session.users().getUserByEmail(this.realm, email)) != null) {
            if (this.organization.isMember(user)) {
                throw ErrorResponse.error("User already a member of the organization", Response.Status.CONFLICT);
            }
            return this.sendInvitation(user);
        }
        user = new InMemoryUserAdapter(this.session, this.realm, null);
        user.setEmail(email);
        if (firstName != null && lastName != null) {
            user.setFirstName(firstName);
            user.setLastName(lastName);
        }
        return this.sendInvitation(user);
    }

    public Response inviteExistingUser(String id) {
        if (StringUtil.isBlank((String)id)) {
            throw new BadRequestException("To invite a member you need to provide the user id");
        }
        UserModel user = this.session.users().getUserById(this.realm, id);
        if (user == null) {
            throw ErrorResponse.error("User does not exist", Response.Status.BAD_REQUEST);
        }
        return this.sendInvitation(user);
    }

    private Response sendInvitation(UserModel user) {
        OrganizationProvider provider = (OrganizationProvider)this.session.getProvider(OrganizationProvider.class);
        InvitationManager invitationManager = provider.getInvitationManager();
        OrganizationInvitationModel invitation = invitationManager.create(this.organization, user.getEmail(), user.getFirstName(), user.getLastName());
        String link = user.getId() == null ? this.createRegistrationLink(user, invitation) : this.createInvitationLink(user, invitation);
        invitation.setInviteLink(link);
        try {
            ((EmailTemplateProvider)this.session.getProvider(EmailTemplateProvider.class)).setRealm(this.realm).setUser(user).sendOrgInviteEmail(this.organization, link, TimeUnit.SECONDS.toMinutes(this.getActionTokenLifespan()));
        }
        catch (EmailException e) {
            ServicesLogger.LOGGER.failedToSendEmail((Exception)((Object)e));
            throw ErrorResponse.error("Failed to send invite email", Response.Status.INTERNAL_SERVER_ERROR);
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
        return Response.noContent().build();
    }

    private int getActionTokenLifespan() {
        return this.realm.getActionTokenGeneratedByAdminLifespan();
    }

    private String createInvitationLink(UserModel user, OrganizationInvitationModel invitation) {
        return LoginActionsService.actionTokenProcessor((UriInfo)this.session.getContext().getUri()).queryParam("key", new Object[]{this.createToken(user, invitation)}).build(new Object[]{this.realm.getName()}).toString();
    }

    private String createRegistrationLink(UserModel user, OrganizationInvitationModel invitation) {
        return OIDCLoginProtocolService.registrationsUrl(this.session.getContext().getUri().getBaseUriBuilder()).queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{"account"}).queryParam("token", new Object[]{this.createToken(user, invitation)}).buildFromMap(Map.of("realm", this.realm.getName(), "protocol", "openid-connect")).toString();
    }

    private String createToken(UserModel user, OrganizationInvitationModel invitation) {
        InviteOrgActionToken token = new InviteOrgActionToken(user.getId(), invitation.getExpiresAt(), user.getEmail(), "account");
        token.setOrgId(this.organization.getId());
        token.id(invitation.getId());
        if (this.organization.getRedirectUrl() == null || this.organization.getRedirectUrl().isBlank()) {
            token.setRedirectUri(this.resolveAccountClientBaseUrl());
        } else {
            token.setRedirectUri(this.organization.getRedirectUrl());
        }
        return token.serialize(this.session, this.realm, (UriInfo)this.session.getContext().getUri());
    }

    private String resolveAccountClientBaseUrl() {
        String baseUrl;
        ClientModel accountClient = this.realm.getClientByClientId("account");
        if (accountClient != null && (baseUrl = accountClient.getBaseUrl()) != null && !baseUrl.isBlank()) {
            return ResolveRelative.resolveRelativeUri(this.session, accountClient.getRootUrl(), baseUrl);
        }
        return Urls.accountBase(this.session.getContext().getUri().getBaseUri()).path("/").build(new Object[]{this.realm.getName()}).toString();
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get invitations for the organization")
    @APIResponses(value={@APIResponse(responseCode="200", description="Success")})
    public Stream<OrganizationInvitationRepresentation> getInvitations(@QueryParam(value="first") Integer first, @QueryParam(value="max") Integer max, @QueryParam(value="status") String status, @QueryParam(value="email") String email, @QueryParam(value="search") String search, @QueryParam(value="firstName") String firstName, @QueryParam(value="lastName") String lastName) {
        OrganizationProvider provider = (OrganizationProvider)this.session.getProvider(OrganizationProvider.class);
        HashMap<OrganizationInvitationModel.Filter, String> filters = new HashMap<OrganizationInvitationModel.Filter, String>();
        if (status != null) {
            filters.put(OrganizationInvitationModel.Filter.STATUS, status);
        }
        if (email != null) {
            filters.put(OrganizationInvitationModel.Filter.EMAIL, email);
        }
        if (search != null) {
            filters.put(OrganizationInvitationModel.Filter.SEARCH, search);
        }
        if (firstName != null) {
            filters.put(OrganizationInvitationModel.Filter.FIRST_NAME, firstName);
        }
        if (lastName != null) {
            filters.put(OrganizationInvitationModel.Filter.LAST_NAME, lastName);
        }
        InvitationManager invitationManager = provider.getInvitationManager();
        Stream invitations = invitationManager.getAllStream(this.organization, filters, first, max);
        return invitations.map(this::toRepresentation);
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Operation(summary="Get invitation by ID")
    @APIResponses(value={@APIResponse(responseCode="200", description="Success"), @APIResponse(responseCode="404", description="Not Found")})
    public OrganizationInvitationRepresentation getInvitation(@PathParam(value="id") String id) {
        OrganizationProvider provider = (OrganizationProvider)this.session.getProvider(OrganizationProvider.class);
        InvitationManager invitationManager = provider.getInvitationManager();
        OrganizationInvitationModel invitation = invitationManager.getById(id);
        if (invitation == null) {
            throw ErrorResponse.error("Invitation not found", Response.Status.NOT_FOUND);
        }
        return this.toRepresentation(invitation);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(summary="Delete an invitation")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="404", description="Not Found")})
    public Response deleteInvitation(@PathParam(value="id") String id) {
        OrganizationProvider provider = (OrganizationProvider)this.session.getProvider(OrganizationProvider.class);
        InvitationManager invitationManager = provider.getInvitationManager();
        if (!invitationManager.remove(id)) {
            throw ErrorResponse.error("Invitation not found", Response.Status.NOT_FOUND);
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
        return Response.noContent().build();
    }

    @POST
    @Path(value="/{id}/resend")
    @Operation(summary="Resend an invitation")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="404", description="Not Found")})
    public Response resendInvitation(@PathParam(value="id") String id) {
        OrganizationProvider provider = (OrganizationProvider)this.session.getProvider(OrganizationProvider.class);
        InvitationManager invitationManager = provider.getInvitationManager();
        OrganizationInvitationModel invitation = invitationManager.getById(id);
        if (invitation == null) {
            throw ErrorResponse.error("Invitation not found", Response.Status.NOT_FOUND);
        }
        invitationManager.remove(id);
        return this.inviteUser(invitation.getEmail(), invitation.getFirstName(), invitation.getLastName());
    }

    private OrganizationInvitationRepresentation toRepresentation(OrganizationInvitationModel model) {
        if (model == null) {
            return null;
        }
        OrganizationInvitationRepresentation rep = new OrganizationInvitationRepresentation();
        rep.setId(model.getId());
        rep.setEmail(model.getEmail());
        rep.setFirstName(model.getFirstName());
        rep.setLastName(model.getLastName());
        rep.setOrganizationId(model.getOrganizationId());
        rep.setSentDate(model.getCreatedAt());
        rep.setExpiresAt(model.getExpiresAt());
        rep.setInviteLink(model.getInviteLink());
        OrganizationInvitationRepresentation.Status dynamicStatus = model.isExpired() ? OrganizationInvitationRepresentation.Status.EXPIRED : OrganizationInvitationRepresentation.Status.PENDING;
        rep.setStatus(dynamicStatus);
        return rep;
    }
}

