/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum Protocol {
    SSLv2("SSLV2"),
    SSLv3("SSLV3"),
    TLSv1("TLSV1"),
    TLSv1_1("TLSV1.1"),
    TLSv1_2("TLSV1.2"),
    TLSv1_3("TLSV1.3"),
    SSLv2Hello("SSLV2HELLO");

    static final int fullSize;
    static final Map<String, Protocol> map;
    public final String name;

    private Protocol(String name) {
        this.name = name;
    }

    public static Protocol forName(String name) {
        return name == null ? null : map.get(name.toUpperCase(Locale.ENGLISH));
    }

    public static boolean isFull(EnumSet<Protocol> protocols) {
        return protocols != null && protocols.size() == fullSize;
    }

    public boolean in(Protocol value1, Protocol value2) {
        return this == value1 || this == value2;
    }

    public boolean in(Protocol value1, Protocol value2, Protocol value3) {
        return this == value1 || this == value2 || this == value3;
    }

    public boolean in(Protocol ... values) {
        if (values != null) {
            for (Protocol value : values) {
                if (this != value) continue;
                return true;
            }
        }
        return false;
    }

    static {
        fullSize = Protocol.values().length;
        map = new HashMap<String, Protocol>();
        Protocol[] protocols = Protocol.values();
        for (int i = 0; i < fullSize; ++i) {
            map.put(protocols[i].name, protocols[i]);
        }
    }
}

