/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.update.Assignable;

public class EmbeddableValuedPathInterpretation<T>
extends AbstractSqmPathInterpretation<T>
implements Assignable,
SqlTupleContainer {
    private final SqlTuple sqlExpression;
    private final @Nullable String affectedTableName;

    public static <T> Expression from(SqmEmbeddedValuedSimplePath<T> sqmPath, SqmToSqlAstConverter sqlAstCreationState, boolean jpaQueryComplianceEnabled) {
        JpaPath lhs = sqmPath.getLhs();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(lhs.getNavigablePath());
        EntityPersister treatTarget = null;
        if (jpaQueryComplianceEnabled) {
            SqmTreatedPath treatedPath;
            MappingMetamodelImplementor mappingMetamodel = sqlAstCreationState.getCreationContext().getMappingMetamodel();
            if (lhs instanceof SqmTreatedPath && (treatedPath = (SqmTreatedPath)lhs).getTreatTarget().getPersistenceType() == Type.PersistenceType.ENTITY) {
                EntityDomainType treatTargetDomainType = (EntityDomainType)treatedPath.getTreatTarget();
                treatTarget = mappingMetamodel.findEntityDescriptor(treatTargetDomainType.getHibernateEntityName());
            } else {
                SqmBindableType sqmBindableType = lhs.getNodeType();
                if (sqmBindableType instanceof EntityDomainType) {
                    EntityDomainType entityDomainType = (EntityDomainType)((Object)sqmBindableType);
                    treatTarget = mappingMetamodel.findEntityDescriptor(entityDomainType.getHibernateEntityName());
                }
            }
        }
        EmbeddableValuedModelPart mapping = (EmbeddableValuedModelPart)SqmUtil.getTargetMappingIfNeeded(sqmPath, tableGroup.getModelPart(), sqlAstCreationState).findSubPart(sqmPath.getReferencedPathSource().getPathName(), treatTarget);
        return new EmbeddableValuedPathInterpretation<T>(mapping.toSqlExpression(tableGroup, sqlAstCreationState.getCurrentClauseStack().getCurrent(), sqlAstCreationState, sqlAstCreationState), sqmPath.getNavigablePath(), mapping, tableGroup);
    }

    public EmbeddableValuedPathInterpretation(SqlTuple sqlExpression, NavigablePath navigablePath, EmbeddableValuedModelPart mapping, TableGroup tableGroup) {
        this(sqlExpression, navigablePath, mapping, tableGroup, SqmUtil.determineAffectedTableName(tableGroup, mapping));
    }

    public EmbeddableValuedPathInterpretation(SqlTuple sqlExpression, NavigablePath navigablePath, EmbeddableValuedModelPart mapping, TableGroup tableGroup, @Nullable String affectedTableName) {
        super(navigablePath, mapping, tableGroup);
        this.sqlExpression = sqlExpression;
        this.affectedTableName = affectedTableName;
    }

    @Override
    public SqlTuple getSqlExpression() {
        return this.sqlExpression;
    }

    @Override
    public @Nullable String getAffectedTableName() {
        return this.affectedTableName;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.sqlExpression.accept(sqlTreeWalker);
    }

    public String toString() {
        return "EmbeddableValuedPathInterpretation(" + String.valueOf(this.getNavigablePath()) + ")";
    }

    @Override
    public void visitColumnReferences(Consumer<ColumnReference> columnReferenceConsumer) {
        for (Expression expression : this.sqlExpression.getExpressions()) {
            if (expression instanceof ColumnReference) {
                ColumnReference columnReference = (ColumnReference)expression;
                columnReferenceConsumer.accept(columnReference);
                continue;
            }
            throw new IllegalArgumentException("Expecting ColumnReference, found : " + String.valueOf(expression));
        }
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        ArrayList<ColumnReference> results = new ArrayList<ColumnReference>();
        this.visitColumnReferences(results::add);
        return results;
    }

    @Override
    public SqlTuple getSqlTuple() {
        return this.sqlExpression;
    }
}

