/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations;

import org.keycloak.TokenCategory;
import org.keycloak.representations.AccessToken;

public class RefreshToken
extends AccessToken {
    private RefreshToken() {
        this.type("Refresh");
    }

    public RefreshToken(AccessToken token) {
        this();
        this.issuer = token.issuer;
        this.subject = token.subject;
        this.issuedFor = token.issuedFor;
        this.sessionId = token.sessionId;
        this.nonce = token.nonce;
        this.audience = new String[]{token.issuer};
        this.scope = token.scope;
    }

    public RefreshToken(AccessToken token, AccessToken.Confirmation confirmation) {
        this();
        this.issuer = token.issuer;
        this.subject = token.subject;
        this.issuedFor = token.issuedFor;
        this.sessionId = token.sessionId;
        this.nonce = token.nonce;
        this.audience = new String[]{token.issuer};
        this.scope = token.scope;
        this.confirmation = confirmation;
    }

    @Override
    public TokenCategory getCategory() {
        return TokenCategory.INTERNAL;
    }

    @Override
    public String getSessionId() {
        String sessionId = super.getSessionId();
        return sessionId != null ? sessionId : (String)this.getOtherClaims().get("session_state");
    }
}

