/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.settings;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.function.Consumer;
import org.aesh.command.CommandNotFoundHandler;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.activator.CommandActivatorProvider;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.activator.OptionActivatorProvider;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.CompleterInvocationProvider;
import org.aesh.command.converter.ConverterInvocation;
import org.aesh.command.converter.ConverterInvocationProvider;
import org.aesh.command.export.ExportChangeListener;
import org.aesh.command.impl.invocation.AeshInvocationProviders;
import org.aesh.command.impl.registry.MutableCommandRegistryImpl;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationProvider;
import org.aesh.command.invocation.InvocationProviders;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.settings.FileAccessPermission;
import org.aesh.command.settings.ManProvider;
import org.aesh.command.settings.QuitHandler;
import org.aesh.command.settings.Settings;
import org.aesh.command.settings.SettingsImpl;
import org.aesh.command.validator.ValidatorInvocation;
import org.aesh.command.validator.ValidatorInvocationProvider;
import org.aesh.io.Resource;
import org.aesh.readline.AeshContext;
import org.aesh.readline.alias.AliasManager;
import org.aesh.readline.editing.EditMode;
import org.aesh.readline.util.LoggerUtil;
import org.aesh.terminal.Connection;

public class SettingsBuilder<CI extends CommandInvocation, CO extends ConverterInvocation, COM extends CompleterInvocation, VI extends ValidatorInvocation, OA extends OptionActivator, CA extends CommandActivator> {
    private SettingsImpl<CI, CO, COM, VI, OA, CA> settings;

    private SettingsBuilder<CI, CO, COM, VI, OA, CA> apply(Consumer<SettingsBuilder<CI, CO, COM, VI, OA, CA>> consumer) {
        consumer.accept(this);
        return this;
    }

    public static <CI extends CommandInvocation, CO extends ConverterInvocation, COM extends CompleterInvocation, VI extends ValidatorInvocation, OA extends OptionActivator, CA extends CommandActivator> SettingsBuilder<CI, CO, COM, VI, OA, CA> builder() {
        return new SettingsBuilder<CI, CO, COM, VI, OA, CA>();
    }

    private SettingsBuilder() {
        this.settings = new SettingsImpl();
    }

    public SettingsBuilder(Settings<CI, CO, COM, VI, OA, CA> baseSettings) {
        this.settings = new SettingsImpl<CI, CO, COM, VI, OA, CA>(baseSettings);
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> mode(EditMode.Mode mode) {
        return this.apply(c -> c.settings.setMode(mode));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> historyFile(File history) {
        return this.apply(c -> c.settings.setHistoryFile(history));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> historyFilePermission(FileAccessPermission fileAccessPermission) {
        return this.apply(c -> c.settings.setHistoryFilePermission(fileAccessPermission));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> historySize(int size) {
        return this.apply(c -> c.settings.setHistorySize(size));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> bellStyle(String bellStyle) {
        return this.apply(c -> c.settings.setBellStyle(bellStyle));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> inputStream(InputStream inputStream) {
        return this.apply(c -> c.settings.setStdIn(inputStream));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> outputStream(PrintStream outputStream) {
        return this.apply(c -> c.settings.setStdOut(outputStream));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> outputStreamError(PrintStream error) {
        return this.apply(c -> c.settings.setStdErr(error));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> inputrc(File inputrc) {
        return this.apply(c -> c.settings.setInputrc(inputrc));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> logging(boolean logging) {
        return this.apply(c -> c.settings.setLogging(logging));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> disableCompletion(boolean disableCompletion) {
        return this.apply(c -> c.settings.setDisableCompletion(disableCompletion));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> logfile(String logFile) {
        return this.apply(c -> c.settings.setLogFile(logFile));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> readInputrc(boolean readInputrc) {
        return this.apply(c -> c.settings.setReadInputrc(readInputrc));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> disableHistory(boolean disableHistory) {
        return this.apply(c -> c.settings.setHistoryDisabled(disableHistory));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> persistHistory(boolean persistHistory) {
        return this.apply(c -> c.settings.setHistoryPersistent(persistHistory));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> aliasFile(File aliasFile) {
        return this.apply(c -> c.settings.setAliasFile(aliasFile));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> enableAlias(boolean enableAlias) {
        return this.apply(c -> c.settings.setAliasEnabled(enableAlias));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> persistAlias(boolean persistAlias) {
        return this.apply(c -> c.settings.setPersistAlias(persistAlias));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> aliasManager(AliasManager aliasManager) {
        return this.apply(c -> c.settings.setAliasManager(aliasManager));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> quitHandler(QuitHandler quitHandler) {
        return this.apply(c -> c.settings.setQuitHandler(quitHandler));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> parseOperators(boolean parseOperators) {
        return this.apply(c -> c.settings.enableOperatorParser(parseOperators));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> enableMan(boolean enableMan) {
        return this.apply(c -> c.settings.setManEnabled(enableMan));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> aeshContext(AeshContext aeshContext) {
        return this.apply(c -> c.settings.setAeshContext(aeshContext));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> enableExport(boolean enableExport) {
        return this.apply(c -> c.settings.setExportEnabled(enableExport));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> exportFile(File exportFile) {
        return this.apply(c -> c.settings.setExportFile(exportFile));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> setPersistExport(boolean persistExport) {
        return this.apply(c -> c.settings.setPersistExport(persistExport));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> setExportUsesSystemEnvironment(boolean isLoad) {
        return this.apply(c -> c.settings.setExportUsesSystemEnvironment(isLoad));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> setFileResource(Resource resource) {
        return this.apply(c -> c.settings.setResource(resource));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> setExecuteAtStart(String execute) {
        return this.apply(c -> c.settings.setExecuteAtStart(execute));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> setExecuteFileAtStart(Resource executeFile) {
        return this.apply(c -> c.settings.setExecuteFileAtStart(executeFile));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> commandActivatorProvider(CommandActivatorProvider commandActivatorProvider) {
        return this.apply(c -> c.settings.setCommandActivatorProvider(commandActivatorProvider));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> optionActivatorProvider(OptionActivatorProvider optionActivatorProvider) {
        return this.apply(c -> c.settings.setOptionActivatorProvider(optionActivatorProvider));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> commandRegistry(CommandRegistry commandRegistry) {
        return this.apply(c -> c.settings.setCommandRegistry(commandRegistry));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> commandInvocationProvider(CommandInvocationProvider commandInvocationProvider) {
        return this.apply(c -> c.settings.setCommandInvocationProvider(commandInvocationProvider));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> commandNotFoundHandler(CommandNotFoundHandler commandNotFoundHandler) {
        return this.apply(c -> c.settings.setCommandNotFoundHandler(commandNotFoundHandler));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> completerInvocationProvider(CompleterInvocationProvider completerInvocationProvider) {
        return this.apply(c -> c.settings.setCompleterInvocationProvider(completerInvocationProvider));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> converterInvocationProvider(ConverterInvocationProvider converterInvocationProvider) {
        return this.apply(c -> c.settings.setConverterInvocationProvider(converterInvocationProvider));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> validatorInvocationProvider(ValidatorInvocationProvider validatorInvocationProvider) {
        return this.apply(c -> c.settings.setValidatorInvocationProvider(validatorInvocationProvider));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> manProvider(ManProvider manProvider) {
        return this.apply(c -> c.settings.setManProvider(manProvider));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> invocationProviders(InvocationProviders<CA, CO, COM, VI, OA> invocationProviders) {
        return this.apply(c -> c.settings.setInvocationProviders(invocationProviders));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> connection(Connection connection) {
        return this.apply(c -> c.settings.setConnection(connection));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> enableOperatorParser(boolean enabled) {
        return this.apply(c -> c.settings.enableOperatorParser(enabled));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> exportListener(ExportChangeListener listener) {
        return this.apply(c -> c.settings.setExportListener(listener));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> echoCtrl(boolean echo) {
        return this.apply(c -> c.settings.echoCtrl(echo));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> redrawPromptOnInterrupt(boolean redraw) {
        return this.apply(c -> c.settings.redrawPromptOnInterrupt(redraw));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> setInterruptHandler(Consumer<Void> consumer) {
        return this.apply(c -> c.settings.setInterruptHandler((Consumer)consumer));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> setConnectionClosedHandler(Consumer<Void> consumer) {
        return this.apply(c -> c.settings.setConnectionClosedHandler((Consumer)consumer));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> setScanForCommandPackages(String ... packages) {
        return this.apply(c -> c.settings.setScanForCommandPackages(packages));
    }

    public SettingsBuilder<CI, CO, COM, VI, OA, CA> enableSearchInPaging(boolean enable) {
        return this.apply(c -> c.settings.setEnableSearchInPaging(enable));
    }

    public Settings<CI, CO, COM, VI, OA, CA> build() {
        if (this.settings.logging()) {
            LoggerUtil.doLog();
        }
        if (this.settings.commandRegistry() == null) {
            this.settings.setCommandRegistry(new MutableCommandRegistryImpl());
        }
        if (this.settings.commandInvocationProvider() == null) {
            this.settings.setCommandInvocationProvider(commandInvocation -> commandInvocation);
        }
        if (this.settings.completerInvocationProvider() == null) {
            this.settings.setCompleterInvocationProvider(completerInvocation -> completerInvocation);
        }
        if (this.settings.converterInvocationProvider() == null) {
            this.settings.setConverterInvocationProvider(converterInvocation -> converterInvocation);
        }
        if (this.settings.validatorInvocationProvider() == null) {
            this.settings.setValidatorInvocationProvider(validatorInvocation -> validatorInvocation);
        }
        if (this.settings.optionActivatorProvider() == null) {
            this.settings.setOptionActivatorProvider(optionActivator -> optionActivator);
        }
        if (this.settings.commandActivatorProvider() == null) {
            this.settings.setCommandActivatorProvider(commandActivator -> commandActivator);
        }
        if (this.settings.invocationProviders() == null) {
            this.settings.setInvocationProviders(new AeshInvocationProviders(this.settings.converterInvocationProvider(), this.settings.completerInvocationProvider(), this.settings.validatorInvocationProvider(), this.settings.optionActivatorProvider(), this.settings.commandActivatorProvider()));
        }
        return this.settings;
    }
}

