/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.dataconversion.MediaType;

public final class MediaTypeIds {
    private static final Map<MediaType, Short> idByType = new HashMap<MediaType, Short>(16);
    private static final Map<Short, MediaType> typeById = new HashMap<Short, MediaType>(16);

    public static Short getId(MediaType mediaType) {
        if (mediaType == null) {
            return null;
        }
        return idByType.get(mediaType.withoutParameters());
    }

    public static MediaType getMediaType(Short id) {
        return typeById.get(id);
    }

    static {
        idByType.put(MediaType.APPLICATION_OBJECT, (short)1);
        idByType.put(MediaType.APPLICATION_JSON, (short)2);
        idByType.put(MediaType.APPLICATION_OCTET_STREAM, (short)3);
        idByType.put(MediaType.APPLICATION_PDF, (short)4);
        idByType.put(MediaType.APPLICATION_RTF, (short)5);
        idByType.put(MediaType.APPLICATION_ZIP, (short)6);
        idByType.put(MediaType.IMAGE_GIF, (short)7);
        idByType.put(MediaType.IMAGE_JPEG, (short)8);
        idByType.put(MediaType.IMAGE_PNG, (short)9);
        idByType.put(MediaType.TEXT_CSS, (short)10);
        idByType.put(MediaType.TEXT_CSV, (short)11);
        idByType.put(MediaType.APPLICATION_PROTOSTREAM, (short)12);
        idByType.put(MediaType.TEXT_PLAIN, (short)13);
        idByType.put(MediaType.TEXT_HTML, (short)14);
        idByType.put(MediaType.APPLICATION_JBOSS_MARSHALLING, (short)15);
        idByType.put(MediaType.APPLICATION_INFINISPAN_MARSHALLING, (short)16);
        idByType.put(MediaType.APPLICATION_UNKNOWN, (short)17);
        idByType.forEach((key, value) -> typeById.put((Short)value, (MediaType)key));
    }
}

