/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal;

import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import jdk.jfr.consumer.RecordedEvent;

public interface RecordedEventHandler
extends Consumer<RecordedEvent>,
Predicate<RecordedEvent>,
AutoCloseable {
    public String getEventName();

    public JfrFeature getFeature();

    @Override
    default public boolean test(RecordedEvent event) {
        return event.getEventType().getName().equalsIgnoreCase(this.getEventName());
    }

    default public Optional<Duration> getPollingDuration() {
        return Optional.empty();
    }

    default public Optional<Duration> getThreshold() {
        return Optional.empty();
    }

    public static void closeObservables(List<AutoCloseable> observables) {
        observables.forEach(observable -> {
            try {
                observable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @Override
    default public void close() {
    }
}

