/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.hibernate.common.runtime;

import io.quarkus.panache.common.Sort;
import io.quarkus.panache.common.exception.PanacheQueryException;
import java.util.Locale;
import java.util.regex.Pattern;

public class PanacheJpaUtil {
    static final Pattern SELECT_PATTERN = Pattern.compile("^\\s*SELECT\\s+((?:DISTINCT\\s+)?\\w+(?:\\.\\w+)*)(?:\\s+AS\\s+\\w+)?(\\s*,\\s*\\w+(?:\\.\\w+)*(?:\\s+AS\\s+\\w+)?)*\\s+(.*)", 34);
    static final Pattern FROM_PATTERN = Pattern.compile("^\\s*FROM\\s+.*", 34);
    static final Pattern FETCH_PATTERN = Pattern.compile(".*\\s+FETCH\\s+.*", 34);
    static final Pattern LONE_SELECT_PATTERN = Pattern.compile(".*SELECT\\s+.*", 34);
    static final Pattern WITH_PATTERN = Pattern.compile("^\\s*WITH\\s+.*", 34);

    public static String getEntityName(Class<?> entityClass) {
        return "`%s`".formatted(entityClass.getName());
    }

    public static String trimForAnalysis(String query) {
        String ret = query.replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').toLowerCase(Locale.ROOT);
        if (ret.indexOf("  ") != -1) {
            ret = ret.replaceAll("\\s+", " ");
        }
        return ret.trim();
    }

    public static String createFindQuery(Class<?> entityClass, String query, int paramCount) {
        if (query == null) {
            return "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        }
        String trimmedForAnalysis = PanacheJpaUtil.trimForAnalysis((String)query);
        if (trimmedForAnalysis.isEmpty()) {
            return "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        }
        if (trimmedForAnalysis.startsWith("from ") || trimmedForAnalysis.startsWith("select ") || trimmedForAnalysis.startsWith("with ")) {
            return query;
        }
        if (trimmedForAnalysis.startsWith("order by ") || trimmedForAnalysis.startsWith("where ")) {
            return "FROM " + PanacheJpaUtil.getEntityName(entityClass) + " " + (String)query;
        }
        if (trimmedForAnalysis.indexOf(32) == -1 && trimmedForAnalysis.indexOf(61) == -1 && paramCount == 1) {
            query = (String)query + " = ?1";
        }
        return "FROM " + PanacheJpaUtil.getEntityName(entityClass) + " WHERE " + (String)query;
    }

    public static boolean isNamedQuery(String query) {
        if (query == null || query.isEmpty()) {
            return false;
        }
        return query.charAt(0) == '#';
    }

    public static String createQueryForCount(Class<?> entityClass, String query, int paramCount) {
        if (query == null || ((String)query).isEmpty()) {
            return "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        }
        String trimmedForAnalysis = PanacheJpaUtil.trimForAnalysis((String)query);
        if (trimmedForAnalysis.isEmpty()) {
            return "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        }
        if (trimmedForAnalysis.startsWith("select ") || trimmedForAnalysis.startsWith("with ") || trimmedForAnalysis.startsWith("from ")) {
            return query;
        }
        if (trimmedForAnalysis.startsWith("where ")) {
            return "FROM " + PanacheJpaUtil.getEntityName(entityClass) + " " + (String)query;
        }
        if (trimmedForAnalysis.startsWith("order by ")) {
            return "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        }
        if (trimmedForAnalysis.indexOf(32) == -1 && trimmedForAnalysis.indexOf(61) == -1 && paramCount == 1) {
            query = (String)query + " = ?1";
        }
        return "FROM " + PanacheJpaUtil.getEntityName(entityClass) + " WHERE " + (String)query;
    }

    public static String createUpdateQuery(Class<?> entityClass, String query, int paramCount) {
        if (query == null) {
            throw new PanacheQueryException("Query string cannot be null");
        }
        String trimmedForAnalysis = PanacheJpaUtil.trimForAnalysis((String)query);
        if (trimmedForAnalysis.isEmpty()) {
            throw new PanacheQueryException("Query string cannot be empty");
        }
        if (trimmedForAnalysis.startsWith("update from")) {
            int index = ((String)query).toLowerCase(Locale.ROOT).indexOf("from");
            return "update " + ((String)query).substring(index + 4);
        }
        if (trimmedForAnalysis.startsWith("update ")) {
            return query;
        }
        if (trimmedForAnalysis.startsWith("from ")) {
            int index = ((String)query).toLowerCase(Locale.ROOT).indexOf("from");
            return "UPDATE " + ((String)query).substring(index + 4);
        }
        if (trimmedForAnalysis.indexOf(32) == -1 && trimmedForAnalysis.indexOf(61) == -1 && paramCount == 1) {
            query = (String)query + " = ?1";
        }
        if (trimmedForAnalysis.startsWith("set ")) {
            return "UPDATE " + PanacheJpaUtil.getEntityName(entityClass) + " " + (String)query;
        }
        return "UPDATE " + PanacheJpaUtil.getEntityName(entityClass) + " SET " + (String)query;
    }

    public static String createDeleteQuery(Class<?> entityClass, String query, int paramCount) {
        if (query == null) {
            return "DELETE FROM " + PanacheJpaUtil.getEntityName(entityClass);
        }
        String trimmedForAnalysis = PanacheJpaUtil.trimForAnalysis((String)query);
        if (trimmedForAnalysis.isEmpty()) {
            return "DELETE FROM " + PanacheJpaUtil.getEntityName(entityClass);
        }
        if (trimmedForAnalysis.startsWith("delete ")) {
            return query;
        }
        if (trimmedForAnalysis.startsWith("from ")) {
            return "DELETE " + (String)query;
        }
        if (trimmedForAnalysis.startsWith("order by ")) {
            return "DELETE FROM " + PanacheJpaUtil.getEntityName(entityClass);
        }
        if (trimmedForAnalysis.indexOf(32) == -1 && trimmedForAnalysis.indexOf(61) == -1 && paramCount == 1) {
            query = (String)query + " = ?1";
        }
        return "DELETE FROM " + PanacheJpaUtil.getEntityName(entityClass) + " WHERE " + (String)query;
    }

    public static String toOrderBy(Sort sort) {
        if (sort == null) {
            return null;
        }
        if (sort.getColumns().size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" ORDER BY ");
        for (int i = 0; i < sort.getColumns().size(); ++i) {
            Sort.Column column = (Sort.Column)sort.getColumns().get(i);
            if (i > 0) {
                sb.append(" , ");
            }
            if (sort.isEscapingEnabled()) {
                sb.append((CharSequence)PanacheJpaUtil.escapeColumnName(column.getName()));
            } else {
                sb.append(column.getName());
            }
            if (column.getDirection() != Sort.Direction.Ascending) {
                sb.append(" DESC");
            }
            if (column.getNullPrecedence() == null) continue;
            if (column.getNullPrecedence() == Sort.NullPrecedence.NULLS_FIRST) {
                sb.append(" NULLS FIRST");
                continue;
            }
            sb.append(" NULLS LAST");
        }
        return sb.toString();
    }

    private static StringBuilder escapeColumnName(String columnName) {
        StringBuilder sb = new StringBuilder();
        String[] path = columnName.split("\\.");
        for (int j = 0; j < path.length; ++j) {
            if (j > 0) {
                sb.append('.');
            }
            sb.append('`').append(PanacheJpaUtil.unquoteColumnName(path[j])).append('`');
        }
        return sb;
    }

    private static String unquoteColumnName(String columnName) {
        String unquotedColumnName = columnName.charAt(0) == '`' && columnName.charAt(columnName.length() - 1) == '`' ? columnName.substring(1, columnName.length() - 1) : columnName;
        if (unquotedColumnName.indexOf(96) >= 0) {
            throw new PanacheQueryException("Sort column name cannot have backticks");
        }
        return unquotedColumnName;
    }
}

