/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import io.quarkus.bootstrap.runner.QuarkusEntryPoint;
import io.quarkus.runtime.LaunchMode;
import io.smallrye.config.ConfigValue;
import io.smallrye.mutiny.tuples.Functions;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.keycloak.common.profile.ProfileException;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.config.DeprecatedMetadata;
import org.keycloak.config.Option;
import org.keycloak.config.OptionCategory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.KeycloakMain;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.ExecutionExceptionHandler;
import org.keycloak.quarkus.runtime.cli.Help;
import org.keycloak.quarkus.runtime.cli.HelpFactory;
import org.keycloak.quarkus.runtime.cli.OptionRenderer;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.ShortErrorMessageHandler;
import org.keycloak.quarkus.runtime.cli.SubCommandListRenderer;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.cli.command.Main;
import org.keycloak.quarkus.runtime.configuration.ConfigArgsConfigSource;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.DisabledMappersInterceptor;
import org.keycloak.quarkus.runtime.configuration.KcUnmatchedArgumentException;
import org.keycloak.quarkus.runtime.configuration.PropertyMappingInterceptor;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import picocli.CommandLine;

public class Picocli {
    static final String KC_PROVIDER_FILE_PREFIX = "kc.provider.file.";
    public static final String ARG_PREFIX = "--";
    public static final String ARG_SHORT_PREFIX = "-";
    public static final String NO_PARAM_LABEL = "none";
    private final ExecutionExceptionHandler errorHandler = new ExecutionExceptionHandler();
    private Set<PropertyMapper<?>> allowedMappers;
    private final List<String> unrecognizedArgs = new ArrayList<String>();

    public void parseAndRun(List<String> cliArgs) {
        CommandLine cmd = this.createCommandLine(spec -> {}).setUnmatchedArgumentsAllowed(true);
        String[] argArray = cliArgs.toArray(new String[0]);
        try {
            int exitCode;
            CommandLine.ParseResult result = cmd.parseArgs(argArray);
            List commandLineList = result.asCommandLineList();
            cmd = this.createCommandLineForCommand(cliArgs, commandLineList);
            if (Environment.isRebuildCheck()) {
                CommandLine currentCommand = null;
                if (commandLineList.size() > 1) {
                    currentCommand = (CommandLine)commandLineList.get(commandLineList.size() - 1);
                }
                exitCode = this.runReAugmentationIfNeeded(cliArgs, cmd, currentCommand);
            } else {
                PropertyMappers.sanitizeDisabledMappers();
                exitCode = cmd.execute(argArray);
            }
            this.exit(exitCode);
        }
        catch (CommandLine.ParameterException parEx) {
            this.catchParameterException(parEx, cmd, argArray);
        }
        catch (ProfileException | PropertyException proEx) {
            this.usageException(proEx.getMessage(), proEx.getCause());
        }
    }

    private CommandLine createCommandLineForCommand(List<String> cliArgs, List<CommandLine> commandLineList) {
        return this.createCommandLine(spec -> {
            CommandLine.Model.CommandSpec currentSpec = spec;
            Picocli.addHelp(currentSpec);
            for (CommandLine commandLine : commandLineList.subList(1, commandLineList.size())) {
                CommandLine subCommand = (CommandLine)currentSpec.subcommands().get(commandLine.getCommandName());
                if (subCommand == null) {
                    currentSpec = null;
                    break;
                }
                currentSpec = subCommand.getCommandSpec();
                currentSpec.addUnmatchedArgsBinding(CommandLine.Model.UnmatchedArgsBinding.forStringArrayConsumer((CommandLine.Model.ISetter)new CommandLine.Model.ISetter(){

                    public <T> T set(T value) {
                        if (value != null) {
                            Picocli.this.unrecognizedArgs.addAll(Arrays.asList((String[])value));
                        }
                        return null;
                    }
                }));
                Picocli.addHelp(currentSpec);
            }
            if (currentSpec != null) {
                Object patt0$temp;
                CommandLine commandLine = currentSpec.commandLine();
                this.addCommandOptions(cliArgs, commandLine);
                if (commandLine != null && (patt0$temp = commandLine.getCommand()) instanceof AbstractCommand) {
                    AbstractCommand ac = (AbstractCommand)patt0$temp;
                    Environment.setParsedCommand(ac);
                }
            }
            if (Environment.isRebuildCheck()) {
                this.addCommandOptions(cliArgs, (CommandLine)spec.subcommands().get("build"));
            }
        });
    }

    private void catchParameterException(CommandLine.ParameterException parEx, CommandLine cmd, String[] args) {
        int exitCode;
        try {
            exitCode = cmd.getParameterExceptionHandler().handleParseException(parEx, args);
        }
        catch (Exception e) {
            this.errorHandler.error(cmd.getErr(), e.getMessage(), null);
            exitCode = parEx.getCommandLine().getCommandSpec().exitCodeOnInvalidInput();
        }
        this.exit(exitCode);
    }

    public void usageException(String message, Throwable cause) {
        this.errorHandler.error(this.getErrWriter(), message, cause);
        this.exit(2);
    }

    public void exit(int exitCode) {
        System.exit(exitCode);
    }

    private int runReAugmentationIfNeeded(List<String> cliArgs, CommandLine cmd, CommandLine currentCommand) {
        int exitCode = 0;
        if (currentCommand == null) {
            return exitCode;
        }
        String currentCommandName = currentCommand.getCommandName();
        if (Picocli.shouldSkipRebuild(cliArgs, currentCommandName)) {
            return exitCode;
        }
        this.initProfile(cliArgs, currentCommandName);
        if (Picocli.requiresReAugmentation(currentCommand)) {
            PropertyMappers.sanitizeDisabledMappers();
            exitCode = Picocli.runReAugmentation(cliArgs, cmd);
        }
        return exitCode;
    }

    protected void initProfile(List<String> cliArgs, String currentCommandName) {
        if (currentCommandName.equals("start-dev")) {
            Environment.forceDevProfile();
        } else {
            Environment.updateProfile(false);
            ConfigArgsConfigSource.parseConfigArgs(cliArgs, (k, v) -> {
                if (k.equals("-pf") || k.equals("--profile")) {
                    Environment.setProfile(v);
                }
            }, ignored -> {});
        }
    }

    private static boolean shouldSkipRebuild(List<String> cliArgs, String currentCommandName) {
        return cliArgs.contains("--help") || cliArgs.contains("-h") || cliArgs.contains("--help-all") || currentCommandName.equals("build") || currentCommandName.equals("show-config") || currentCommandName.equals("completion") || currentCommandName.equals("update-compatibility");
    }

    private static boolean requiresReAugmentation(CommandLine cmdCommand) {
        Map<String, String> rawPersistedProperties = Configuration.getRawPersistedProperties();
        if (rawPersistedProperties.isEmpty()) {
            return true;
        }
        Properties current = Picocli.getNonPersistedBuildTimeOptions();
        String key = "kc.optimized";
        Optional.ofNullable(rawPersistedProperties.get(key)).ifPresentOrElse(value -> current.put(key, value), () -> current.remove(key));
        return !rawPersistedProperties.equals(current);
    }

    private static List<String> getSanitizedRuntimeCliOptions() {
        ArrayList<String> properties = new ArrayList<String>();
        ConfigArgsConfigSource.parseConfigArgs(ConfigArgsConfigSource.getAllCliArgs(), (key, value) -> {
            PropertyMapper<?> mapper = PropertyMappers.getMapperByCliKey(key);
            if (mapper == null || mapper.isRunTime()) {
                properties.add(key + "=" + PropertyMappers.maskValue(value, mapper));
            }
        }, properties::add);
        return properties;
    }

    private static int runReAugmentation(List<String> cliArgs, CommandLine cmd) {
        if (cmd == null) {
            throw new IllegalStateException("CommandLine is null when trying to run re-augmentation. (CLI args: '%s')".formatted(String.join((CharSequence)", ", cliArgs)));
        }
        if (!Environment.isDevMode()) {
            cmd.getOut().println("Changes detected in configuration. Updating the server image.");
            if (Configuration.isOptimized()) {
                Picocli.checkChangesInBuildOptionsDuringAutoBuild(cmd.getOut());
            }
        }
        ArrayList<String> configArgsList = new ArrayList<String>();
        configArgsList.add("build");
        ConfigArgsConfigSource.parseConfigArgs(cliArgs, (k, v) -> {
            PropertyMapper<?> mapper = PropertyMappers.getMapperByCliKey(k);
            if (mapper != null && mapper.isBuildTime()) {
                configArgsList.add(k + "=" + v);
            }
        }, ignored -> {});
        cmd = cmd.setUnmatchedArgumentsAllowed(true);
        int exitCode = cmd.execute(configArgsList.toArray(new String[0]));
        if (!Environment.isDevMode() && exitCode == cmd.getCommandSpec().exitCodeOnSuccess()) {
            cmd.getOut().printf("Next time you run the server, just run:%n%n\t%s %s %s%n%n", Environment.getCommand(), String.join((CharSequence)" ", Picocli.getSanitizedRuntimeCliOptions()), "--optimized");
        }
        return exitCode;
    }

    private static boolean wasBuildEverRun() {
        return !Configuration.getRawPersistedProperties().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateConfig(List<String> cliArgs, AbstractCommand abstractCommand) {
        this.unrecognizedArgs.removeIf(arg -> {
            PropertyMapper<?> mapper;
            if (arg.contains("=")) {
                arg = arg.substring(0, arg.indexOf("="));
            }
            return (mapper = PropertyMappers.getMapperByCliKey(arg)) != null && mapper.hasWildcard() && this.allowedMappers.contains(mapper);
        });
        if (!this.unrecognizedArgs.isEmpty()) {
            throw new KcUnmatchedArgumentException(abstractCommand.getCommandLine().orElseThrow(), this.unrecognizedArgs);
        }
        if (cliArgs.contains("--optimized") && !Picocli.wasBuildEverRun()) {
            throw new PropertyException(Messages.optimizedUsedForFirstStartup());
        }
        IncludeOptions options = this.getIncludeOptions(cliArgs, abstractCommand, abstractCommand.getName());
        if (!options.includeBuildTime && !options.includeRuntime) {
            return;
        }
        ArrayList ignoredBuildTime = new ArrayList();
        if (!options.includeBuildTime) {
            Picocli.checkChangesInBuildOptions((Functions.TriConsumer<String, String, String>)((Functions.TriConsumer)(key, oldValue, newValue) -> {
                if (key.startsWith(KC_PROVIDER_FILE_PREFIX)) {
                    if (Picocli.timestampChanged(oldValue, newValue)) {
                        throw new PropertyException("A provider JAR was updated since the last build, please rebuild for this to be fully utilized.");
                    }
                } else if (newValue != null && !Picocli.isIgnoredPersistedOption(key) && Configuration.isUserModifiable(Configuration.getConfigValue(key)) && !key.startsWith("quarkus.")) {
                    ignoredBuildTime.add(key);
                }
            }));
        }
        boolean disabledMappersInterceptorEnabled = DisabledMappersInterceptor.isEnabled();
        try {
            PropertyMappingInterceptor.disable();
            DisabledMappersInterceptor.disable();
            ArrayList<String> ignoredRunTime = new ArrayList<String>();
            LinkedHashSet<String> disabledBuildTime = new LinkedHashSet<String>();
            LinkedHashSet<String> disabledRunTime = new LinkedHashSet<String>();
            LinkedHashSet<String> deprecatedInUse = new LinkedHashSet<String>();
            LinkedHashSet<String> missingOption = new LinkedHashSet<String>();
            LinkedHashSet ambiguousSpi = new LinkedHashSet();
            LinkedHashMap<String, String> secondClassOptions = new LinkedHashMap<String, String>();
            HashSet disabledMappers = new HashSet();
            if (options.includeBuildTime) {
                disabledMappers.addAll(PropertyMappers.getDisabledBuildTimeMappers().values());
            }
            if (options.includeRuntime) {
                disabledMappers.addAll(PropertyMappers.getDisabledRuntimeMappers().values());
            }
            HashSet<OptionCategory> categories = new HashSet<OptionCategory>(abstractCommand.getOptionCategories());
            Configuration.getPropertyNames().forEach(name -> {
                ConfigValue value;
                PropertyMapper<?> mapper;
                if (!name.startsWith("kc.")) {
                    return;
                }
                if (!options.includeRuntime) {
                    Picocli.checkRuntimeSpiOptions(name, ignoredRunTime);
                }
                if (PropertyMappers.isMaybeSpiBuildTimeProperty(name)) {
                    ambiguousSpi.add(name);
                }
                if ((mapper = PropertyMappers.getMapper(name)) == null) {
                    return;
                }
                String from = mapper.forKey((String)name).getFrom();
                if (!name.equals(from) && (value = Configuration.getConfigValue(name)).getValue() != null && Configuration.isUserModifiable(value)) {
                    secondClassOptions.put((String)name, from);
                }
                if (!mapper.hasWildcard()) {
                    return;
                }
                if (!categories.contains(mapper.getCategory())) {
                    return;
                }
                this.validateProperty(abstractCommand, options, ignoredRunTime, disabledBuildTime, disabledRunTime, deprecatedInUse, missingOption, disabledMappers, mapper, from);
            });
            ArrayList mappers = new ArrayList(disabledMappers);
            for (OptionCategory category : categories) {
                Optional.ofNullable(PropertyMappers.getRuntimeMappers().get(category)).ifPresent(mappers::addAll);
                Optional.ofNullable(PropertyMappers.getBuildTimeMappers().get(category)).ifPresent(mappers::addAll);
            }
            for (PropertyMapper mapper : mappers) {
                if (mapper.hasWildcard()) continue;
                this.validateProperty(abstractCommand, options, ignoredRunTime, disabledBuildTime, disabledRunTime, deprecatedInUse, missingOption, disabledMappers, mapper, mapper.getFrom());
            }
            if (!missingOption.isEmpty()) {
                throw new PropertyException("The following options are required: \n%s".formatted(String.join((CharSequence)"\n", missingOption)));
            }
            if (!ignoredBuildTime.isEmpty()) {
                throw new PropertyException(String.format("The following build time options have values that differ from what is persisted - the new values will NOT be used until another build is run: %s\n", String.join((CharSequence)", ", ignoredBuildTime)));
            }
            if (!ignoredRunTime.isEmpty()) {
                this.info(String.format("The following run time options were found, but will be ignored during build time: %s\n", String.join((CharSequence)", ", ignoredRunTime)));
            }
            if (!disabledBuildTime.isEmpty()) {
                Picocli.outputDisabledProperties(disabledBuildTime, true, this.getOutWriter());
            } else if (!disabledRunTime.isEmpty()) {
                Picocli.outputDisabledProperties(disabledRunTime, false, this.getOutWriter());
            }
            if (!deprecatedInUse.isEmpty()) {
                Picocli.warn("The following used options or option values are DEPRECATED and will be removed or their behaviour changed in a future release:\n" + String.join((CharSequence)"\n", deprecatedInUse) + "\nConsult the Release Notes for details.", this.getOutWriter());
            }
            if (!ambiguousSpi.isEmpty()) {
                this.warn("The following SPI options are using the legacy format and are not being treated as build time options. Please use the new format with the appropriate -- separators to resolve this ambiguity: " + String.join((CharSequence)"\n", ambiguousSpi));
            }
            secondClassOptions.forEach((key, firstClass) -> Picocli.warn("Please use the first-class option `%s` instead of `%s`".formatted(firstClass, key), this.getOutWriter()));
        }
        finally {
            DisabledMappersInterceptor.enable(disabledMappersInterceptorEnabled);
            PropertyMappingInterceptor.enable();
        }
    }

    static boolean timestampChanged(String oldValue, String newValue) {
        if (newValue != null && oldValue != null) {
            long longNewValue = Long.valueOf(newValue);
            long longOldValue = Long.valueOf(oldValue);
            return longNewValue / 1000L * 1000L != longNewValue || longOldValue / 1000L * 1000L != longNewValue;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateProperty(AbstractCommand abstractCommand, IncludeOptions options, List<String> ignoredRunTime, Set<String> disabledBuildTime, Set<String> disabledRunTime, Set<String> deprecatedInUse, Set<String> missingOption, Set<PropertyMapper<?>> disabledMappers, PropertyMapper<?> mapper, String from) {
        ConfigValue configValue = Configuration.getConfigValue(from);
        String configValueStr = configValue.getValue();
        if (configValueStr != null && !Configuration.isUserModifiable(configValue)) {
            return;
        }
        if (disabledMappers.contains(mapper)) {
            if (PropertyMappers.getMapper(from) != null) {
                return;
            }
            if (!(configValueStr == null || mapper.isRunTime() && Environment.isRebuild().booleanValue())) {
                if (PropertyMapper.isCliOption(configValue)) {
                    throw new KcUnmatchedArgumentException(abstractCommand.getCommandLine().orElseThrow(), List.of(mapper.getCliFormat()));
                }
                Picocli.handleDisabled(mapper.isRunTime() ? disabledRunTime : disabledBuildTime, mapper);
            }
            return;
        }
        if (mapper.isRunTime() && !options.includeRuntime) {
            if (configValueStr != null) {
                ignoredRunTime.add(mapper.getFrom());
            }
            return;
        }
        if (configValueStr == null) {
            if (mapper.isRequired()) {
                Picocli.handleRequired(missingOption, mapper);
            }
            return;
        }
        PropertyMappingInterceptor.enable();
        try {
            mapper.validate(configValue);
        }
        finally {
            PropertyMappingInterceptor.disable();
        }
        mapper.getDeprecatedMetadata().ifPresent(metadata -> Picocli.handleDeprecated(deprecatedInUse, mapper, configValueStr, metadata));
    }

    private static void checkRuntimeSpiOptions(String key, List<String> ignoredRunTime) {
        ConfigValue configValue;
        String configValueStr;
        if (!key.startsWith("kc.spi")) {
            return;
        }
        boolean buildTimeOption = PropertyMappers.isSpiBuildTimeProperty(key);
        if (!buildTimeOption && (configValueStr = (configValue = Configuration.getConfigValue(key)).getValue()) != null && Configuration.isUserModifiable(configValue)) {
            ignoredRunTime.add(key);
        }
    }

    private static void handleDeprecated(Set<String> deprecatedInUse, PropertyMapper<?> mapper, String configValue, DeprecatedMetadata metadata) {
        String optionName;
        HashSet<String> deprecatedValuesInUse = new HashSet<String>();
        if (!metadata.getDeprecatedValues().isEmpty()) {
            deprecatedValuesInUse.addAll(Arrays.asList(configValue.split(",")));
            deprecatedValuesInUse.retainAll(metadata.getDeprecatedValues());
            if (deprecatedValuesInUse.isEmpty()) {
                return;
            }
        }
        if ((optionName = mapper.getFrom()).startsWith("kc.")) {
            optionName = optionName.substring("kc.".length());
        }
        StringBuilder sb = new StringBuilder("\t- ");
        sb.append(optionName);
        if (!deprecatedValuesInUse.isEmpty()) {
            sb.append("=").append(String.join((CharSequence)",", deprecatedValuesInUse));
        }
        if (metadata.getNote() != null || !metadata.getNewOptionsKeys().isEmpty()) {
            sb.append(":");
        }
        if (metadata.getNote() != null) {
            sb.append(" ");
            sb.append(metadata.getNote());
            if (!metadata.getNote().endsWith(".")) {
                sb.append(".");
            }
        }
        if (!metadata.getNewOptionsKeys().isEmpty()) {
            sb.append(" Use ");
            sb.append(String.join((CharSequence)", ", metadata.getNewOptionsKeys()));
            sb.append(".");
        }
        deprecatedInUse.add(sb.toString());
    }

    private static void handleDisabled(Set<String> disabledInUse, PropertyMapper<?> mapper) {
        Picocli.handleMessage(disabledInUse, mapper, PropertyMapper::getEnabledWhen);
    }

    private static void handleRequired(Set<String> requiredOptions, PropertyMapper<?> mapper) {
        Picocli.handleMessage(requiredOptions, mapper, PropertyMapper::getRequiredWhen);
    }

    private static void handleMessage(Set<String> messages, PropertyMapper<?> mapper, Function<PropertyMapper<?>, Optional<String>> retrieveMessage) {
        String optionName = mapper.getOption().getKey();
        StringBuilder sb = new StringBuilder("\t- ");
        sb.append(optionName);
        retrieveMessage.apply(mapper).ifPresent(msg -> sb.append(": ").append((String)msg).append("."));
        messages.add(sb.toString());
    }

    public void warn(String text) {
        Picocli.warn(text, this.getOutWriter());
    }

    public void info(String text) {
        CommandLine.Help.ColorScheme defaultColorScheme = CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.AUTO);
        this.getOutWriter().println(String.valueOf(defaultColorScheme.apply("INFO: ", Arrays.asList(CommandLine.Help.Ansi.Style.fg_green, CommandLine.Help.Ansi.Style.bold))) + text);
    }

    private static void warn(String text, PrintWriter outwriter) {
        CommandLine.Help.ColorScheme defaultColorScheme = CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.AUTO);
        outwriter.println(String.valueOf(defaultColorScheme.apply("WARNING: ", Arrays.asList(CommandLine.Help.Ansi.Style.fg_yellow, CommandLine.Help.Ansi.Style.bold))) + text);
    }

    private static void outputDisabledProperties(Set<String> properties, boolean build, PrintWriter outWriter) {
        Picocli.warn(String.format("The following used %s time options are UNAVAILABLE and will be ignored during %s time:\n %s", build ? "build" : "run", build ? "run" : "build", String.join((CharSequence)"\n", properties)), outWriter);
    }

    public static Properties getNonPersistedBuildTimeOptions() {
        Properties properties = new Properties();
        Configuration.getPropertyNames().forEach(name -> {
            ConfigValue value;
            boolean quarkus = false;
            PropertyMapper<?> mapper = PropertyMappers.getMapper(name);
            if (mapper != null) {
                if (!mapper.isBuildTime()) {
                    return;
                }
                if (properties.containsKey(name = mapper.forKey((String)name).getFrom())) {
                    return;
                }
            } else if (name.startsWith("quarkus")) {
                quarkus = true;
            } else if (!PropertyMappers.isSpiBuildTimeProperty(name)) {
                return;
            }
            if ((value = Configuration.getNonPersistedConfigValue(name)).getValue() == null || value.getConfigSourceName() == null || quarkus && !value.getConfigSourceName().contains("KcQuarkusPropertiesConfigSource")) {
                return;
            }
            String stringValue = value.getValue();
            if (quarkus && value.getRawValue() != null) {
                stringValue = value.getRawValue();
            }
            properties.put(name, stringValue);
        });
        for (File jar : Environment.getProviderFiles().values()) {
            properties.put(String.format("kc.provider.file.%s.last-modified", jar.getName()), String.valueOf(jar.lastModified()));
        }
        if (!Environment.isRebuildCheck()) {
            Configuration.markAsOptimized(properties);
        }
        String profile = org.keycloak.common.util.Environment.getProfile();
        properties.put("kc.profile", profile);
        properties.put(LaunchMode.current().getProfileKey(), profile);
        return properties;
    }

    public CommandLine createCommandLine(Consumer<CommandLine.Model.CommandSpec> consumer) {
        CommandLine.Model.CommandSpec spec = CommandLine.Model.CommandSpec.forAnnotatedObject((Object)new Main(), (CommandLine.IFactory)new CommandLine.IFactory(){

            public <K> K create(Class<K> cls) throws Exception {
                Object result = CommandLine.defaultFactory().create(cls);
                if (result instanceof AbstractCommand) {
                    AbstractCommand ac = (AbstractCommand)result;
                    ac.setPicocli(Picocli.this);
                }
                return (K)result;
            }
        }).name(Environment.getCommand());
        consumer.accept(spec);
        CommandLine cmd = new CommandLine((Object)spec);
        cmd.setExpandAtFiles(false);
        cmd.setPosixClusteredShortOptionsAllowed(false);
        cmd.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)this.errorHandler);
        cmd.setParameterExceptionHandler((CommandLine.IParameterExceptionHandler)new ShortErrorMessageHandler());
        cmd.setHelpFactory((CommandLine.IHelpFactory)new HelpFactory());
        cmd.getHelpSectionMap().put("commandList", new SubCommandListRenderer());
        cmd.setErr(this.getErrWriter());
        cmd.setOut(this.getOutWriter());
        return cmd;
    }

    public PrintWriter getErrWriter() {
        return new PrintWriter(System.err, true);
    }

    public PrintWriter getOutWriter() {
        return new PrintWriter(System.out, true);
    }

    private static void addHelp(CommandLine.Model.CommandSpec currentSpec) {
        try {
            currentSpec.addOption(((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String[])Help.OPTION_NAMES).usageHelp(true).description(new String[]{"This help message."})).build());
        }
        catch (CommandLine.DuplicateOptionAnnotationsException duplicateOptionAnnotationsException) {
            // empty catch block
        }
    }

    private IncludeOptions getIncludeOptions(List<String> cliArgs, AbstractCommand abstractCommand, String commandName) {
        IncludeOptions result = new IncludeOptions();
        if (abstractCommand == null) {
            return result;
        }
        result.includeRuntime = abstractCommand.includeRuntime();
        result.includeBuildTime = abstractCommand.includeBuildTime();
        if (!result.includeBuildTime && !result.includeRuntime) {
            return result;
        }
        if (result.includeRuntime && !result.includeBuildTime) {
            result.includeBuildTime = Environment.isRebuilt() || !cliArgs.contains("--optimized");
        } else if (result.includeBuildTime && !result.includeRuntime) {
            result.includeRuntime = Environment.isRebuildCheck();
        }
        return result;
    }

    private void addCommandOptions(List<String> cliArgs, CommandLine command) {
        if (command != null && command.getCommand() instanceof AbstractCommand) {
            IncludeOptions options = this.getIncludeOptions(cliArgs, (AbstractCommand)command.getCommand(), command.getCommandName());
            if (!options.includeBuildTime && !options.includeRuntime) {
                return;
            }
            this.addOptionsToCli(command, options);
        }
    }

    private void addOptionsToCli(CommandLine commandLine, IncludeOptions includeOptions) {
        EnumMap mappers = new EnumMap(OptionCategory.class);
        if (includeOptions.includeRuntime) {
            mappers.putAll(PropertyMappers.getRuntimeMappers());
        }
        if (includeOptions.includeBuildTime) {
            Picocli.combinePropertyMappers(mappers, PropertyMappers.getBuildTimeMappers());
        }
        Picocli.addMappedOptionsToArgGroups(commandLine, mappers);
        if (CollectionUtil.isEmpty(this.allowedMappers)) {
            this.allowedMappers = mappers.values().stream().flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
        }
    }

    private static <T extends Map<OptionCategory, List<PropertyMapper<?>>>> void combinePropertyMappers(T origMappers, T additionalMappers) {
        for (Map.Entry<OptionCategory, List<PropertyMapper<?>>> entry : additionalMappers.entrySet()) {
            List result = origMappers.getOrDefault(entry.getKey(), new ArrayList());
            result.addAll((Collection)entry.getValue());
            origMappers.put((OptionCategory)entry.getKey(), (List)result);
        }
    }

    private static void addMappedOptionsToArgGroups(CommandLine commandLine, Map<OptionCategory, List<PropertyMapper<?>>> propertyMappers) {
        CommandLine.Model.CommandSpec cSpec = commandLine.getCommandSpec();
        for (OptionCategory category : ((AbstractCommand)commandLine.getCommand()).getOptionCategories()) {
            List<PropertyMapper<?>> mappersInCategory = propertyMappers.get(category);
            if (mappersInCategory == null) continue;
            CommandLine.Model.ArgGroupSpec.Builder argGroupBuilder = CommandLine.Model.ArgGroupSpec.builder().heading(category.getHeading() + ":").order(category.getOrder()).validate(false);
            HashSet<String> alreadyPresentArgs = new HashSet<String>();
            for (PropertyMapper<?> mapper : mappersInCategory) {
                String name = mapper.getCliFormat();
                if (cSpec.optionsMap().containsKey(name)) {
                    name = OptionRenderer.decorateDuplicitOptionName(name);
                }
                if (cSpec.optionsMap().containsKey(name) || alreadyPresentArgs.contains(name)) continue;
                CommandLine.Model.OptionSpec.Builder optBuilder = (CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)name, (String[])new String[0]).description(new String[]{Picocli.getDecoratedOptionDescription(mapper)})).completionCandidates(() -> mapper.getExpectedValues().iterator())).hidden(mapper.isHidden());
                if (mapper.getParamLabel() != null) {
                    optBuilder.paramLabel(mapper.getParamLabel());
                }
                if (mapper.getDefaultValue().isPresent()) {
                    optBuilder.defaultValue(Option.getDefaultValueString(mapper.getDefaultValue().get()));
                }
                optBuilder.arity("1");
                if (mapper.getType() != null) {
                    optBuilder.type(mapper.getType());
                    if (mapper.isList()) {
                        optBuilder.splitRegex(",");
                    } else if (mapper.getType().isEnum()) {
                        optBuilder.type(String.class);
                    }
                } else {
                    optBuilder.type(String.class);
                }
                alreadyPresentArgs.add(name);
                argGroupBuilder.addArg((CommandLine.Model.ArgSpec)optBuilder.build());
            }
            if (argGroupBuilder.args().isEmpty()) continue;
            cSpec.addArgGroup(argGroupBuilder.build());
        }
    }

    private static String getDecoratedOptionDescription(PropertyMapper<?> mapper) {
        StringBuilder transformedDesc = new StringBuilder(Optional.ofNullable(mapper.getDescription()).orElse(""));
        if (mapper.getType() != Boolean.class && !mapper.getExpectedValues().isEmpty()) {
            List<String> decoratedExpectedValues = mapper.getExpectedValues().stream().map(value -> {
                if (mapper.getDeprecatedMetadata().filter(metadata -> metadata.getDeprecatedValues().contains(value)).isPresent()) {
                    return value + " (deprecated)";
                }
                return value;
            }).toList();
            boolean isStrictExpectedValues = mapper.getOption().isStrictExpectedValues();
            boolean isCaseInsensitiveExpectedValues = mapper.getOption().isCaseInsensitiveExpectedValues();
            String printableValues = String.join((CharSequence)", ", decoratedExpectedValues) + (!isStrictExpectedValues ? ", or a custom one" : "");
            transformedDesc.append(String.format(" Possible values are%s: %s.", isCaseInsensitiveExpectedValues ? " (case insensitive)" : "", printableValues));
        }
        mapper.getDefaultValue().map(d -> Option.getDefaultValueString((Object)d).replaceAll("%", "%%")).map(d -> " Default: " + d + ".").ifPresent(transformedDesc::append);
        mapper.getEnabledWhen().map(e -> String.format(" %s.", e)).ifPresent(transformedDesc::append);
        mapper.getRequiredWhen().map(e -> String.format(" %s.", e)).ifPresent(transformedDesc::append);
        mapper.getDeprecatedMetadata().filter(deprecatedMetadata -> deprecatedMetadata.getDeprecatedValues().isEmpty()).ifPresent(deprecatedMetadata -> {
            ArrayList<Object> deprecatedDetails = new ArrayList<Object>();
            Object note = deprecatedMetadata.getNote();
            if (note != null) {
                if (!((String)note).endsWith(".")) {
                    note = (String)note + ".";
                }
                deprecatedDetails.add(note);
            }
            if (!deprecatedMetadata.getNewOptionsKeys().isEmpty()) {
                String s = deprecatedMetadata.getNewOptionsKeys().size() > 1 ? "s" : "";
                deprecatedDetails.add("Use the following option" + s + " instead: " + String.join((CharSequence)", ", deprecatedMetadata.getNewOptionsKeys()) + ".");
            }
            transformedDesc.insert(0, "@|bold DEPRECATED.|@ ");
            if (!deprecatedDetails.isEmpty()) {
                transformedDesc.append(" @|bold ").append(String.join((CharSequence)" ", deprecatedDetails)).append("|@");
            }
        });
        return transformedDesc.toString();
    }

    public static void println(CommandLine cmd, String message) {
        cmd.getOut().println(message);
    }

    public static List<String> parseArgs(String[] rawArgs) throws PropertyException {
        if (rawArgs.length == 0) {
            return List.of();
        }
        ConfigArgsConfigSource.setCliArgs(rawArgs);
        ArrayList<String> args = new ArrayList<String>();
        ConfigArgsConfigSource.parseConfigArgs(List.of(rawArgs), (arg, value) -> {
            if (!arg.startsWith("--spi") && !arg.startsWith("-D")) {
                args.add(arg + "=" + value);
            }
        }, arg -> {
            if (arg.startsWith("--spi")) {
                throw new PropertyException(String.format("spi argument %s requires a value.", arg));
            }
            if (!arg.startsWith("-D")) {
                args.add((String)arg);
            }
        });
        return args;
    }

    private static void checkChangesInBuildOptionsDuringAutoBuild(PrintWriter out) {
        StringBuilder options = new StringBuilder();
        Picocli.checkChangesInBuildOptions((Functions.TriConsumer<String, String, String>)((Functions.TriConsumer)(key, oldValue, newValue) -> Picocli.optionChanged(options, key, oldValue, newValue)));
        if (options.isEmpty()) {
            return;
        }
        out.println(CommandLine.Help.Ansi.AUTO.string("@|bold,red " + "The previous optimized build will be overridden with the following build options:" + options + "\nTo avoid that, run the 'build' command again and then start the optimized server instance using the '--optimized' flag." + "|@"));
    }

    private static void checkChangesInBuildOptions(Functions.TriConsumer<String, String, String> valueChanged) {
        Properties current = Picocli.getNonPersistedBuildTimeOptions();
        Map<String, String> persisted = Configuration.getRawPersistedProperties();
        current.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String persistedValue = (String)persisted.get(key);
            if (!value.equals(persistedValue)) {
                valueChanged.accept((Object)((String)key), (Object)persistedValue, (Object)((String)value));
            }
        }));
        persisted.forEach((key, value) -> {
            if (current.get(key) == null) {
                valueChanged.accept(key, value, null);
            }
        });
    }

    private static void optionChanged(StringBuilder options, String key, String oldValue, String newValue) {
        boolean isIgnored;
        boolean bl = isIgnored = !key.startsWith("kc.") || key.startsWith(KC_PROVIDER_FILE_PREFIX) || Picocli.isIgnoredPersistedOption(key);
        if (!isIgnored) {
            key = key.substring(3);
            options.append("\n\t- ").append(key).append("=").append(Optional.ofNullable(oldValue).orElse("<unset>")).append(" > ").append(key).append("=").append(Optional.ofNullable(newValue).orElse("<unset>"));
        }
    }

    private static boolean isIgnoredPersistedOption(String key) {
        return key.equals("kc.optimized") || key.equals("kc.profile") || key.equals(LaunchMode.current().getProfileKey());
    }

    public void start() {
        KeycloakMain.start(this, this.errorHandler);
    }

    public void build() throws Throwable {
        QuarkusEntryPoint.main((String[])new String[0]);
    }

    private static class IncludeOptions {
        boolean includeRuntime;
        boolean includeBuildTime;

        private IncludeOptions() {
        }
    }
}

