/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteCacheMapper;
import org.infinispan.xsite.commands.remote.XSiteRequest;
import org.infinispan.xsite.metrics.XSiteMetricsCollector;

public abstract class XSiteCacheRequest<T>
implements XSiteRequest<T> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    protected ByteString cacheName;

    protected XSiteCacheRequest(ByteString cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public final CompletionStage<T> invokeInLocalSite(String origin, GlobalComponentRegistry registry) {
        XSiteCacheMapper.LocalCacheInfo cacheInfo = registry.getXSiteCacheMapper().findLocalCache(origin, this.cacheName);
        if (cacheInfo == null) {
            return CompletableFuture.failedFuture((Throwable)log.xsiteCacheNotFound(origin, this.cacheName));
        }
        if (cacheInfo.isLocalOnly()) {
            return CompletableFuture.failedFuture((Throwable)log.xsiteInLocalCache(origin, cacheInfo.cacheName()));
        }
        ComponentRegistry cr = registry.getNamedComponentRegistry(cacheInfo.cacheName());
        if (cr == null || !cr.getStatus().allowInvocations()) {
            return CompletableFuture.failedFuture((Throwable)log.xsiteCacheNotStarted(origin, cacheInfo.cacheName()));
        }
        cr.getComponent(XSiteMetricsCollector.class).recordRequestsReceived(origin);
        return this.invokeInLocalCache(origin, cr);
    }

    protected abstract CompletionStage<T> invokeInLocalCache(String var1, ComponentRegistry var2);

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        ByteString.writeObject(output, this.cacheName);
    }

    @Override
    public XSiteRequest<T> readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.cacheName = ByteString.readObject(input);
        return this;
    }
}

