/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import jakarta.ws.rs.core.Response;
import java.util.function.Function;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.authenticators.browser.WebAuthnPasswordlessAuthenticator;
import org.keycloak.common.Profile;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;

public class WebAuthnConditionalUIAuthenticator
extends WebAuthnPasswordlessAuthenticator {
    private final Function<AuthenticationFlowContext, Response> errorChallenge;

    public WebAuthnConditionalUIAuthenticator(KeycloakSession session, Function<AuthenticationFlowContext, Response> errorChallenge) {
        super(session);
        this.errorChallenge = errorChallenge;
    }

    @Override
    public LoginFormsProvider fillContextForm(AuthenticationFlowContext context) {
        context.form().setAttribute("enableWebAuthnConditionalUI", (Object)Boolean.TRUE);
        return super.fillContextForm(context);
    }

    @Override
    protected Response createErrorResponse(AuthenticationFlowContext context, String errorCase) {
        context.form().setError(errorCase, new Object[]{""});
        context.form().setAttribute("enableWebAuthnConditionalUI", (Object)Boolean.TRUE);
        this.fillContextForm(context);
        return this.errorChallenge.apply(context);
    }

    public boolean isPasskeysEnabled() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.PASSKEYS) && Boolean.TRUE.equals(this.session.getContext().getRealm().getWebAuthnPolicyPasswordless().isPasskeysEnabled());
    }
}

