/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.LongSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.stream.LongStream;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.DoubleCacheStream;
import org.infinispan.IntCacheStream;
import org.infinispan.LongCacheStream;
import org.infinispan.commons.util.IntSet;
import org.infinispan.reactive.publisher.PublisherReducers;
import org.infinispan.stream.impl.AbstractCacheStream;
import org.infinispan.stream.impl.CacheBiConsumers;
import org.infinispan.stream.impl.DistributedCacheStream;
import org.infinispan.stream.impl.DistributedDoubleCacheStream;
import org.infinispan.stream.impl.DistributedIntCacheStream;
import org.infinispan.stream.impl.IntermediateLongCacheStream;
import org.infinispan.stream.impl.intops.primitive.l.AsDoubleLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.BoxedLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.DistinctLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.FilterLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.FlatMapLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.LimitLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.MapLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.MapToDoubleLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.MapToIntLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.MapToObjLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.PeekLongOperation;
import org.infinispan.util.function.SerializableComparator;
import org.infinispan.util.function.SerializableLongConsumer;
import org.infinispan.util.function.SerializableLongFunction;
import org.infinispan.util.function.SerializableLongPredicate;
import org.infinispan.util.function.SerializableLongToDoubleFunction;
import org.infinispan.util.function.SerializableLongToIntFunction;
import org.infinispan.util.function.SerializableLongUnaryOperator;
import org.infinispan.util.function.SerializableObjLongConsumer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

public class DistributedLongCacheStream<Original>
extends AbstractCacheStream<Original, Long, LongStream, LongCacheStream>
implements LongCacheStream {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());

    protected DistributedLongCacheStream(AbstractCacheStream other) {
        super(other);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected LongCacheStream unwrap() {
        return this;
    }

    @Override
    public LongCacheStream filter(LongPredicate predicate) {
        return (LongCacheStream)this.addIntermediateOperation(new FilterLongOperation(predicate));
    }

    @Override
    public LongCacheStream filter(SerializableLongPredicate predicate) {
        return this.filter((LongPredicate)predicate);
    }

    @Override
    public LongCacheStream map(LongUnaryOperator mapper) {
        return (LongCacheStream)this.addIntermediateOperation(new MapLongOperation(mapper));
    }

    @Override
    public LongCacheStream map(SerializableLongUnaryOperator mapper) {
        return this.map((LongUnaryOperator)mapper);
    }

    @Override
    public <U> CacheStream<U> mapToObj(LongFunction<? extends U> mapper) {
        this.addIntermediateOperationMap(new MapToObjLongOperation<U>(mapper));
        return this.cacheStream();
    }

    @Override
    public <U> CacheStream<U> mapToObj(SerializableLongFunction<? extends U> mapper) {
        return this.mapToObj((LongFunction)mapper);
    }

    @Override
    public IntCacheStream mapToInt(LongToIntFunction mapper) {
        this.addIntermediateOperationMap(new MapToIntLongOperation(mapper));
        return this.intCacheStream();
    }

    @Override
    public IntCacheStream mapToInt(SerializableLongToIntFunction mapper) {
        return this.mapToInt((LongToIntFunction)mapper);
    }

    @Override
    public DoubleCacheStream mapToDouble(LongToDoubleFunction mapper) {
        this.addIntermediateOperationMap(new MapToDoubleLongOperation(mapper));
        return this.doubleCacheStream();
    }

    @Override
    public DoubleCacheStream mapToDouble(SerializableLongToDoubleFunction mapper) {
        return this.mapToDouble((LongToDoubleFunction)mapper);
    }

    @Override
    public LongCacheStream flatMap(LongFunction<? extends LongStream> mapper) {
        this.iteratorOperation = AbstractCacheStream.IteratorOperation.FLAT_MAP;
        return (LongCacheStream)this.addIntermediateOperation(new FlatMapLongOperation(mapper));
    }

    @Override
    public LongCacheStream flatMap(SerializableLongFunction<? extends LongStream> mapper) {
        return this.flatMap((LongFunction)mapper);
    }

    @Override
    public LongCacheStream distinct() {
        this.addIntermediateOperation(DistinctLongOperation.getInstance());
        return new IntermediateLongCacheStream(this).distinct();
    }

    @Override
    public LongCacheStream sorted() {
        return new IntermediateLongCacheStream(this).sorted();
    }

    @Override
    public LongCacheStream peek(LongConsumer action) {
        return (LongCacheStream)this.addIntermediateOperation(new PeekLongOperation(action));
    }

    @Override
    public LongCacheStream peek(SerializableLongConsumer action) {
        return this.peek((LongConsumer)action);
    }

    @Override
    public DoubleCacheStream asDoubleStream() {
        this.addIntermediateOperationMap(AsDoubleLongOperation.getInstance());
        return this.doubleCacheStream();
    }

    @Override
    public CacheStream<Long> boxed() {
        this.addIntermediateOperationMap(BoxedLongOperation.getInstance());
        return this.cacheStream();
    }

    @Override
    public LongCacheStream limit(long maxSize) {
        this.addIntermediateOperation(new LimitLongOperation(maxSize));
        return new IntermediateLongCacheStream(this).limit(maxSize);
    }

    @Override
    public LongCacheStream skip(long n) {
        return new IntermediateLongCacheStream(this).skip(n);
    }

    @Override
    public void forEach(LongConsumer action) {
        this.peek(action).iterator().forEachRemaining(ignore -> {});
    }

    @Override
    public void forEach(SerializableLongConsumer action) {
        this.forEach((LongConsumer)action);
    }

    @Override
    public <K, V> void forEach(ObjLongConsumer<Cache<K, V>> action) {
        this.peek(CacheBiConsumers.longConsumer(action)).iterator().forEachRemaining(ignore -> {});
    }

    @Override
    public <K, V> void forEach(SerializableObjLongConsumer<Cache<K, V>> action) {
        this.forEach((ObjLongConsumer<Cache<K, V>>)action);
    }

    @Override
    public void forEachOrdered(LongConsumer action) {
        this.forEach(action);
    }

    @Override
    public long[] toArray() {
        E[] values = this.performPublisherOperation(PublisherReducers.toArrayReducer(), PublisherReducers.toArrayFinalizer());
        long[] results = new long[values.length];
        int i = 0;
        for (Object obj : values) {
            results[i++] = (Long)obj;
        }
        return results;
    }

    @Override
    public long reduce(long identity, LongBinaryOperator op) {
        Function reduce = PublisherReducers.reduce(identity, op::applyAsLong);
        return this.performPublisherOperation(reduce, reduce);
    }

    @Override
    public OptionalLong reduce(LongBinaryOperator op) {
        Function reduce = PublisherReducers.reduce(op::applyAsLong);
        Long result = (Long)this.performPublisherOperation(reduce, reduce);
        if (result == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(result);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.performPublisherOperation(PublisherReducers.collect(supplier, accumulator::accept), PublisherReducers.accumulate(combiner));
    }

    @Override
    public long sum() {
        Function<Publisher<Long>, CompletionStage<Long>> addFunction = PublisherReducers.add();
        return this.performPublisherOperation(addFunction, addFunction);
    }

    @Override
    public OptionalLong min() {
        SerializableComparator serializableComparator = Long::compareTo;
        Function minFunction = PublisherReducers.min(serializableComparator);
        Long min = (Long)this.performPublisherOperation(minFunction, minFunction);
        if (min == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(min);
    }

    @Override
    public OptionalLong max() {
        SerializableComparator serializableComparator = Long::compareTo;
        Function maxFunction = PublisherReducers.max(serializableComparator);
        Long max = (Long)this.performPublisherOperation(maxFunction, maxFunction);
        if (max == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(max);
    }

    @Override
    public OptionalDouble average() {
        LongSummaryStatistics lss = this.summaryStatistics();
        if (lss.getCount() == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(lss.getAverage());
    }

    @Override
    public LongSummaryStatistics summaryStatistics() {
        return (LongSummaryStatistics)this.performPublisherOperation(PublisherReducers.reduceWith(LongSummaryStatistics::new, (lss, longValue) -> {
            lss.accept((long)longValue);
            return lss;
        }), PublisherReducers.reduce((first, second) -> {
            first.combine((LongSummaryStatistics)second);
            return first;
        }));
    }

    @Override
    public boolean anyMatch(LongPredicate predicate) {
        return this.performPublisherOperation(PublisherReducers.anyMatch(predicate::test), PublisherReducers.or());
    }

    @Override
    public boolean allMatch(LongPredicate predicate) {
        return this.performPublisherOperation(PublisherReducers.allMatch(predicate::test), PublisherReducers.and());
    }

    @Override
    public boolean noneMatch(LongPredicate predicate) {
        return this.performPublisherOperation(PublisherReducers.noneMatch(predicate::test), PublisherReducers.and());
    }

    @Override
    public OptionalLong findFirst() {
        return this.findAny();
    }

    @Override
    public OptionalLong findAny() {
        Function function = PublisherReducers.findFirst();
        Long value = (Long)this.performPublisherOperation(function, function);
        if (value == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(value);
    }

    @Override
    public PrimitiveIterator.OfLong iterator() {
        return this.remoteIterator();
    }

    PrimitiveIterator.OfLong remoteIterator() {
        this.intermediateOperations.add(BoxedLongOperation.getInstance());
        DistributedCacheStream stream = new DistributedCacheStream((AbstractCacheStream)this);
        Iterator<Long> iterator = stream.iterator();
        return new LongIteratorToPrimitiveLong(iterator);
    }

    @Override
    public Spliterator.OfLong spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 0);
    }

    @Override
    public long count() {
        return this.performPublisherOperation(PublisherReducers.count(), PublisherReducers.add());
    }

    @Override
    public LongCacheStream sequentialDistribution() {
        this.parallelDistribution = false;
        return this;
    }

    @Override
    public LongCacheStream parallelDistribution() {
        this.parallelDistribution = true;
        return this;
    }

    @Override
    public LongCacheStream filterKeySegments(IntSet segments) {
        this.segmentsToFilter = segments;
        return this;
    }

    @Override
    public LongCacheStream filterKeys(Set<?> keys) {
        this.keysToFilter = keys;
        return this;
    }

    @Override
    public LongCacheStream distributedBatchSize(int batchSize) {
        this.distributedBatchSize = batchSize;
        return this;
    }

    @Override
    public LongCacheStream segmentCompletionListener(BaseCacheStream.SegmentCompletionListener listener) {
        this.segmentCompletionListener = this.segmentCompletionListener == null ? listener : DistributedLongCacheStream.composeWithExceptions(this.segmentCompletionListener, listener);
        return this;
    }

    @Override
    public LongCacheStream disableRehashAware() {
        this.rehashAware = false;
        return this;
    }

    @Override
    public LongCacheStream timeout(long timeout, TimeUnit unit) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be greater than 0");
        }
        this.timeout = timeout;
        this.timeoutUnit = unit;
        return this;
    }

    protected <R> DistributedCacheStream<Original, R> cacheStream() {
        return new DistributedCacheStream((AbstractCacheStream)this);
    }

    protected DistributedDoubleCacheStream<Original> doubleCacheStream() {
        return new DistributedDoubleCacheStream((AbstractCacheStream)this);
    }

    protected DistributedIntCacheStream<Original> intCacheStream() {
        return new DistributedIntCacheStream((AbstractCacheStream)this);
    }

    static class LongIteratorToPrimitiveLong
    implements PrimitiveIterator.OfLong {
        private final Iterator<Long> iterator;

        LongIteratorToPrimitiveLong(Iterator<Long> iterator) {
            this.iterator = iterator;
        }

        @Override
        public long nextLong() {
            return this.iterator.next();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }
}

