/*
 * Decompiled with CFR 0.152.
 */
package org.codejive.properties;

import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

class PropertiesParser {
    private final Reader rdr;
    private Type state;
    private int pch;
    private StringBuilder str;
    private boolean hasEscapes;

    public PropertiesParser(Reader rdr) throws IOException {
        this.rdr = rdr;
        this.state = null;
        this.str = new StringBuilder();
        this.readChar();
    }

    public static Stream<Token> tokens(final Reader rdr) throws IOException {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<Token>(0L, 0){
            final PropertiesParser p;
            {
                super(x0, x1);
                this.p = new PropertiesParser(rdr);
            }

            @Override
            public boolean tryAdvance(Consumer<? super Token> action) {
                try {
                    Token token = this.p.nextToken();
                    if (token != null) {
                        action.accept(token);
                        return true;
                    }
                    return false;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }, false);
    }

    public Token nextToken() throws IOException {
        int ch = this.peekChar();
        if (PropertiesParser.isEof(ch)) {
            return null;
        }
        Function<Integer, Boolean> isValid = c -> false;
        Type nextState = null;
        if (this.state == null) {
            if (PropertiesParser.isCommentChar(ch)) {
                this.state = Type.COMMENT;
                isValid = c -> !PropertiesParser.isEol(c) && !PropertiesParser.isEof(c);
            } else if (PropertiesParser.isWhitespaceEolChar(ch)) {
                this.state = Type.WHITESPACE;
                AtomicInteger oldc = new AtomicInteger(-1);
                isValid = c -> PropertiesParser.isWhitespaceEolChar(c) && !PropertiesParser.isEol(oldc.getAndSet((int)c));
            } else {
                this.state = Type.KEY;
                isValid = c -> !PropertiesParser.isSeparatorChar(c) && !PropertiesParser.isWhitespaceChar(c) && !PropertiesParser.isEol(c) && !PropertiesParser.isEof(c);
                nextState = Type.SEPARATOR;
            }
        } else if (this.state == Type.SEPARATOR) {
            AtomicBoolean once = new AtomicBoolean(true);
            isValid = c -> PropertiesParser.isWhitespaceChar(c) || PropertiesParser.isSeparatorChar(c) && once.getAndSet(false);
            nextState = Type.VALUE;
        } else if (this.state == Type.VALUE) {
            isValid = c -> !PropertiesParser.isEol(c) && !PropertiesParser.isEof(c);
        }
        while (isValid.apply(ch).booleanValue()) {
            this.addChar(this.readChar());
            ch = this.peekChar();
        }
        String text = this.string();
        Token token = this.hasEscapes ? new Token(this.state, text, PropertiesParser.unescape(text)) : new Token(this.state, text);
        this.hasEscapes = false;
        this.state = nextState;
        return token;
    }

    private int peekChar() {
        return this.pch;
    }

    private int readChar() throws IOException {
        int ch = this.pch;
        this.pch = this.rdr.read();
        return ch;
    }

    private void addChar(int ch) throws IOException {
        this.str.append((char)ch);
        if (ch == 92) {
            this.hasEscapes = true;
            int ch2 = this.readChar();
            this.str.append((char)ch2);
            if (ch2 == 117) {
                for (int i = 0; i < 4; ++i) {
                    int chu = this.readChar();
                    if (!PropertiesParser.isHexDigitChar(chu)) {
                        throw new IOException("Invalid unicode escape character: " + chu);
                    }
                    this.str.append((char)chu);
                }
            } else {
                this.readEol(ch2);
            }
        } else {
            this.readEol(ch);
        }
    }

    private void readEol(int ch) throws IOException {
        if (ch == 13 && this.peekChar() == 10) {
            this.str.append((char)this.readChar());
        }
    }

    private String string() {
        String result = this.str.toString();
        this.str.setLength(0);
        return result;
    }

    static String unescape(String escape) {
        StringBuilder txt = new StringBuilder();
        block9: for (int i = 0; i < escape.length(); ++i) {
            char ch = escape.charAt(i);
            if (ch == '\\') {
                ch = escape.charAt(++i);
                switch (ch) {
                    case 't': {
                        txt.append('\t');
                        break;
                    }
                    case 'f': {
                        txt.append('\f');
                        break;
                    }
                    case 'n': {
                        txt.append('\n');
                        break;
                    }
                    case 'r': {
                        txt.append('\r');
                        break;
                    }
                    case 'u': {
                        String num = escape.substring(i + 1, i + 5);
                        txt.append((char)Integer.parseInt(num, 16));
                        i += 4;
                        break;
                    }
                    case '\r': {
                        if (i < escape.length() - 1 && escape.charAt(i + 1) == '\n') {
                            ++i;
                        }
                    }
                    case '\n': {
                        while (i < escape.length() - 1 && PropertiesParser.isWhitespaceChar(ch = escape.charAt(i + 1))) {
                            ++i;
                        }
                        continue block9;
                    }
                    default: {
                        txt.append(ch);
                        break;
                    }
                }
                continue;
            }
            txt.append(ch);
        }
        return txt.toString();
    }

    private static boolean isSeparatorChar(int ch) {
        return ch == 61 || ch == 58;
    }

    private static boolean isWhitespaceChar(int ch) {
        return ch == 32 || ch == 9 || ch == 12;
    }

    private static boolean isWhitespaceEolChar(int ch) {
        return PropertiesParser.isWhitespaceChar(ch) || PropertiesParser.isEol(ch);
    }

    private static boolean isCommentChar(int ch) {
        return ch == 35 || ch == 33;
    }

    private static boolean isHexDigitChar(int ch) {
        int uch = Character.toUpperCase(ch);
        return Character.isDigit(ch) || uch >= 65 && uch <= 70;
    }

    private static boolean isEol(int ch) {
        return ch == 10 || ch == 13;
    }

    private static boolean isEof(int ch) {
        return ch == -1;
    }

    public static class Token {
        final Type type;
        final String raw;
        final String text;
        public static final Token EOL = new Token(Type.WHITESPACE, "\n");

        Token(Type type, String raw) {
            this(type, raw, null);
        }

        Token(Type type, String raw, String text) {
            this.type = type;
            this.raw = raw;
            if (raw.equals(text)) {
                text = null;
            }
            this.text = text;
        }

        public Type getType() {
            return this.type;
        }

        public String getRaw() {
            return this.raw;
        }

        public String getText() {
            return this.text != null ? this.text : this.raw;
        }

        public boolean isEol() {
            char ch = this.raw.charAt(this.raw.length() - 1);
            return this.type == Type.WHITESPACE && PropertiesParser.isEol(ch);
        }

        public boolean isWs() {
            char ch = this.raw.charAt(this.raw.length() - 1);
            return this.type == Type.WHITESPACE && !PropertiesParser.isEol(ch);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Token)) {
                return false;
            }
            Token token = (Token)o;
            return this.type == token.type && Objects.equals(this.getText(), token.getText());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.getText()});
        }

        public String toString() {
            if (this.text == null) {
                return "Token(" + (Object)((Object)this.type) + ", '" + this.raw + "')";
            }
            return "Token(" + (Object)((Object)this.type) + ", '" + this.raw + "', '" + this.text + "')";
        }
    }

    public static enum Type {
        KEY,
        SEPARATOR,
        VALUE,
        COMMENT,
        WHITESPACE;

    }
}

